/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;

public class MeteredClient
implements Client {
    private final Client client;
    private final MetricRegistry metricRegistry;
    private final FeignMetricName metricName;
    private final MetricSuppliers metricSuppliers;

    public MeteredClient(Client client, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.client = client;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Client.class);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        RequestTemplate template = request.requestTemplate();
        try (Timer.Context classTimer = this.metricRegistry.timer(this.metricName.metricName(template.methodMetadata(), template.feignTarget()), this.metricSuppliers.timers()).time();){
            Response response = this.client.execute(request, options);
            return response;
        }
    }
}

