/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MetricSuppliers;
import java.io.IOException;

public class MeteredClient
implements Client {
    private final Client client;
    private final MetricRegistry metricRegistry;
    private final FeignMetricName metricName;
    private final MetricSuppliers metricSuppliers;

    public MeteredClient(Client client, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.client = client;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Client.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        RequestTemplate template = request.requestTemplate();
        try (Timer.Context classTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.metricName.metricName(template.methodMetadata(), template.feignTarget()), (String[])new String[]{"uri", template.methodMetadata().template().path()}), this.metricSuppliers.timers()).time();){
            Response response = this.client.execute(request, options);
            this.metricRegistry.meter(MetricRegistry.name((String)this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "http_response_code"), (String[])new String[]{"status_group", response.status() / 100 + "xx", "http_status", String.valueOf(response.status()), "uri", template.methodMetadata().template().path()}), this.metricSuppliers.meters()).mark();
            Response response2 = response;
            return response2;
        }
        catch (FeignException e) {
            this.metricRegistry.meter(MetricRegistry.name((String)this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "http_response_code"), (String[])new String[]{"status_group", e.status() / 100 + "xx", "http_status", String.valueOf(e.status()), "uri", template.methodMetadata().template().path()}), this.metricSuppliers.meters()).mark();
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

