/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.events;

import io.reactivex.netty.RxNetty;
import java.util.concurrent.TimeUnit;

public class Clock {
    public static final long SYSTEM_TIME_DISABLED_TIME = -1L;
    private final long startTimeNanos = System.nanoTime();
    private long endTimeNanos = -1L;
    private long durationNanos = -1L;

    public long stop() {
        if (-1L != this.endTimeNanos) {
            this.endTimeNanos = System.nanoTime();
            this.durationNanos = this.endTimeNanos - this.startTimeNanos;
        }
        return this.durationNanos;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getStartTime(TimeUnit targetUnit) {
        return targetUnit.convert(this.startTimeNanos, TimeUnit.NANOSECONDS);
    }

    public long getDurationInNanos() {
        if (this.isRunning()) {
            throw new IllegalStateException("The clock is not yet stopped.");
        }
        return this.durationNanos;
    }

    public long getDuration(TimeUnit targetUnit) {
        if (this.isRunning()) {
            throw new IllegalStateException("The clock is not yet stopped.");
        }
        return targetUnit.convert(this.durationNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isRunning() {
        return -1L != this.durationNanos;
    }

    public static long newStartTimeNanos() {
        return RxNetty.isEventPublishingDisabled() ? -1L : System.nanoTime();
    }

    public static long newStartTime(TimeUnit timeUnit) {
        if (RxNetty.isEventPublishingDisabled()) {
            return -1L;
        }
        if (TimeUnit.NANOSECONDS == timeUnit) {
            return Clock.newStartTimeNanos();
        }
        return timeUnit.convert(Clock.newStartTimeNanos(), TimeUnit.NANOSECONDS);
    }

    public static long onEnd(long startTime, TimeUnit timeUnit) {
        if (RxNetty.isEventPublishingDisabled()) {
            return -1L;
        }
        if (TimeUnit.NANOSECONDS == timeUnit) {
            return Clock.onEndNanos(startTime);
        }
        long startTimeNanos = TimeUnit.NANOSECONDS.convert(startTime, timeUnit);
        return timeUnit.convert(Clock.onEndNanos(startTimeNanos), TimeUnit.NANOSECONDS);
    }

    public static long onEndNanos(long startTimeNanos) {
        if (RxNetty.isEventPublishingDisabled()) {
            return -1L;
        }
        return System.nanoTime() - startTimeNanos;
    }
}

