/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import java.nio.charset.Charset;
import java.util.List;

public class LineReader {
    public static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final ByteProcessor LINE_END_FINDER = new ByteProcessor(){
        public static final char LF = '\n';

        @Override
        public boolean process(byte value) throws Exception {
            char nextByte = (char)value;
            return '\n' != nextByte;
        }
    };
    private ByteBuf incompleteBuffer;
    private final int maxLineLength;
    private final Charset encoding;

    public LineReader() {
        this(Integer.MAX_VALUE, Charset.defaultCharset());
    }

    public LineReader(int maxLineLength, Charset encoding) {
        this.maxLineLength = maxLineLength;
        this.encoding = encoding;
    }

    public void decode(ByteBuf in, List<Object> out, ByteBufAllocator allocator) {
        while (in.isReadable()) {
            String line;
            int startIndex = in.readerIndex();
            int lastReadIndex = in.forEachByte(LINE_END_FINDER);
            if (-1 == lastReadIndex) {
                if (null == this.incompleteBuffer) {
                    this.incompleteBuffer = allocator.buffer(256, this.maxLineLength);
                }
                this.incompleteBuffer.ensureWritable(in.readableBytes());
                this.incompleteBuffer.writeBytes(in);
                continue;
            }
            ByteBuf lineBuf = in.readSlice(lastReadIndex - startIndex);
            if (null != this.incompleteBuffer) {
                line = this.incompleteBuffer.toString(this.encoding) + lineBuf.toString(this.encoding);
                this.incompleteBuffer.release();
                this.incompleteBuffer = null;
            } else {
                line = lineBuf.toString(this.encoding);
            }
            out.add(line);
            in.skipBytes(1);
        }
    }

    public void decodeLast(ByteBuf in, List<Object> out, ByteBufAllocator allocator) {
        this.decode(in, out, allocator);
        if (null != this.incompleteBuffer && this.incompleteBuffer.isReadable()) {
            out.add(this.incompleteBuffer.toString(this.encoding));
        }
    }

    public void dispose() {
        if (null != this.incompleteBuffer) {
            this.incompleteBuffer.release();
        }
    }

    public static boolean isLineDelimiter(char c) {
        return c == '\r' || c == '\n';
    }

    ByteBuf getIncompleteBuffer() {
        return this.incompleteBuffer;
    }
}

