/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.client.ChannelProviderFactory;
import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.HostConnector;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientInterceptorChain;
import io.reactivex.netty.protocol.http.client.HttpClientInterceptorChainImpl;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.RequestProvider;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventPublisher;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.protocol.http.client.internal.HttpChannelProviderFactory;
import io.reactivex.netty.protocol.http.client.internal.HttpClientRequestImpl;
import io.reactivex.netty.protocol.http.client.internal.HttpClientToConnectionBridge;
import io.reactivex.netty.protocol.http.ws.client.Ws7To13UpgradeHandler;
import io.reactivex.netty.protocol.tcp.client.TcpClient;
import io.reactivex.netty.protocol.tcp.client.TcpClientImpl;
import io.reactivex.netty.ssl.SslCodec;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public final class HttpClientImpl<I, O>
extends HttpClient<I, O> {
    private final TcpClient<?, HttpClientResponse<O>> client;
    private final int maxRedirects;
    private final HttpClientEventPublisher clientEventPublisher;
    private final RequestProvider<I, O> requestProvider;

    private HttpClientImpl(final TcpClient<?, HttpClientResponse<O>> client, final int maxRedirects, HttpClientEventPublisher clientEventPublisher) {
        this.client = client;
        this.maxRedirects = maxRedirects;
        this.clientEventPublisher = clientEventPublisher;
        this.requestProvider = new RequestProvider<I, O>(){

            @Override
            public HttpClientRequest<I, O> createRequest(HttpVersion version, HttpMethod method, String uri) {
                return HttpClientRequestImpl.create(version, method, uri, client, maxRedirects);
            }
        };
    }

    @Override
    public HttpClientRequest<I, O> createGet(String uri) {
        return this.createRequest(HttpMethod.GET, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPost(String uri) {
        return this.createRequest(HttpMethod.POST, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPut(String uri) {
        return this.createRequest(HttpMethod.PUT, uri);
    }

    @Override
    public HttpClientRequest<I, O> createDelete(String uri) {
        return this.createRequest(HttpMethod.DELETE, uri);
    }

    @Override
    public HttpClientRequest<I, O> createHead(String uri) {
        return this.createRequest(HttpMethod.HEAD, uri);
    }

    @Override
    public HttpClientRequest<I, O> createOptions(String uri) {
        return this.createRequest(HttpMethod.OPTIONS, uri);
    }

    @Override
    public HttpClientRequest<I, O> createPatch(String uri) {
        return this.createRequest(HttpMethod.PATCH, uri);
    }

    @Override
    public HttpClientRequest<I, O> createTrace(String uri) {
        return this.createRequest(HttpMethod.TRACE, uri);
    }

    @Override
    public HttpClientRequest<I, O> createConnect(String uri) {
        return this.createRequest(HttpMethod.CONNECT, uri);
    }

    @Override
    public HttpClientRequest<I, O> createRequest(HttpMethod method, String uri) {
        return this.createRequest(HttpVersion.HTTP_1_1, method, uri);
    }

    @Override
    public HttpClientRequest<I, O> createRequest(HttpVersion version, HttpMethod method, String uri) {
        return this.requestProvider.createRequest(version, method, uri);
    }

    @Override
    public HttpClientInterceptorChain<I, O> intercept() {
        return new HttpClientInterceptorChainImpl<I, O>(this.requestProvider, this.clientEventPublisher);
    }

    @Override
    public HttpClientImpl<I, O> readTimeOut(int timeOut, TimeUnit timeUnit) {
        return this._copy(this.client.readTimeOut(timeOut, timeUnit), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> followRedirects(int maxRedirects) {
        return this._copy(this.client, maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> followRedirects(boolean follow) {
        return this._copy(this.client, follow ? 5 : -1);
    }

    @Override
    public <T> HttpClientImpl<I, O> channelOption(ChannelOption<T> option, T value) {
        return this._copy(this.client.channelOption(option, value), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerFirst(String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerFirst(name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerFirst(group, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerLast(String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerLast(name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerLast(group, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerBefore(baseName, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerBefore(group, baseName, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerAfter(baseName, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._copy(HttpClientImpl.castClient(this.client.addChannelHandlerAfter(group, baseName, name, handlerFactory)), this.maxRedirects);
    }

    @Override
    public <II, OO> HttpClientImpl<II, OO> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        return this._copy(HttpClientImpl.castClient(this.client.pipelineConfigurator(pipelineConfigurator)), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> secure(Func1<ByteBufAllocator, SSLEngine> sslEngineFactory) {
        return this._copy(this.client.secure(sslEngineFactory), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> secure(SSLEngine sslEngine) {
        return this._copy(this.client.secure(sslEngine), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> secure(SslCodec sslCodec) {
        return this._copy(this.client.secure(sslCodec), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> unsafeSecure() {
        return this._copy(this.client.unsafeSecure(), this.maxRedirects);
    }

    @Override
    @Deprecated
    public HttpClientImpl<I, O> enableWireLogging(LogLevel wireLoggingLevel) {
        return this._copy(this.client.enableWireLogging(wireLoggingLevel), this.maxRedirects);
    }

    @Override
    public HttpClient<I, O> enableWireLogging(String name, LogLevel wireLoggingLevel) {
        return this._copy(this.client.enableWireLogging(name, wireLoggingLevel), this.maxRedirects);
    }

    @Override
    public HttpClientImpl<I, O> channelProvider(ChannelProviderFactory providerFactory) {
        return this._copy(this.client.channelProvider(new HttpChannelProviderFactory(this.clientEventPublisher, providerFactory)), this.maxRedirects);
    }

    @Override
    public Subscription subscribe(HttpClientEventsListener listener) {
        return this.clientEventPublisher.subscribe(listener);
    }

    public static HttpClient<ByteBuf, ByteBuf> create(final ConnectionProviderFactory<ByteBuf, ByteBuf> providerFactory, Observable<Host> hostStream) {
        ConnectionProviderFactory<ByteBuf, ByteBuf> cpf = new ConnectionProviderFactory<ByteBuf, ByteBuf>(){

            @Override
            public ConnectionProvider<ByteBuf, ByteBuf> newProvider(Observable<HostConnector<ByteBuf, ByteBuf>> hosts) {
                return providerFactory.newProvider(hosts.map(new Func1<HostConnector<ByteBuf, ByteBuf>, HostConnector<ByteBuf, ByteBuf>>(){

                    @Override
                    public HostConnector<ByteBuf, ByteBuf> call(HostConnector<ByteBuf, ByteBuf> hc) {
                        HttpClientEventPublisher hcep = new HttpClientEventPublisher();
                        hc.subscribe(hcep);
                        return new HostConnector<ByteBuf, ByteBuf>(hc.getHost(), hc.getConnectionProvider(), hcep, hcep, hcep);
                    }
                }));
            }
        };
        return HttpClientImpl._newClient(TcpClientImpl.create(cpf, hostStream));
    }

    public static HttpClient<ByteBuf, ByteBuf> create(SocketAddress socketAddress) {
        return HttpClientImpl._newClient(TcpClientImpl.create(socketAddress));
    }

    private static HttpClient<ByteBuf, ByteBuf> _newClient(TcpClient<ByteBuf, ByteBuf> tcpClient) {
        HttpClientEventPublisher clientEventPublisher = new HttpClientEventPublisher();
        TcpClient client = tcpClient.pipelineConfigurator(new Action1<ChannelPipeline>(){

            @Override
            public void call(ChannelPipeline pipeline) {
                pipeline.addLast(HttpHandlerNames.HttpClientCodec.getName(), (ChannelHandler)new HttpClientCodec());
                pipeline.addLast(new HttpClientToConnectionBridge());
                pipeline.addLast(HttpHandlerNames.WsClientUpgradeHandler.getName(), (ChannelHandler)new Ws7To13UpgradeHandler());
            }
        }).channelProvider(new HttpChannelProviderFactory(clientEventPublisher));
        client.subscribe(clientEventPublisher);
        return new HttpClientImpl<ByteBuf, ByteBuf>(client, -1, clientEventPublisher);
    }

    private static <OO> TcpClient<?, HttpClientResponse<OO>> castClient(TcpClient<?, ?> rawTypes) {
        return rawTypes;
    }

    private <II, OO> HttpClientImpl<II, OO> _copy(TcpClient<?, HttpClientResponse<OO>> newClient, int maxRedirects) {
        return new HttpClientImpl<I, OO>(newClient, maxRedirects, this.clientEventPublisher);
    }
}

