/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.pool;

import io.reactivex.netty.client.pool.IdleConnectionsHolder;
import io.reactivex.netty.client.pool.PooledConnection;
import java.util.concurrent.ConcurrentLinkedQueue;
import rx.Observable;
import rx.Subscriber;

public class FIFOIdleConnectionsHolder<W, R>
extends IdleConnectionsHolder<W, R> {
    private final ConcurrentLinkedQueue<PooledConnection<R, W>> idleConnections = new ConcurrentLinkedQueue();
    private final Observable<PooledConnection<R, W>> pollObservable = Observable.create(new Observable.OnSubscribe<PooledConnection<R, W>>(){

        @Override
        public void call(Subscriber<? super PooledConnection<R, W>> subscriber) {
            PooledConnection idleConnection;
            while (!subscriber.isUnsubscribed() && (idleConnection = (PooledConnection)FIFOIdleConnectionsHolder.this.idleConnections.poll()) != null) {
                subscriber.onNext(idleConnection);
            }
            if (!subscriber.isUnsubscribed()) {
                subscriber.onCompleted();
            }
        }
    });
    private final Observable<PooledConnection<R, W>> peekObservable = Observable.from(this.idleConnections);

    @Override
    public Observable<PooledConnection<R, W>> poll() {
        return this.pollObservable;
    }

    @Override
    public Observable<PooledConnection<R, W>> peek() {
        return this.peekObservable;
    }

    @Override
    public void add(PooledConnection<R, W> toAdd) {
        this.idleConnections.add(toAdd);
    }

    @Override
    public boolean remove(PooledConnection<R, W> toRemove) {
        return this.idleConnections.remove(toRemove);
    }
}

