/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.HandlerNames;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ChannelSubscriberEvent;
import io.reactivex.netty.channel.ConnectionCreationFailedEvent;
import io.reactivex.netty.channel.DetachedChannelPipeline;
import io.reactivex.netty.channel.WriteTransformer;
import io.reactivex.netty.client.ChannelProvider;
import io.reactivex.netty.client.ChannelProviderFactory;
import io.reactivex.netty.client.ClientConnectionToChannelBridge;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.events.Clock;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.ssl.DefaultSslCodec;
import io.reactivex.netty.ssl.SslCodec;
import io.reactivex.netty.util.LoggingHandlerFactory;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class ClientState<W, R> {
    private final Observable<Host> hostStream;
    private final ConnectionProviderFactory<W, R> factory;
    private final DetachedChannelPipeline detachedPipeline;
    private final Map<ChannelOption<?>, Object> options;
    private final boolean isSecure;
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends Channel> channelClass;
    private final ChannelProviderFactory channelProviderFactory;

    protected ClientState(Observable<Host> hostStream, ConnectionProviderFactory<W, R> factory, DetachedChannelPipeline detachedPipeline, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        this.eventLoopGroup = eventLoopGroup;
        this.channelClass = channelClass;
        this.options = new LinkedHashMap();
        this.hostStream = hostStream;
        this.factory = factory;
        this.detachedPipeline = detachedPipeline;
        this.isSecure = false;
        this.channelProviderFactory = new ChannelProviderFactory(){

            @Override
            public ChannelProvider newProvider(Host host, EventSource<? super ClientEventListener> eventSource, EventPublisher publisher, ClientEventListener clientPublisher) {
                return new ChannelProvider(){

                    @Override
                    public Observable<Channel> newChannel(Observable<Channel> input) {
                        return input;
                    }
                };
            }
        };
    }

    protected ClientState(ClientState<W, R> toCopy, ChannelOption<?> option, Object value) {
        this.options = new LinkedHashMap(toCopy.options);
        this.options.put(option, value);
        this.detachedPipeline = toCopy.detachedPipeline;
        this.hostStream = toCopy.hostStream;
        this.factory = toCopy.factory;
        this.eventLoopGroup = toCopy.eventLoopGroup;
        this.channelClass = toCopy.channelClass;
        this.isSecure = toCopy.isSecure;
        this.channelProviderFactory = toCopy.channelProviderFactory;
    }

    protected ClientState(ClientState<?, ?> toCopy, DetachedChannelPipeline newPipeline, boolean secure) {
        ClientState toCopyCast = super.cast();
        this.options = toCopy.options;
        this.hostStream = toCopy.hostStream;
        this.factory = toCopyCast.factory;
        this.eventLoopGroup = toCopy.eventLoopGroup;
        this.channelClass = toCopy.channelClass;
        this.detachedPipeline = newPipeline;
        this.isSecure = secure;
        this.channelProviderFactory = toCopyCast.channelProviderFactory;
    }

    protected ClientState(ClientState<?, ?> toCopy, ChannelProviderFactory newFactory) {
        ClientState toCopyCast = super.cast();
        this.options = toCopy.options;
        this.hostStream = toCopy.hostStream;
        this.factory = toCopyCast.factory;
        this.eventLoopGroup = toCopy.eventLoopGroup;
        this.channelClass = toCopy.channelClass;
        this.detachedPipeline = toCopy.detachedPipeline;
        this.channelProviderFactory = newFactory;
        this.isSecure = toCopy.isSecure;
    }

    protected ClientState(ClientState<?, ?> toCopy, SslCodec sslCodec) {
        this(toCopy, toCopy.detachedPipeline.copy(new TailHandlerFactory(true)).configure(sslCodec), true);
    }

    public <T> ClientState<W, R> channelOption(ChannelOption<T> option, T value) {
        return new ClientState<W, R>(this, option, value);
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerFirst(String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addFirst(name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addFirst(group, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerLast(String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addLast(name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addLast(group, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addBefore(baseName, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addBefore(group, baseName, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addAfter(baseName, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.addAfter(group, baseName, name, handlerFactory);
        return copy;
    }

    public <WW, RR> ClientState<WW, RR> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        ClientState<WW, RR> copy = this.copy();
        copy.detachedPipeline.configure(pipelineConfigurator);
        return copy;
    }

    public ClientState<W, R> enableWireLogging(LogLevel wireLoggingLevel) {
        return this.enableWireLogging(LoggingHandler.class.getName(), wireLoggingLevel);
    }

    public ClientState<W, R> enableWireLogging(String name, LogLevel wireLoggingLevel) {
        return this.addChannelHandlerFirst(HandlerNames.WireLogging.getName(), LoggingHandlerFactory.getFactory(name, wireLoggingLevel));
    }

    public static <WW, RR> ClientState<WW, RR> create(ConnectionProviderFactory<WW, RR> factory, Observable<Host> hostStream) {
        return ClientState.create(ClientState.newChannelPipeline(new TailHandlerFactory(false)), factory, hostStream);
    }

    public static <WW, RR> ClientState<WW, RR> create(ConnectionProviderFactory<WW, RR> factory, Observable<Host> hostStream, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        return new ClientState<WW, RR>(hostStream, factory, ClientState.newChannelPipeline(new TailHandlerFactory(false)), eventLoopGroup, channelClass);
    }

    public static <WW, RR> ClientState<WW, RR> create(DetachedChannelPipeline detachedPipeline, ConnectionProviderFactory<WW, RR> factory, Observable<Host> hostStream) {
        return ClientState.create(detachedPipeline, factory, hostStream, ClientState.defaultEventloopGroup(), ClientState.defaultSocketChannelClass());
    }

    public static <WW, RR> ClientState<WW, RR> create(DetachedChannelPipeline detachedPipeline, ConnectionProviderFactory<WW, RR> factory, Observable<Host> hostStream, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        return new ClientState<WW, RR>(hostStream, factory, detachedPipeline, eventLoopGroup, channelClass);
    }

    private static DetachedChannelPipeline newChannelPipeline(TailHandlerFactory thf) {
        return new DetachedChannelPipeline(thf).addLast(HandlerNames.WriteTransformer.getName(), new Func0<ChannelHandler>(){

            @Override
            public ChannelHandler call() {
                return new WriteTransformer();
            }
        });
    }

    public Bootstrap newBootstrap(final EventPublisher eventPublisher, final ClientEventListener eventListener) {
        Bootstrap nettyBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.channelClass)).option(ChannelOption.AUTO_READ, false);
        for (Map.Entry<ChannelOption<?>, Object> optionEntry : this.options.entrySet()) {
            ChannelOption<?> key = optionEntry.getKey();
            nettyBootstrap.option(key, optionEntry.getValue());
        }
        nettyBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(HandlerNames.ClientChannelActiveBufferingHandler.getName(), (ChannelHandler)new ChannelActivityBufferingHandler(eventPublisher, eventListener));
            }
        });
        return nettyBootstrap;
    }

    public DetachedChannelPipeline unsafeDetachedPipeline() {
        return this.detachedPipeline;
    }

    public Map<ChannelOption<?>, Object> unsafeChannelOptions() {
        return this.options;
    }

    public ClientState<W, R> channelProviderFactory(ChannelProviderFactory factory) {
        return new ClientState<W, R>(this, factory);
    }

    public ClientState<W, R> secure(Func1<ByteBufAllocator, SSLEngine> sslEngineFactory) {
        return this.secure(new DefaultSslCodec(sslEngineFactory));
    }

    public ClientState<W, R> secure(SSLEngine sslEngine) {
        return this.secure(new DefaultSslCodec(sslEngine));
    }

    public ClientState<W, R> secure(SslCodec sslCodec) {
        return new ClientState<W, R>(this, sslCodec);
    }

    public ClientState<W, R> unsafeSecure() {
        return this.secure(new DefaultSslCodec(new Func1<ByteBufAllocator, SSLEngine>(){

            @Override
            public SSLEngine call(ByteBufAllocator allocator) {
                try {
                    return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build().newEngine(allocator);
                }
                catch (Exception e) {
                    throw Exceptions.propagate(e);
                }
            }
        }));
    }

    private <WW, RR> ClientState<WW, RR> copy() {
        TailHandlerFactory newTail = new TailHandlerFactory(this.isSecure);
        return new ClientState<W, R>(this, this.detachedPipeline.copy(newTail), this.isSecure);
    }

    public ConnectionProviderFactory<W, R> getFactory() {
        return this.factory;
    }

    public Observable<Host> getHostStream() {
        return this.hostStream;
    }

    public ChannelProviderFactory getChannelProviderFactory() {
        return this.channelProviderFactory;
    }

    private <WW, RR> ClientState<WW, RR> cast() {
        return this;
    }

    public static EventLoopGroup defaultEventloopGroup() {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop(true);
    }

    public static Class<? extends Channel> defaultSocketChannelClass() {
        return RxNetty.isUsingNativeTransport() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    private static class ChannelActivityBufferingHandler
    extends ChannelDuplexHandler {
        private State state = State.Initialized;
        private boolean unregistered;
        private long connectStartTimeNanos;
        private final EventPublisher eventPublisher;
        private final ClientEventListener eventListener;

        private ChannelActivityBufferingHandler(EventPublisher eventPublisher, ClientEventListener eventListener) {
            this.eventPublisher = eventPublisher;
            this.eventListener = eventListener;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.connectStartTimeNanos = Clock.newStartTimeNanos();
            if (this.eventPublisher.publishingEnabled()) {
                this.eventListener.onConnectStart();
                promise.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (ChannelActivityBufferingHandler.this.eventPublisher.publishingEnabled()) {
                            long endTimeNanos = Clock.onEndNanos(ChannelActivityBufferingHandler.this.connectStartTimeNanos);
                            if (!future.isSuccess()) {
                                ChannelActivityBufferingHandler.this.eventListener.onConnectFailed(endTimeNanos, TimeUnit.NANOSECONDS, future.cause());
                            } else {
                                ChannelActivityBufferingHandler.this.eventListener.onConnectSuccess(endTimeNanos, TimeUnit.NANOSECONDS);
                            }
                        }
                    }
                });
            }
            super.connect(ctx, remoteAddress, localAddress, promise);
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            if (State.ChannelSubscribed == this.state) {
                super.channelRegistered(ctx);
            } else {
                this.state = State.Registered;
            }
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            if (State.ChannelSubscribed == this.state) {
                super.channelUnregistered(ctx);
            } else {
                this.unregistered = true;
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (State.ChannelSubscribed == this.state) {
                super.channelActive(ctx);
            } else {
                this.state = State.Active;
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (State.ChannelSubscribed == this.state) {
                super.channelInactive(ctx);
            } else {
                this.state = State.Inactive;
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ChannelSubscriberEvent) {
                State existingState = this.state;
                this.state = State.ChannelSubscribed;
                super.userEventTriggered(ctx, evt);
                ChannelPipeline pipeline = ctx.channel().pipeline();
                switch (existingState) {
                    case Initialized: {
                        break;
                    }
                    case Registered: {
                        pipeline.fireChannelRegistered();
                        break;
                    }
                    case Active: {
                        pipeline.fireChannelRegistered();
                        pipeline.fireChannelActive();
                        break;
                    }
                    case Inactive: {
                        pipeline.fireChannelRegistered();
                        pipeline.fireChannelActive();
                        pipeline.fireChannelInactive();
                        break;
                    }
                }
                if (this.unregistered) {
                    pipeline.fireChannelUnregistered();
                }
            } else if (evt instanceof ConnectionCreationFailedEvent) {
                ConnectionCreationFailedEvent failedEvent = (ConnectionCreationFailedEvent)evt;
                this.onConnectFailedEvent(failedEvent);
                super.userEventTriggered(ctx, evt);
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void onConnectFailedEvent(ConnectionCreationFailedEvent event) {
            if (this.eventPublisher.publishingEnabled()) {
                this.eventListener.onConnectFailed(this.connectStartTimeNanos, TimeUnit.NANOSECONDS, event.getThrowable());
            }
        }

        private static enum State {
            Initialized,
            Registered,
            Active,
            Inactive,
            ChannelSubscribed;

        }
    }

    protected static class TailHandlerFactory
    implements Action1<ChannelPipeline> {
        private final boolean isSecure;

        public TailHandlerFactory(boolean isSecure) {
            this.isSecure = isSecure;
        }

        @Override
        public void call(ChannelPipeline pipeline) {
            ClientConnectionToChannelBridge.addToPipeline(pipeline, this.isSecure);
        }
    }
}

