/*
 * Decompiled with CFR 0.152.
 */
package feign.apttestgenerator;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.io.TemplateSource;
import com.github.jknack.handlebars.io.URLTemplateSource;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import feign.apttestgenerator.ArgumentDefinition;
import feign.apttestgenerator.ClientDefinition;
import feign.apttestgenerator.MethodDefinition;
import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"feign.RequestLine"})
@AutoService(value={Processor.class})
public class GenerateTestStubAPT
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Template template;
        System.out.println(annotations);
        System.out.println(roundEnv);
        Map<TypeElement, List> clientsToGenerate = annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).map(ExecutableElement.class::cast).collect(Collectors.toMap(annotatedMethod -> (TypeElement)TypeElement.class.cast(annotatedMethod.getEnclosingElement()), ImmutableList::of, (list1, list2) -> ImmutableList.builder().addAll((Iterable)list1).addAll((Iterable)list2).build()));
        System.out.println("Count: " + clientsToGenerate.size());
        System.out.println("clientsToGenerate: " + clientsToGenerate);
        Handlebars handlebars = new Handlebars();
        URLTemplateSource source = new URLTemplateSource("stub.mustache", this.getClass().getResource("/stub.mustache"));
        try {
            template = handlebars.with(EscapingStrategy.JS).compile((TemplateSource)source);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        clientsToGenerate.forEach((type, executables) -> {
            try {
                String jPackage = this.readPackage((Element)type);
                String className = type.getSimpleName().toString();
                JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(jPackage + "." + className + "Stub", new Element[0]);
                ClientDefinition client = new ClientDefinition(jPackage, className, type.toString());
                List methods = executables.stream().map(method -> {
                    String methodName = method.getSimpleName().toString();
                    List<ArgumentDefinition> args = method.getParameters().stream().map(var -> new ArgumentDefinition(var.getSimpleName().toString(), var.asType().toString())).collect(Collectors.toList());
                    return new MethodDefinition(methodName, method.getReturnType().toString(), method.getReturnType().getKind() == TypeKind.VOID, args);
                }).collect(Collectors.toList());
                Context context = Context.newBuilder((Object)template).combine("client", (Object)client).combine("methods", methods).resolver(new ValueResolver[]{JavaBeanValueResolver.INSTANCE, MapValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
                String stubSource = template.apply(context);
                System.out.println(stubSource);
                builderFile.openWriter().append(stubSource).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate factory for " + type);
            }
        });
        return true;
    }

    private Type toJavaType(TypeMirror type) {
        this.outType(type.getClass());
        if (type instanceof WildcardType) {
            // empty if block
        }
        return Object.class;
    }

    private void outType(Class<?> class1) {
        if (Object.class.equals(class1) || class1 == null) {
            return;
        }
        System.out.println(class1);
        this.outType(class1.getSuperclass());
        Arrays.stream(class1.getInterfaces()).forEach(this::outType);
    }

    private String readPackage(Element type) {
        if (type.getKind() == ElementKind.PACKAGE) {
            return type.toString();
        }
        if (type.getKind() == ElementKind.CLASS || type.getKind() == ElementKind.INTERFACE) {
            return this.readPackage(type.getEnclosingElement());
        }
        return null;
    }
}

