/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.jul;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.event.Level;

public class LevelMapper {
    private static final Map<Level, java.util.logging.Level> LEVEL_MAPPING;
    private static final Map<java.util.logging.Level, Level> LEVEL_MAPPING_REVERSE;

    public static java.util.logging.Level mapLevel(Level level) {
        java.util.logging.Level result = LEVEL_MAPPING.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map log level " + level + " to a JUL log level");
        }
        return result;
    }

    public static Level mapLevel(java.util.logging.Level level) {
        Level result = LEVEL_MAPPING_REVERSE.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map JUL log level " + level + " to an slf4j log level");
        }
        return result;
    }

    static {
        HashMap<Level, java.util.logging.Level> levelMapping = new HashMap<Level, java.util.logging.Level>();
        levelMapping.put(Level.TRACE, java.util.logging.Level.FINEST);
        levelMapping.put(Level.DEBUG, java.util.logging.Level.FINE);
        levelMapping.put(Level.INFO, java.util.logging.Level.INFO);
        levelMapping.put(Level.WARN, java.util.logging.Level.WARNING);
        levelMapping.put(Level.ERROR, java.util.logging.Level.SEVERE);
        LEVEL_MAPPING = Collections.unmodifiableMap(levelMapping);
        HashMap<java.util.logging.Level, Level> levelMappingReverse = new HashMap<java.util.logging.Level, Level>();
        levelMapping.forEach((key, value) -> levelMappingReverse.put((java.util.logging.Level)value, (Level)key));
        levelMappingReverse.put(java.util.logging.Level.CONFIG, Level.INFO);
        levelMappingReverse.put(java.util.logging.Level.FINER, Level.DEBUG);
        LEVEL_MAPPING_REVERSE = Collections.unmodifiableMap(levelMappingReverse);
    }
}

