/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);

    private TimeUtils() {
    }

    public static String toUTC(long timestamp) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.ofEpochSecond(timestamp, 0, ZoneOffset.UTC));
    }

    public static String toUTCTimeOnly(long timestamp) {
        return DateTimeFormatter.ofPattern("HH:mm:ss").format(LocalDateTime.ofEpochSecond(timestamp, 0, ZoneOffset.UTC));
    }

    public static long now() {
        return Instant.now().getEpochSecond();
    }

    public static void sleep(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (Throwable e) {
            log.info(e.getMessage());
        }
    }

    public static void sleepMs(long milliseconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (Throwable e) {
            log.info(e.getMessage());
        }
    }

    public static void sleep(long seconds, String text) {
        try {
            log.info(String.format("pause %s seconds, %s", seconds, text));
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (Throwable e) {
            log.info(e.getMessage());
        }
    }

    public static void sleepMs(long milliseconds, String text) {
        try {
            log.info(String.format("pause %s milliseconds, %s", milliseconds, text));
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (Throwable e) {
            log.info(e.getMessage());
        }
    }
}

