/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib.types;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.Transaction;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.LastTransactionId;
import org.ton.java.tonlib.types.RawMessage;

public class RawTransaction
implements Serializable {
    @SerializedName(value="@type")
    final String type = "raw.transaction";
    long utime;
    String data;
    LastTransactionId transaction_id;
    String fee;
    String storage_fee;
    String other_fee;
    RawMessage in_msg;
    List<RawMessage> out_msgs;

    public List<ExtraCurrency> getExtraCurrencies() {
        return this.getIn_msg().getExtra_currencies();
    }

    public long getFirstExtraCurrencyId() {
        Iterator<ExtraCurrency> iterator = this.getIn_msg().getExtra_currencies().iterator();
        if (iterator.hasNext()) {
            ExtraCurrency ec = iterator.next();
            return ec.getId();
        }
        return Long.MIN_VALUE;
    }

    public BigInteger getFirstExtraCurrencyValue() {
        Iterator<ExtraCurrency> iterator = this.getIn_msg().getExtra_currencies().iterator();
        if (iterator.hasNext()) {
            ExtraCurrency ec = iterator.next();
            return ec.getAmount();
        }
        return null;
    }

    public Transaction getTransactionAsTlb() {
        return Transaction.deserialize((CellSlice)CellSlice.beginParse((Cell)CellBuilder.beginCell().fromBocBase64(this.getData()).endCell()));
    }

    RawTransaction(long utime, String data, LastTransactionId transaction_id, String fee, String storage_fee, String other_fee, RawMessage in_msg, List<RawMessage> out_msgs) {
        this.utime = utime;
        this.data = data;
        this.transaction_id = transaction_id;
        this.fee = fee;
        this.storage_fee = storage_fee;
        this.other_fee = other_fee;
        this.in_msg = in_msg;
        this.out_msgs = out_msgs;
    }

    public static RawTransactionBuilder builder() {
        return new RawTransactionBuilder();
    }

    public String getType() {
        return this.type;
    }

    public long getUtime() {
        return this.utime;
    }

    public String getData() {
        return this.data;
    }

    public LastTransactionId getTransaction_id() {
        return this.transaction_id;
    }

    public String getFee() {
        return this.fee;
    }

    public String getStorage_fee() {
        return this.storage_fee;
    }

    public String getOther_fee() {
        return this.other_fee;
    }

    public RawMessage getIn_msg() {
        return this.in_msg;
    }

    public List<RawMessage> getOut_msgs() {
        return this.out_msgs;
    }

    public void setUtime(long utime) {
        this.utime = utime;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setTransaction_id(LastTransactionId transaction_id) {
        this.transaction_id = transaction_id;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public void setStorage_fee(String storage_fee) {
        this.storage_fee = storage_fee;
    }

    public void setOther_fee(String other_fee) {
        this.other_fee = other_fee;
    }

    public void setIn_msg(RawMessage in_msg) {
        this.in_msg = in_msg;
    }

    public void setOut_msgs(List<RawMessage> out_msgs) {
        this.out_msgs = out_msgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawTransaction)) {
            return false;
        }
        RawTransaction other = (RawTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUtime() != other.getUtime()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        LastTransactionId this$transaction_id = this.getTransaction_id();
        LastTransactionId other$transaction_id = other.getTransaction_id();
        if (this$transaction_id == null ? other$transaction_id != null : !((Object)this$transaction_id).equals(other$transaction_id)) {
            return false;
        }
        String this$fee = this.getFee();
        String other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) {
            return false;
        }
        String this$storage_fee = this.getStorage_fee();
        String other$storage_fee = other.getStorage_fee();
        if (this$storage_fee == null ? other$storage_fee != null : !this$storage_fee.equals(other$storage_fee)) {
            return false;
        }
        String this$other_fee = this.getOther_fee();
        String other$other_fee = other.getOther_fee();
        if (this$other_fee == null ? other$other_fee != null : !this$other_fee.equals(other$other_fee)) {
            return false;
        }
        RawMessage this$in_msg = this.getIn_msg();
        RawMessage other$in_msg = other.getIn_msg();
        if (this$in_msg == null ? other$in_msg != null : !((Object)this$in_msg).equals(other$in_msg)) {
            return false;
        }
        List<RawMessage> this$out_msgs = this.getOut_msgs();
        List<RawMessage> other$out_msgs = other.getOut_msgs();
        return !(this$out_msgs == null ? other$out_msgs != null : !((Object)this$out_msgs).equals(other$out_msgs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $utime = this.getUtime();
        result = result * 59 + (int)($utime >>> 32 ^ $utime);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        LastTransactionId $transaction_id = this.getTransaction_id();
        result = result * 59 + ($transaction_id == null ? 43 : ((Object)$transaction_id).hashCode());
        String $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
        String $storage_fee = this.getStorage_fee();
        result = result * 59 + ($storage_fee == null ? 43 : $storage_fee.hashCode());
        String $other_fee = this.getOther_fee();
        result = result * 59 + ($other_fee == null ? 43 : $other_fee.hashCode());
        RawMessage $in_msg = this.getIn_msg();
        result = result * 59 + ($in_msg == null ? 43 : ((Object)$in_msg).hashCode());
        List<RawMessage> $out_msgs = this.getOut_msgs();
        result = result * 59 + ($out_msgs == null ? 43 : ((Object)$out_msgs).hashCode());
        return result;
    }

    public String toString() {
        return "RawTransaction(type=" + this.getType() + ", utime=" + this.getUtime() + ", data=" + this.getData() + ", transaction_id=" + String.valueOf(this.getTransaction_id()) + ", fee=" + this.getFee() + ", storage_fee=" + this.getStorage_fee() + ", other_fee=" + this.getOther_fee() + ", in_msg=" + String.valueOf(this.getIn_msg()) + ", out_msgs=" + String.valueOf(this.getOut_msgs()) + ")";
    }

    public static class RawTransactionBuilder {
        private long utime;
        private String data;
        private LastTransactionId transaction_id;
        private String fee;
        private String storage_fee;
        private String other_fee;
        private RawMessage in_msg;
        private List<RawMessage> out_msgs;

        RawTransactionBuilder() {
        }

        public RawTransactionBuilder utime(long utime) {
            this.utime = utime;
            return this;
        }

        public RawTransactionBuilder data(String data) {
            this.data = data;
            return this;
        }

        public RawTransactionBuilder transaction_id(LastTransactionId transaction_id) {
            this.transaction_id = transaction_id;
            return this;
        }

        public RawTransactionBuilder fee(String fee) {
            this.fee = fee;
            return this;
        }

        public RawTransactionBuilder storage_fee(String storage_fee) {
            this.storage_fee = storage_fee;
            return this;
        }

        public RawTransactionBuilder other_fee(String other_fee) {
            this.other_fee = other_fee;
            return this;
        }

        public RawTransactionBuilder in_msg(RawMessage in_msg) {
            this.in_msg = in_msg;
            return this;
        }

        public RawTransactionBuilder out_msgs(List<RawMessage> out_msgs) {
            this.out_msgs = out_msgs;
            return this;
        }

        public RawTransaction build() {
            return new RawTransaction(this.utime, this.data, this.transaction_id, this.fee, this.storage_fee, this.other_fee, this.in_msg, this.out_msgs);
        }

        public String toString() {
            return "RawTransaction.RawTransactionBuilder(utime=" + this.utime + ", data=" + this.data + ", transaction_id=" + String.valueOf(this.transaction_id) + ", fee=" + this.fee + ", storage_fee=" + this.storage_fee + ", other_fee=" + this.other_fee + ", in_msg=" + String.valueOf(this.in_msg) + ", out_msgs=" + String.valueOf(this.out_msgs) + ")";
        }
    }
}

