/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v5;

import org.apache.commons.lang3.ObjectUtils;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.tlb.ActionList;
import org.ton.java.tlb.OutList;

public class WalletActions {
    OutList wallet;
    ActionList extended;

    public static WalletActionsBuilder builder() {
        return new CustomWalletActionsBuilder();
    }

    public Cell toCell() {
        CellBuilder cb = CellBuilder.beginCell();
        if (ObjectUtils.isNotEmpty((Object)this.wallet)) {
            cb.storeRef(this.wallet.toCell());
        } else {
            cb.storeBit(Boolean.valueOf(false));
        }
        if (ObjectUtils.isNotEmpty((Object)this.extended)) {
            cb.storeBit(Boolean.valueOf(true));
            cb.storeRef(this.extended.toCell());
        } else {
            cb.storeBit(Boolean.valueOf(false));
        }
        return cb.endCell();
    }

    WalletActions(OutList wallet, ActionList extended) {
        this.wallet = wallet;
        this.extended = extended;
    }

    public OutList getWallet() {
        return this.wallet;
    }

    public ActionList getExtended() {
        return this.extended;
    }

    public void setWallet(OutList wallet) {
        this.wallet = wallet;
    }

    public void setExtended(ActionList extended) {
        this.extended = extended;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletActions)) {
            return false;
        }
        WalletActions other = (WalletActions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutList this$wallet = this.getWallet();
        OutList other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) {
            return false;
        }
        ActionList this$extended = this.getExtended();
        ActionList other$extended = other.getExtended();
        return !(this$extended == null ? other$extended != null : !this$extended.equals(other$extended));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletActions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutList $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        ActionList $extended = this.getExtended();
        result = result * 59 + ($extended == null ? 43 : $extended.hashCode());
        return result;
    }

    public String toString() {
        return "WalletActions(wallet=" + String.valueOf(this.getWallet()) + ", extended=" + String.valueOf(this.getExtended()) + ")";
    }

    private static class CustomWalletActionsBuilder
    extends WalletActionsBuilder {
        private CustomWalletActionsBuilder() {
        }

        @Override
        public WalletActions build() {
            return super.build();
        }
    }

    public static class WalletActionsBuilder {
        private OutList wallet;
        private ActionList extended;

        WalletActionsBuilder() {
        }

        public WalletActionsBuilder wallet(OutList wallet) {
            this.wallet = wallet;
            return this;
        }

        public WalletActionsBuilder extended(ActionList extended) {
            this.extended = extended;
            return this;
        }

        public WalletActions build() {
            return new WalletActions(this.wallet, this.extended);
        }

        public String toString() {
            return "WalletActions.WalletActionsBuilder(wallet=" + String.valueOf(this.wallet) + ", extended=" + String.valueOf(this.extended) + ")";
        }
    }
}

