/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet;

import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.smartcontract.token.ft.JettonMinter;
import org.ton.java.smartcontract.token.ft.JettonWallet;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.utils.Utils;

public class ContractUtils {
    private static final Logger log = LoggerFactory.getLogger(ContractUtils.class);

    public static long getSeqno(Tonlib tonlib, Address address) {
        return tonlib.getSeqno(address);
    }

    public static boolean isDeployed(Tonlib tonlib, Address address) {
        return StringUtils.isNotEmpty((CharSequence)tonlib.getRawAccountState(address).getCode());
    }

    @Deprecated
    public static void waitForDeployment(Tonlib tonlib, Address address, int timeoutSeconds) {
        log.info("Waiting for deployment (up to {}s) - {}", (Object)timeoutSeconds, (Object)address.toRaw());
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Can't deploy contract within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (!ContractUtils.isDeployed(tonlib, address));
    }

    @Deprecated
    public static void waitForBalanceChange(Tonlib tonlib, Address address, int timeoutSeconds) {
        log.info("Waiting for balance change (up to {}s) - {}", (Object)timeoutSeconds, (Object)address.toRaw());
        BigInteger initialBalance = tonlib.getAccountBalance(address);
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance was not changed within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (initialBalance.equals(tonlib.getAccountBalance(address)));
    }

    public static void waitForJettonBalanceChange(Tonlib tonlib, Address jettonMinter, Address address, int timeoutSeconds) {
        log.info("Waiting for jetton balance change (up to {}s) - {}", (Object)timeoutSeconds, (Object)address.toRaw());
        BigInteger initialBalance = ContractUtils.getJettonBalance(tonlib, jettonMinter, address);
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance of " + address.toRaw() + " was not changed within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (initialBalance.equals(ContractUtils.getJettonBalance(tonlib, jettonMinter, address)));
    }

    public static BigInteger getJettonBalance(Tonlib tonlib, Address jettonMinter, Address destinationAddress) {
        try {
            JettonMinter jettonMinterWallet = JettonMinter.builder().tonlib(tonlib).customAddress(jettonMinter).build();
            JettonWallet jettonWallet = jettonMinterWallet.getJettonWallet(destinationAddress);
            return jettonWallet.getBalance();
        }
        catch (Error e) {
            return new BigInteger("-1");
        }
    }
}

