/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.utils;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.StateInit;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.utils.Utils;

public class MsgUtils {
    public static Message createExternalMessage(Address destination, StateInit stateInit, Cell body) {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).build()).init((StateInit)(Objects.nonNull(stateInit) ? stateInit : null)).body((Cell)(Objects.nonNull(body) ? body : null)).build();
    }

    public static Message createExternalMessageWithSignedBody(TweetNaclFast.Signature.KeyPair keyPair, Address destination, StateInit stateInit, Cell body) {
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).build()).init((StateInit)(Objects.nonNull(stateInit) ? stateInit : null)).build();
        if (Objects.isNull(body)) {
            body = CellBuilder.beginCell().endCell();
        }
        externalMessage.setBody(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])keyPair.getPublicKey(), (byte[])keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell());
        return externalMessage;
    }

    public static Message createExternalMessageWithSignedBody(byte[] signedBodyHash, Address destination, StateInit stateInit, Cell body) {
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).build()).init((StateInit)(Objects.nonNull(stateInit) ? stateInit : null)).build();
        if (Objects.isNull(body)) {
            body = CellBuilder.beginCell().endCell();
        }
        externalMessage.setBody(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(body).endCell());
        return externalMessage;
    }

    public static MessageRelaxed createInternalMessageRelaxed(Address destination, BigInteger amount, List<ExtraCurrency> extraCurrencies, StateInit stateInit, Cell body, Boolean bounce) {
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(bounce).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).extraCurrencies(MsgUtils.convertExtraCurrenciesToHashMap(extraCurrencies)).build()).build()).init((StateInit)(Objects.nonNull(stateInit) ? stateInit : null)).body((Cell)(Objects.nonNull(body) ? body : null)).build();
    }

    public static Message createInternalMessage(Address source, Address destination, BigInteger amount, List<ExtraCurrency> extraCurrencies, StateInit stateInit, Cell body, Boolean bounce) {
        return Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().bounce(bounce).srcAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(source.wc).address(source.toBigInteger()).build()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).extraCurrencies(MsgUtils.convertExtraCurrenciesToHashMap(extraCurrencies)).build()).build()).init((StateInit)(Objects.nonNull(stateInit) ? stateInit : null)).body((Cell)(Objects.nonNull(body) ? body : null)).build();
    }

    public static Cell createTextMessageBody(String text) {
        return CellBuilder.beginCell().storeUint(0, 32).storeSnakeString(text).endCell();
    }

    public static TonHashMapE convertExtraCurrenciesToHashMap(List<ExtraCurrency> extraCurrencies) {
        if (Objects.isNull(extraCurrencies)) {
            return null;
        }
        TonHashMapE x = new TonHashMapE(32);
        for (ExtraCurrency ec : extraCurrencies) {
            x.elements.put(ec.getId(), ec.getAmount());
        }
        return x;
    }
}

