/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.List;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.smartcontract.types.WalletConfig;
import org.ton.java.tlb.StateInit;
import org.ton.java.tonlib.types.ExtraCurrency;

public class WalletV3Config
implements WalletConfig {
    long walletId;
    long seqno;
    int mode;
    long validUntil;
    boolean bounce;
    Address source;
    Address destination;
    BigInteger amount;
    List<ExtraCurrency> extraCurrencies;
    Cell body;
    StateInit stateInit;
    String comment;

    WalletV3Config(long walletId, long seqno, int mode, long validUntil, boolean bounce, Address source, Address destination, BigInteger amount, List<ExtraCurrency> extraCurrencies, Cell body, StateInit stateInit, String comment) {
        this.walletId = walletId;
        this.seqno = seqno;
        this.mode = mode;
        this.validUntil = validUntil;
        this.bounce = bounce;
        this.source = source;
        this.destination = destination;
        this.amount = amount;
        this.extraCurrencies = extraCurrencies;
        this.body = body;
        this.stateInit = stateInit;
        this.comment = comment;
    }

    public static WalletV3ConfigBuilder builder() {
        return new WalletV3ConfigBuilder();
    }

    public long getWalletId() {
        return this.walletId;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public int getMode() {
        return this.mode;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public boolean isBounce() {
        return this.bounce;
    }

    public Address getSource() {
        return this.source;
    }

    public Address getDestination() {
        return this.destination;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public List<ExtraCurrency> getExtraCurrencies() {
        return this.extraCurrencies;
    }

    public Cell getBody() {
        return this.body;
    }

    public StateInit getStateInit() {
        return this.stateInit;
    }

    public String getComment() {
        return this.comment;
    }

    public void setWalletId(long walletId) {
        this.walletId = walletId;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public void setBounce(boolean bounce) {
        this.bounce = bounce;
    }

    public void setSource(Address source) {
        this.source = source;
    }

    public void setDestination(Address destination) {
        this.destination = destination;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public void setExtraCurrencies(List<ExtraCurrency> extraCurrencies) {
        this.extraCurrencies = extraCurrencies;
    }

    public void setBody(Cell body) {
        this.body = body;
    }

    public void setStateInit(StateInit stateInit) {
        this.stateInit = stateInit;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletV3Config)) {
            return false;
        }
        WalletV3Config other = (WalletV3Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWalletId() != other.getWalletId()) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getValidUntil() != other.getValidUntil()) {
            return false;
        }
        if (this.isBounce() != other.isBounce()) {
            return false;
        }
        Address this$source = this.getSource();
        Address other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Address this$destination = this.getDestination();
        Address other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        BigInteger this$amount = this.getAmount();
        BigInteger other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        List<ExtraCurrency> this$extraCurrencies = this.getExtraCurrencies();
        List<ExtraCurrency> other$extraCurrencies = other.getExtraCurrencies();
        if (this$extraCurrencies == null ? other$extraCurrencies != null : !((Object)this$extraCurrencies).equals(other$extraCurrencies)) {
            return false;
        }
        Cell this$body = this.getBody();
        Cell other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        StateInit this$stateInit = this.getStateInit();
        StateInit other$stateInit = other.getStateInit();
        if (this$stateInit == null ? other$stateInit != null : !this$stateInit.equals(other$stateInit)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletV3Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $walletId = this.getWalletId();
        result = result * 59 + (int)($walletId >>> 32 ^ $walletId);
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        result = result * 59 + this.getMode();
        long $validUntil = this.getValidUntil();
        result = result * 59 + (int)($validUntil >>> 32 ^ $validUntil);
        result = result * 59 + (this.isBounce() ? 79 : 97);
        Address $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Address $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        BigInteger $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        List<ExtraCurrency> $extraCurrencies = this.getExtraCurrencies();
        result = result * 59 + ($extraCurrencies == null ? 43 : ((Object)$extraCurrencies).hashCode());
        Cell $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        StateInit $stateInit = this.getStateInit();
        result = result * 59 + ($stateInit == null ? 43 : $stateInit.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "WalletV3Config(walletId=" + this.getWalletId() + ", seqno=" + this.getSeqno() + ", mode=" + this.getMode() + ", validUntil=" + this.getValidUntil() + ", bounce=" + this.isBounce() + ", source=" + String.valueOf(this.getSource()) + ", destination=" + String.valueOf(this.getDestination()) + ", amount=" + String.valueOf(this.getAmount()) + ", extraCurrencies=" + String.valueOf(this.getExtraCurrencies()) + ", body=" + String.valueOf(this.getBody()) + ", stateInit=" + String.valueOf(this.getStateInit()) + ", comment=" + this.getComment() + ")";
    }

    public static class WalletV3ConfigBuilder {
        private long walletId;
        private long seqno;
        private int mode;
        private long validUntil;
        private boolean bounce;
        private Address source;
        private Address destination;
        private BigInteger amount;
        private List<ExtraCurrency> extraCurrencies;
        private Cell body;
        private StateInit stateInit;
        private String comment;

        WalletV3ConfigBuilder() {
        }

        public WalletV3ConfigBuilder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public WalletV3ConfigBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public WalletV3ConfigBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public WalletV3ConfigBuilder validUntil(long validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public WalletV3ConfigBuilder bounce(boolean bounce) {
            this.bounce = bounce;
            return this;
        }

        public WalletV3ConfigBuilder source(Address source) {
            this.source = source;
            return this;
        }

        public WalletV3ConfigBuilder destination(Address destination) {
            this.destination = destination;
            return this;
        }

        public WalletV3ConfigBuilder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public WalletV3ConfigBuilder extraCurrencies(List<ExtraCurrency> extraCurrencies) {
            this.extraCurrencies = extraCurrencies;
            return this;
        }

        public WalletV3ConfigBuilder body(Cell body) {
            this.body = body;
            return this;
        }

        public WalletV3ConfigBuilder stateInit(StateInit stateInit) {
            this.stateInit = stateInit;
            return this;
        }

        public WalletV3ConfigBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public WalletV3Config build() {
            return new WalletV3Config(this.walletId, this.seqno, this.mode, this.validUntil, this.bounce, this.source, this.destination, this.amount, this.extraCurrencies, this.body, this.stateInit, this.comment);
        }

        public String toString() {
            return "WalletV3Config.WalletV3ConfigBuilder(walletId=" + this.walletId + ", seqno=" + this.seqno + ", mode=" + this.mode + ", validUntil=" + this.validUntil + ", bounce=" + this.bounce + ", source=" + String.valueOf(this.source) + ", destination=" + String.valueOf(this.destination) + ", amount=" + String.valueOf(this.amount) + ", extraCurrencies=" + String.valueOf(this.extraCurrencies) + ", body=" + String.valueOf(this.body) + ", stateInit=" + String.valueOf(this.stateInit) + ", comment=" + this.comment + ")";
        }
    }
}

