/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.List;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.utils.Utils;

public class MultiSigV2OrderData {
    public Address multiSigAddress;
    public BigInteger orderSeqno;
    public long threshold;
    public boolean sentForExecution;
    public List<Address> signers;
    public long approvals_mask;
    public long approvals_num;
    public long expirationDate;
    public Cell order;

    public String getExpirationDateString() {
        return Utils.toUTC((long)this.expirationDate);
    }

    MultiSigV2OrderData(Address multiSigAddress, BigInteger orderSeqno, long threshold, boolean sentForExecution, List<Address> signers, long approvals_mask, long approvals_num, long expirationDate, Cell order) {
        this.multiSigAddress = multiSigAddress;
        this.orderSeqno = orderSeqno;
        this.threshold = threshold;
        this.sentForExecution = sentForExecution;
        this.signers = signers;
        this.approvals_mask = approvals_mask;
        this.approvals_num = approvals_num;
        this.expirationDate = expirationDate;
        this.order = order;
    }

    public static MultiSigV2OrderDataBuilder builder() {
        return new MultiSigV2OrderDataBuilder();
    }

    public Address getMultiSigAddress() {
        return this.multiSigAddress;
    }

    public BigInteger getOrderSeqno() {
        return this.orderSeqno;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public boolean isSentForExecution() {
        return this.sentForExecution;
    }

    public List<Address> getSigners() {
        return this.signers;
    }

    public long getApprovals_mask() {
        return this.approvals_mask;
    }

    public long getApprovals_num() {
        return this.approvals_num;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public Cell getOrder() {
        return this.order;
    }

    public void setMultiSigAddress(Address multiSigAddress) {
        this.multiSigAddress = multiSigAddress;
    }

    public void setOrderSeqno(BigInteger orderSeqno) {
        this.orderSeqno = orderSeqno;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setSentForExecution(boolean sentForExecution) {
        this.sentForExecution = sentForExecution;
    }

    public void setSigners(List<Address> signers) {
        this.signers = signers;
    }

    public void setApprovals_mask(long approvals_mask) {
        this.approvals_mask = approvals_mask;
    }

    public void setApprovals_num(long approvals_num) {
        this.approvals_num = approvals_num;
    }

    public void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setOrder(Cell order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiSigV2OrderData)) {
            return false;
        }
        MultiSigV2OrderData other = (MultiSigV2OrderData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.isSentForExecution() != other.isSentForExecution()) {
            return false;
        }
        if (this.getApprovals_mask() != other.getApprovals_mask()) {
            return false;
        }
        if (this.getApprovals_num() != other.getApprovals_num()) {
            return false;
        }
        if (this.getExpirationDate() != other.getExpirationDate()) {
            return false;
        }
        Address this$multiSigAddress = this.getMultiSigAddress();
        Address other$multiSigAddress = other.getMultiSigAddress();
        if (this$multiSigAddress == null ? other$multiSigAddress != null : !this$multiSigAddress.equals(other$multiSigAddress)) {
            return false;
        }
        BigInteger this$orderSeqno = this.getOrderSeqno();
        BigInteger other$orderSeqno = other.getOrderSeqno();
        if (this$orderSeqno == null ? other$orderSeqno != null : !((Object)this$orderSeqno).equals(other$orderSeqno)) {
            return false;
        }
        List<Address> this$signers = this.getSigners();
        List<Address> other$signers = other.getSigners();
        if (this$signers == null ? other$signers != null : !((Object)this$signers).equals(other$signers)) {
            return false;
        }
        Cell this$order = this.getOrder();
        Cell other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiSigV2OrderData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = this.getThreshold();
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        result = result * 59 + (this.isSentForExecution() ? 79 : 97);
        long $approvals_mask = this.getApprovals_mask();
        result = result * 59 + (int)($approvals_mask >>> 32 ^ $approvals_mask);
        long $approvals_num = this.getApprovals_num();
        result = result * 59 + (int)($approvals_num >>> 32 ^ $approvals_num);
        long $expirationDate = this.getExpirationDate();
        result = result * 59 + (int)($expirationDate >>> 32 ^ $expirationDate);
        Address $multiSigAddress = this.getMultiSigAddress();
        result = result * 59 + ($multiSigAddress == null ? 43 : $multiSigAddress.hashCode());
        BigInteger $orderSeqno = this.getOrderSeqno();
        result = result * 59 + ($orderSeqno == null ? 43 : ((Object)$orderSeqno).hashCode());
        List<Address> $signers = this.getSigners();
        result = result * 59 + ($signers == null ? 43 : ((Object)$signers).hashCode());
        Cell $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }

    public String toString() {
        return "MultiSigV2OrderData(multiSigAddress=" + String.valueOf(this.getMultiSigAddress()) + ", orderSeqno=" + String.valueOf(this.getOrderSeqno()) + ", threshold=" + this.getThreshold() + ", sentForExecution=" + this.isSentForExecution() + ", signers=" + String.valueOf(this.getSigners()) + ", approvals_mask=" + this.getApprovals_mask() + ", approvals_num=" + this.getApprovals_num() + ", expirationDate=" + this.getExpirationDate() + ", order=" + String.valueOf(this.getOrder()) + ", expirationDateString=" + this.getExpirationDateString() + ")";
    }

    public static class MultiSigV2OrderDataBuilder {
        private Address multiSigAddress;
        private BigInteger orderSeqno;
        private long threshold;
        private boolean sentForExecution;
        private List<Address> signers;
        private long approvals_mask;
        private long approvals_num;
        private long expirationDate;
        private Cell order;

        MultiSigV2OrderDataBuilder() {
        }

        public MultiSigV2OrderDataBuilder multiSigAddress(Address multiSigAddress) {
            this.multiSigAddress = multiSigAddress;
            return this;
        }

        public MultiSigV2OrderDataBuilder orderSeqno(BigInteger orderSeqno) {
            this.orderSeqno = orderSeqno;
            return this;
        }

        public MultiSigV2OrderDataBuilder threshold(long threshold) {
            this.threshold = threshold;
            return this;
        }

        public MultiSigV2OrderDataBuilder sentForExecution(boolean sentForExecution) {
            this.sentForExecution = sentForExecution;
            return this;
        }

        public MultiSigV2OrderDataBuilder signers(List<Address> signers) {
            this.signers = signers;
            return this;
        }

        public MultiSigV2OrderDataBuilder approvals_mask(long approvals_mask) {
            this.approvals_mask = approvals_mask;
            return this;
        }

        public MultiSigV2OrderDataBuilder approvals_num(long approvals_num) {
            this.approvals_num = approvals_num;
            return this;
        }

        public MultiSigV2OrderDataBuilder expirationDate(long expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public MultiSigV2OrderDataBuilder order(Cell order) {
            this.order = order;
            return this;
        }

        public MultiSigV2OrderData build() {
            return new MultiSigV2OrderData(this.multiSigAddress, this.orderSeqno, this.threshold, this.sentForExecution, this.signers, this.approvals_mask, this.approvals_num, this.expirationDate, this.order);
        }

        public String toString() {
            return "MultiSigV2OrderData.MultiSigV2OrderDataBuilder(multiSigAddress=" + String.valueOf(this.multiSigAddress) + ", orderSeqno=" + String.valueOf(this.orderSeqno) + ", threshold=" + this.threshold + ", sentForExecution=" + this.sentForExecution + ", signers=" + String.valueOf(this.signers) + ", approvals_mask=" + this.approvals_mask + ", approvals_num=" + this.approvals_num + ", expirationDate=" + this.expirationDate + ", order=" + String.valueOf(this.order) + ")";
        }
    }
}

