/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.List;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.multisig.MultiSigWalletV2;

public class MultiSigV2Config {
    public BigInteger nextOrderSeqno;
    public List<Address> signers;
    public List<Address> proposers;
    public long numberOfSigners;
    public long threshold;
    public boolean allowArbitraryOrderSeqno;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.nextOrderSeqno, 256).storeUint(this.threshold, 8).storeRef(MultiSigWalletV2.toSignersDict(this.signers)).storeUint(this.numberOfSigners, 8).storeDict(MultiSigWalletV2.toProposersDict(this.proposers)).storeBit(Boolean.valueOf(this.allowArbitraryOrderSeqno)).endCell();
    }

    MultiSigV2Config(BigInteger nextOrderSeqno, List<Address> signers, List<Address> proposers, long numberOfSigners, long threshold, boolean allowArbitraryOrderSeqno) {
        this.nextOrderSeqno = nextOrderSeqno;
        this.signers = signers;
        this.proposers = proposers;
        this.numberOfSigners = numberOfSigners;
        this.threshold = threshold;
        this.allowArbitraryOrderSeqno = allowArbitraryOrderSeqno;
    }

    public static MultiSigV2ConfigBuilder builder() {
        return new MultiSigV2ConfigBuilder();
    }

    public BigInteger getNextOrderSeqno() {
        return this.nextOrderSeqno;
    }

    public List<Address> getSigners() {
        return this.signers;
    }

    public List<Address> getProposers() {
        return this.proposers;
    }

    public long getNumberOfSigners() {
        return this.numberOfSigners;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public boolean isAllowArbitraryOrderSeqno() {
        return this.allowArbitraryOrderSeqno;
    }

    public void setNextOrderSeqno(BigInteger nextOrderSeqno) {
        this.nextOrderSeqno = nextOrderSeqno;
    }

    public void setSigners(List<Address> signers) {
        this.signers = signers;
    }

    public void setProposers(List<Address> proposers) {
        this.proposers = proposers;
    }

    public void setNumberOfSigners(long numberOfSigners) {
        this.numberOfSigners = numberOfSigners;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setAllowArbitraryOrderSeqno(boolean allowArbitraryOrderSeqno) {
        this.allowArbitraryOrderSeqno = allowArbitraryOrderSeqno;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiSigV2Config)) {
            return false;
        }
        MultiSigV2Config other = (MultiSigV2Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfSigners() != other.getNumberOfSigners()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.isAllowArbitraryOrderSeqno() != other.isAllowArbitraryOrderSeqno()) {
            return false;
        }
        BigInteger this$nextOrderSeqno = this.getNextOrderSeqno();
        BigInteger other$nextOrderSeqno = other.getNextOrderSeqno();
        if (this$nextOrderSeqno == null ? other$nextOrderSeqno != null : !((Object)this$nextOrderSeqno).equals(other$nextOrderSeqno)) {
            return false;
        }
        List<Address> this$signers = this.getSigners();
        List<Address> other$signers = other.getSigners();
        if (this$signers == null ? other$signers != null : !((Object)this$signers).equals(other$signers)) {
            return false;
        }
        List<Address> this$proposers = this.getProposers();
        List<Address> other$proposers = other.getProposers();
        return !(this$proposers == null ? other$proposers != null : !((Object)this$proposers).equals(other$proposers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiSigV2Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numberOfSigners = this.getNumberOfSigners();
        result = result * 59 + (int)($numberOfSigners >>> 32 ^ $numberOfSigners);
        long $threshold = this.getThreshold();
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        result = result * 59 + (this.isAllowArbitraryOrderSeqno() ? 79 : 97);
        BigInteger $nextOrderSeqno = this.getNextOrderSeqno();
        result = result * 59 + ($nextOrderSeqno == null ? 43 : ((Object)$nextOrderSeqno).hashCode());
        List<Address> $signers = this.getSigners();
        result = result * 59 + ($signers == null ? 43 : ((Object)$signers).hashCode());
        List<Address> $proposers = this.getProposers();
        result = result * 59 + ($proposers == null ? 43 : ((Object)$proposers).hashCode());
        return result;
    }

    public String toString() {
        return "MultiSigV2Config(nextOrderSeqno=" + String.valueOf(this.getNextOrderSeqno()) + ", signers=" + String.valueOf(this.getSigners()) + ", proposers=" + String.valueOf(this.getProposers()) + ", numberOfSigners=" + this.getNumberOfSigners() + ", threshold=" + this.getThreshold() + ", allowArbitraryOrderSeqno=" + this.isAllowArbitraryOrderSeqno() + ")";
    }

    public static class MultiSigV2ConfigBuilder {
        private BigInteger nextOrderSeqno;
        private List<Address> signers;
        private List<Address> proposers;
        private long numberOfSigners;
        private long threshold;
        private boolean allowArbitraryOrderSeqno;

        MultiSigV2ConfigBuilder() {
        }

        public MultiSigV2ConfigBuilder nextOrderSeqno(BigInteger nextOrderSeqno) {
            this.nextOrderSeqno = nextOrderSeqno;
            return this;
        }

        public MultiSigV2ConfigBuilder signers(List<Address> signers) {
            this.signers = signers;
            return this;
        }

        public MultiSigV2ConfigBuilder proposers(List<Address> proposers) {
            this.proposers = proposers;
            return this;
        }

        public MultiSigV2ConfigBuilder numberOfSigners(long numberOfSigners) {
            this.numberOfSigners = numberOfSigners;
            return this;
        }

        public MultiSigV2ConfigBuilder threshold(long threshold) {
            this.threshold = threshold;
            return this;
        }

        public MultiSigV2ConfigBuilder allowArbitraryOrderSeqno(boolean allowArbitraryOrderSeqno) {
            this.allowArbitraryOrderSeqno = allowArbitraryOrderSeqno;
            return this;
        }

        public MultiSigV2Config build() {
            return new MultiSigV2Config(this.nextOrderSeqno, this.signers, this.proposers, this.numberOfSigners, this.threshold, this.allowArbitraryOrderSeqno);
        }

        public String toString() {
            return "MultiSigV2Config.MultiSigV2ConfigBuilder(nextOrderSeqno=" + String.valueOf(this.nextOrderSeqno) + ", signers=" + String.valueOf(this.signers) + ", proposers=" + String.valueOf(this.proposers) + ", numberOfSigners=" + this.numberOfSigners + ", threshold=" + this.threshold + ", allowArbitraryOrderSeqno=" + this.allowArbitraryOrderSeqno + ")";
        }
    }
}

