/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import org.ton.java.address.Address;

public class ChannelConfig {
    BigInteger channelId;
    Address addressA;
    Address addressB;
    BigInteger initBalanceA;
    BigInteger initBalanceB;

    ChannelConfig(BigInteger channelId, Address addressA, Address addressB, BigInteger initBalanceA, BigInteger initBalanceB) {
        this.channelId = channelId;
        this.addressA = addressA;
        this.addressB = addressB;
        this.initBalanceA = initBalanceA;
        this.initBalanceB = initBalanceB;
    }

    public static ChannelConfigBuilder builder() {
        return new ChannelConfigBuilder();
    }

    public BigInteger getChannelId() {
        return this.channelId;
    }

    public Address getAddressA() {
        return this.addressA;
    }

    public Address getAddressB() {
        return this.addressB;
    }

    public BigInteger getInitBalanceA() {
        return this.initBalanceA;
    }

    public BigInteger getInitBalanceB() {
        return this.initBalanceB;
    }

    public static class ChannelConfigBuilder {
        private BigInteger channelId;
        private Address addressA;
        private Address addressB;
        private BigInteger initBalanceA;
        private BigInteger initBalanceB;

        ChannelConfigBuilder() {
        }

        public ChannelConfigBuilder channelId(BigInteger channelId) {
            this.channelId = channelId;
            return this;
        }

        public ChannelConfigBuilder addressA(Address addressA) {
            this.addressA = addressA;
            return this;
        }

        public ChannelConfigBuilder addressB(Address addressB) {
            this.addressB = addressB;
            return this;
        }

        public ChannelConfigBuilder initBalanceA(BigInteger initBalanceA) {
            this.initBalanceA = initBalanceA;
            return this;
        }

        public ChannelConfigBuilder initBalanceB(BigInteger initBalanceB) {
            this.initBalanceB = initBalanceB;
            return this;
        }

        public ChannelConfig build() {
            return new ChannelConfig(this.channelId, this.addressA, this.addressB, this.initBalanceA, this.initBalanceB);
        }

        public String toString() {
            return "ChannelConfig.ChannelConfigBuilder(channelId=" + String.valueOf(this.channelId) + ", addressA=" + String.valueOf(this.addressA) + ", addressB=" + String.valueOf(this.addressB) + ", initBalanceA=" + String.valueOf(this.initBalanceA) + ", initBalanceB=" + String.valueOf(this.initBalanceB) + ")";
        }
    }
}

