/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.util.Objects;
import org.ton.java.utils.Utils;

public class AdnlAddress {
    byte[] bytes;

    public static AdnlAddress of(String anyForm) {
        return new AdnlAddress(anyForm);
    }

    public static AdnlAddress of(byte[] anyForm) {
        return new AdnlAddress(anyForm);
    }

    public static AdnlAddress of(AdnlAddress anyForm) {
        return new AdnlAddress(anyForm);
    }

    private AdnlAddress(AdnlAddress anyForm) {
        AdnlAddress.isValid(anyForm);
        this.bytes = (byte[])anyForm.bytes.clone();
    }

    private AdnlAddress(String anyForm) {
        AdnlAddress.isValid(anyForm);
        this.bytes = Utils.hexToSignedBytes((String)anyForm);
    }

    private AdnlAddress(byte[] anyForm) {
        AdnlAddress.isValid(anyForm);
        this.bytes = (byte[])anyForm.clone();
    }

    public String toHex() {
        String hex = Utils.bytesToHex((byte[])this.bytes);
        return new String(Utils.leftPadBytes((byte[])hex.getBytes(), (int)64, (char)'0'));
    }

    public byte[] getClonedBytes() {
        return (byte[])this.bytes.clone();
    }

    public static void isValid(Object anyForm) {
        if (Objects.isNull(anyForm)) {
            throw new Error("Invalid address");
        }
        if (anyForm instanceof AdnlAddress) {
            byte[] address = ((AdnlAddress)anyForm).bytes;
            if (address.length == 0) {
                throw new Error("Invalid adnl bytes length");
            }
        } else if (anyForm instanceof String) {
            if (((String)anyForm).isEmpty()) {
                throw new Error("Invalid address");
            }
            if (((String)anyForm).length() != 64) {
                throw new Error("Invalid adnl hex length");
            }
        } else if (anyForm instanceof byte[]) {
            byte[] address = (byte[])anyForm;
            if (address.length == 0) {
                throw new Error("Invalid address");
            }
            if (address.length != 32) {
                throw new Error("Invalid adnl bytes length");
            }
        } else {
            throw new Error("Invalid object type");
        }
    }
}

