/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.nft;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.smartcontract.types.Royalty;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class NftUtils {
    private static final Logger log = LoggerFactory.getLogger(NftUtils.class);
    public static final int SNAKE_DATA_PREFIX = 0;
    public static final int CHUNK_DATA_PREFIX = 1;
    public static final int ONCHAIN_CONTENT_PREFIX = 0;
    public static final int OFFCHAIN_CONTENT_PREFIX = 1;

    public static byte[] serializeUri(String uri) {
        try {
            return URLEncoder.encode(uri, String.valueOf(StandardCharsets.UTF_8)).getBytes();
        }
        catch (Exception e) {
            throw new Error("Cannot serialize URI " + uri);
        }
    }

    static String parseUri(String uri) {
        try {
            return URLDecoder.decode(uri, String.valueOf(StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public static Cell createOffChainUriCell(String uri) {
        return CellBuilder.beginCell().storeUint(1, 8).storeSnakeString(uri).endCell();
    }

    public static String parseOffChainUriCell(Cell cell) {
        if ((cell.getBits().toByteArray()[0] & 0xFF) != 1) {
            throw new Error("not OFFCHAIN_CONTENT_PREFIX");
        }
        return NftUtils.parseUri(CellSlice.beginParse((Cell)cell).skipBits(8).loadSnakeString());
    }

    public static String parseOnChainUriCell(Cell cell) {
        if ((cell.getBits().toByteArray()[0] & 0xFF) != 0) {
            throw new Error("not ONCHAIN_CONTENT_PREFIX");
        }
        CellSlice cs = CellSlice.beginParse((Cell)cell);
        cs.skipBits(8);
        TonHashMapE loadedDict = cs.loadDictE(256, k -> k.readUint(256), v -> CellSlice.beginParse((Cell)v).loadSnakeString());
        BigInteger key = new BigInteger(Utils.sha256((byte[])"uri".getBytes()), 16);
        String uri = loadedDict.elements.get(key).toString();
        return StringUtils.trim((String)uri);
    }

    public static Cell createOnChainDataCell(String uri, Long decimals) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(0, 8);
        int keySizeX = 256;
        TonHashMapE x = new TonHashMapE(keySizeX);
        BigInteger uriKey = new BigInteger(Utils.sha256((byte[])"uri".getBytes()), 16);
        x.elements.put(uriKey, CellBuilder.beginCell().storeSnakeString(uri).endCell());
        BigInteger decimalsKey = new BigInteger(Utils.sha256((byte[])"decimals".getBytes()), 16);
        x.elements.put(uriKey, CellBuilder.beginCell().storeSnakeString(uri).endCell());
        x.elements.put(decimalsKey, CellBuilder.beginCell().storeString(decimals.toString()).endCell());
        Cell cellDict = x.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, keySizeX).endCell().getBits(), v -> CellBuilder.beginCell().storeCell((Cell)v).endCell());
        cell.storeDict(cellDict);
        return cell.endCell();
    }

    public static Address parseAddress(Cell cell) {
        return CellSlice.beginParse((Cell)cell).loadAddress();
    }

    public static Royalty getRoyaltyParams(Tonlib tonlib, Address address) {
        RunResult result = tonlib.runMethod(address, "royalty_params");
        TvmStackEntryNumber royaltyFactorNumber = (TvmStackEntryNumber)result.getStack().get(0);
        BigInteger royaltyFactor = royaltyFactorNumber.getNumber();
        TvmStackEntryNumber royaltyBaseNumber = (TvmStackEntryNumber)result.getStack().get(1);
        BigInteger royaltyBase = royaltyBaseNumber.getNumber();
        double royalty = royaltyFactor.divide(royaltyBase).doubleValue();
        TvmStackEntrySlice royaltyAddressCell = (TvmStackEntrySlice)result.getStack().get(2);
        Address royaltyAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)royaltyAddressCell.getSlice().getBytes())).endCell());
        return Royalty.builder().royaltyFactor(royaltyFactor).royaltyBase(royaltyBase).royalty(royalty).royaltyAddress(royaltyAddress).build();
    }
}

