/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.nft;

import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;

public class NftMarketplace
implements Contract {
    public static final String NFT_MARKETPLACE_CODE_HEX = "B5EE9C7241010401006D000114FF00F4A413F4BCF2C80B01020120020300AAD23221C700915BE0D0D3030171B0915BE0FA40ED44D0FA403012C705F2E19101D31F01C0018E2BFA003001D4D43021F90070C8CA07CBFFC9D077748018C8CB05CB0258CF165004FA0213CB6BCCCCC971FB00915BE20004F2308EF7CCE7";
    Address adminAddress;
    private Tonlib tonlib;
    private long wc;

    public static NftMarketplaceBuilder builder() {
        return new CustomNftMarketplaceBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "nftMarketplace";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeAddress(this.adminAddress).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(NFT_MARKETPLACE_CODE_HEX).endCell();
    }

    NftMarketplace(Address adminAddress, Tonlib tonlib, long wc) {
        this.adminAddress = adminAddress;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public Address getAdminAddress() {
        return this.adminAddress;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomNftMarketplaceBuilder
    extends NftMarketplaceBuilder {
        private CustomNftMarketplaceBuilder() {
        }

        @Override
        public NftMarketplace build() {
            if (Objects.isNull(this.adminAddress)) {
                throw new IllegalArgumentException("adminAddress parameter is mandatory.");
            }
            return super.build();
        }
    }

    public static class NftMarketplaceBuilder {
        private Address adminAddress;
        private Tonlib tonlib;
        private long wc;

        NftMarketplaceBuilder() {
        }

        public NftMarketplaceBuilder adminAddress(Address adminAddress) {
            this.adminAddress = adminAddress;
            return this;
        }

        public NftMarketplaceBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public NftMarketplaceBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public NftMarketplace build() {
            return new NftMarketplace(this.adminAddress, this.tonlib, this.wc);
        }

        public String toString() {
            return "NftMarketplace.NftMarketplaceBuilder(adminAddress=" + String.valueOf(this.adminAddress) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

