/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.payments;

import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;

public class PaymentsUtils {
    public static final long tag_init = 1768843636L;
    public static final long tag_cooperative_close = 1131179891L;
    public static final long tag_cooperative_commit = 1128492404L;
    public static final long tag_start_uncooperative_close = 1433289580L;
    public static final long tag_challenge_state = 1130915665L;
    public static final long tag_settle_conditionals = 1131168622L;
    public static final long tag_state = 1130910580L;
    public static final long op_top_up_balance = 1741148801L;
    public static final long op_init_channel = 235282626L;
    public static final long op_cooperative_close = 1433884798L;
    public static final long op_cooperative_commit = 2040604399L;
    public static final long op_start_uncooperative_close = 521476815L;
    public static final long op_challenge_quarantined_state = 143567410L;
    public static final long op_settle_conditionals = 1727459433L;
    public static final long op_finish_uncooperative_close = 625158801L;
    public static final long op_channel_closed = -572749638L;

    public static Cell createSignatureCell(byte[] signature) {
        return CellBuilder.beginCell().storeBytes(signature).endCell();
    }

    public static Cell createTopUpBalance(BigInteger coinsA, BigInteger coinsB) {
        return CellBuilder.beginCell().storeUint(1741148801L, 32).storeCoins(coinsA).storeCoins(coinsB).endCell();
    }

    public static Cell createInitChannelBody(BigInteger channelId, BigInteger balanceA, BigInteger balanceB) {
        return CellBuilder.beginCell().storeUint(1768843636L, 32).storeUint(channelId, 128).storeCoins(balanceA).storeCoins(balanceB).endCell();
    }

    public static Cell createCooperativeCloseChannelBody(BigInteger channelId, BigInteger balanceA, BigInteger balanceB, BigInteger seqnoA, BigInteger seqnoB) {
        return CellBuilder.beginCell().storeUint(1131179891L, 32).storeUint(channelId, 128).storeCoins(balanceA).storeCoins(balanceB).storeUint(seqnoA, 64).storeUint(seqnoB, 64).endCell();
    }

    public static Cell createCooperativeCommitBody(BigInteger channelId, BigInteger seqnoA, BigInteger seqnoB) {
        return CellBuilder.beginCell().storeUint(1128492404L, 32).storeUint(channelId, 128).storeUint(seqnoA, 64).storeUint(seqnoB, 64).endCell();
    }

    public static Cell createConditionalPayment(BigInteger amount, Cell condition) {
        return CellBuilder.beginCell().storeCoins(amount).storeCell(condition).endCell();
    }

    public static Cell createSemiChannelBody(BigInteger seqno, BigInteger sentCoins, Cell conditionals) {
        return CellBuilder.beginCell().storeUint(seqno, 64).storeCoins(sentCoins).storeRefMaybe(conditionals).endCell();
    }

    public static Cell createSemiChannelState(BigInteger channelId, Cell semiChannelBody, Cell counterpartySemiChannelBody) {
        return CellBuilder.beginCell().storeUint(1130910580L, 32).storeUint(channelId, 128).storeCell(semiChannelBody).storeRefMaybe(counterpartySemiChannelBody).endCell();
    }

    public static Cell createSignedSemiChannelState(byte[] signature, Cell state) {
        return CellBuilder.beginCell().storeBytes(signature).storeCell(state).endCell();
    }

    public static Cell createStartUncooperativeCloseBody(BigInteger channelId, Cell signedSemiChannelStateA, Cell signedSemiChannelStateB) {
        return CellBuilder.beginCell().storeUint(1433289580L, 32).storeUint(channelId, 128).storeRef(signedSemiChannelStateA).storeRef(signedSemiChannelStateB).endCell();
    }

    public static Cell createChallengeQuarantinedStateBody(BigInteger channelId, Cell signedSemiChannelStateA, Cell signedSemiChannelStateB) {
        return CellBuilder.beginCell().storeUint(1130915665L, 32).storeUint(channelId, 128).storeRef(signedSemiChannelStateA).storeRef(signedSemiChannelStateB).endCell();
    }

    public static Cell createSettleConditionalsBody(BigInteger channelId, Cell conditionalsToSettle) {
        return CellBuilder.beginCell().storeUint(1131168622L, 32).storeUint(channelId, 128).storeRefMaybe(conditionalsToSettle).endCell();
    }

    public static Cell createFinishUncooperativeClose() {
        return CellBuilder.beginCell().storeUint(625158801L, 32).endCell();
    }

    public static Cell createOneSignature(long op, boolean isA, byte[] signature, Cell cell) {
        return CellBuilder.beginCell().storeUint(op, 32).storeBit(Boolean.valueOf(isA)).storeBytes(signature).storeCell(cell).endCell();
    }

    public static Cell createTwoSignature(long op, byte[] signatureA, byte[] signatureB, Cell cell) {
        return CellBuilder.beginCell().storeUint(op, 32).storeRef(PaymentsUtils.createSignatureCell(signatureA)).storeRef(PaymentsUtils.createSignatureCell(signatureB)).storeCell(cell).endCell();
    }
}

