/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.multisig;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.smartcontract.types.MultiSigV2Action;
import org.ton.java.smartcontract.types.MultiSigV2Config;
import org.ton.java.smartcontract.types.MultiSigV2Data;
import org.ton.java.smartcontract.types.MultiSigV2OrderData;
import org.ton.java.smartcontract.types.MultiSigV2SendMessageAction;
import org.ton.java.smartcontract.types.MultiSigV2UpdateParamsAction;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;

public class MultiSigWalletV2
implements Contract {
    private static final Logger log = LoggerFactory.getLogger(MultiSigWalletV2.class);
    MultiSigV2Config config;
    private Tonlib tonlib;
    private long wc;

    public static MultiSigWalletV2Builder builder() {
        return new CustomMultiSigWalletV2Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "multisig-v2";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.config.getNextOrderSeqno(), 256).storeUint(this.config.getThreshold(), 8).storeRef(MultiSigWalletV2.toSignersDict(this.config.getSigners())).storeUint(this.config.getNumberOfSigners(), 8).storeDict(MultiSigWalletV2.toProposersDict(this.config.getProposers())).storeBit(Boolean.valueOf(this.config.isAllowArbitraryOrderSeqno())).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.multisigV2.getValue()).endCell();
    }

    public ExtMessageInfo deploy() {
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    private static TonHashMapE convertExtraCurrenciesToMap(List<ExtraCurrency> extraCurrencies) {
        if (Objects.isNull(extraCurrencies)) {
            return null;
        }
        TonHashMapE x = new TonHashMapE(32);
        for (ExtraCurrency ec : extraCurrencies) {
            x.elements.put(ec.getId(), ec.getAmount());
        }
        return x;
    }

    public static MultiSigV2Action createSendMessageAction(int mode, Cell message) {
        return MultiSigV2SendMessageAction.builder().mode(mode).message(message).build();
    }

    public static Cell createOrder(List<MultiSigV2Action> multiSigV2Actions) {
        int dictKeySize = 8;
        TonHashMap dictOrders = new TonHashMap(dictKeySize);
        int i = 0;
        for (MultiSigV2Action multiSigV2Action : multiSigV2Actions) {
            dictOrders.elements.put(i++, multiSigV2Action.toCell());
        }
        return dictOrders.serialize(k -> CellBuilder.beginCell().storeUint(((Integer)k).intValue(), dictKeySize).endCell().getBits(), v -> CellBuilder.beginCell().storeRef((Cell)v).endCell());
    }

    public static MultiSigV2UpdateParamsAction updateMultiSigParam(long newThreshold, List<Address> newSigners, List<Address> newProposers) {
        return MultiSigV2UpdateParamsAction.builder().newThreshold(newThreshold).newSigners(newSigners).newProposers(newProposers).build();
    }

    public static Cell newOrder(long queryId, BigInteger orderSeqno, boolean isSigner, long signerIndex, long expirationDate, Cell order) {
        return CellBuilder.beginCell().storeUint(4145565967L, 32).storeUint(queryId, 64).storeUint(orderSeqno, 256).storeBit(Boolean.valueOf(isSigner)).storeUint(signerIndex, 8).storeUint(expirationDate, 48).storeRef(order).endCell();
    }

    public static Cell approve(long queryId, long signerIndex) {
        return CellBuilder.beginCell().storeUint(2808226575L, 32).storeUint(queryId, 64).storeUint(signerIndex, 8).endCell();
    }

    private Cell executeOrder(long queryId, BigInteger orderSeqno, long expirationDate, long numberOfApprovals, Cell signersCell, Cell order) {
        return CellBuilder.beginCell().storeUint(1963556701L, 32).storeUint(queryId, 64).storeUint(orderSeqno, 256).storeUint(expirationDate, 48).storeUint(numberOfApprovals, 8).storeBytes(signersCell.getHash(), 256).storeRef(order).endCell();
    }

    public Address getOrderAddress(BigInteger orderSeqno) {
        ArrayDeque<CallSite> stackData = new ArrayDeque<CallSite>();
        stackData.offer((CallSite)((Object)("[num, " + String.valueOf(orderSeqno) + "]")));
        RunResult runResult = this.tonlib.runMethod(this.getAddress(), "get_order_address", stackData);
        TvmStackEntrySlice orderAddrCell = (TvmStackEntrySlice)runResult.getStack().get(0);
        return MsgAddressInt.deserialize((CellSlice)CellSlice.beginParse((Cell)Cell.fromBocBase64((String)orderAddrCell.getSlice().getBytes()))).toAddress();
    }

    public MultiSigV2OrderData getOrderData(BigInteger orderSeqno) {
        Address orderAddress = this.getOrderAddress(orderSeqno);
        RunResult runResult = this.tonlib.runMethod(orderAddress, "get_order_data");
        TvmStackEntrySlice multiSigAddressCell = (TvmStackEntrySlice)runResult.getStack().get(0);
        TvmStackEntryNumber orderSeqNo = (TvmStackEntryNumber)runResult.getStack().get(1);
        TvmStackEntryNumber threshold = (TvmStackEntryNumber)runResult.getStack().get(2);
        TvmStackEntryNumber sentForExecution = (TvmStackEntryNumber)runResult.getStack().get(3);
        TvmStackEntryCell signersCell = (TvmStackEntryCell)runResult.getStack().get(4);
        TonHashMap signers = CellSlice.beginParse((Cell)Cell.fromBocBase64((String)signersCell.getCell().getBytes())).loadDict(8, k -> k.readUint(8), v -> MsgAddressIntStd.deserialize((CellSlice)CellSlice.beginParse((Cell)v)));
        TvmStackEntryNumber approvalsMask = (TvmStackEntryNumber)runResult.getStack().get(5);
        TvmStackEntryNumber numberOfApprovals = (TvmStackEntryNumber)runResult.getStack().get(6);
        TvmStackEntryNumber expirationDate = (TvmStackEntryNumber)runResult.getStack().get(7);
        TvmStackEntryCell order = (TvmStackEntryCell)runResult.getStack().get(8);
        return MultiSigV2OrderData.builder().multiSigAddress(MsgAddressInt.deserialize((CellSlice)CellSlice.beginParse((Cell)Cell.fromBocBase64((String)multiSigAddressCell.getSlice().getBytes()))).toAddress()).orderSeqno(orderSeqNo.getNumber()).threshold(threshold.getNumber().longValue()).sentForExecution(sentForExecution.getNumber().longValue() == -1L).signers(this.fromSignersDict(signers)).approvals_mask(approvalsMask.getNumber().longValue()).approvals_num(numberOfApprovals.getNumber().longValue()).expirationDate(expirationDate.getNumber().longValue()).order(Cell.fromBocBase64((String)order.getCell().getBytes())).build();
    }

    public BigInteger getOrderEstimate(Cell order, long expirationDate) {
        ArrayDeque<CallSite> stackData = new ArrayDeque<CallSite>();
        stackData.offer((CallSite)((Object)("[cell, " + order.toHex() + "]")));
        stackData.offer((CallSite)((Object)("[num, " + expirationDate + "]")));
        RunResult runResult = this.tonlib.runMethod(this.getAddress(), "get_order_estimate", stackData);
        TvmStackEntryNumber estimatedGas = (TvmStackEntryNumber)runResult.getStack().get(0);
        return estimatedGas.getNumber();
    }

    public MultiSigV2Data getMultiSigData() {
        RunResult runResult = this.tonlib.runMethod(this.getAddress(), "get_multisig_data");
        TvmStackEntryNumber nextOrderSeqno = (TvmStackEntryNumber)runResult.getStack().get(0);
        TvmStackEntryNumber threshold = (TvmStackEntryNumber)runResult.getStack().get(1);
        TvmStackEntryCell signersCell = (TvmStackEntryCell)runResult.getStack().get(2);
        TonHashMap signers = CellSlice.beginParse((Cell)Cell.fromBocBase64((String)signersCell.getCell().getBytes())).loadDict(8, k -> k.readUint(8), v -> MsgAddressIntStd.deserialize((CellSlice)CellSlice.beginParse((Cell)v)));
        TvmStackEntryCell proposersCell = (TvmStackEntryCell)runResult.getStack().get(3);
        TonHashMap proposers = CellSlice.beginParse((Cell)Cell.fromBocBase64((String)proposersCell.getCell().getBytes())).loadDict(8, k -> k.readUint(8), v -> MsgAddressIntStd.deserialize((CellSlice)CellSlice.beginParse((Cell)v)));
        return MultiSigV2Data.builder().nextOrderSeqno(nextOrderSeqno.getNumber()).threshold(threshold.getNumber().longValue()).signers(this.fromSignersDict(signers)).proposers(this.fromProposersDict(proposers)).build();
    }

    private List<Address> fromSignersDict(TonHashMap signersDict) {
        ArrayList<Address> result = new ArrayList<Address>();
        for (Map.Entry entry : signersDict.elements.entrySet()) {
            result.add(((MsgAddressIntStd)entry.getValue()).toAddress());
        }
        return result;
    }

    private List<Address> fromProposersDict(TonHashMap proposersDict) {
        ArrayList<Address> result = new ArrayList<Address>();
        for (Map.Entry entry : proposersDict.elements.entrySet()) {
            result.add(((MsgAddressIntStd)entry.getValue()).toAddress());
        }
        return result;
    }

    public static Cell toSignersDict(List<Address> signers) {
        int dictKeySize = 8;
        TonHashMap dict = new TonHashMap(dictKeySize);
        long i = 0L;
        for (Address signer : signers) {
            dict.elements.put(i++, MsgAddressIntStd.of((Address)signer).toCell());
        }
        return dict.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), dictKeySize).endCell().getBits(), v -> (Cell)v);
    }

    public static Cell toProposersDict(List<Address> proposers) {
        int dictKeySize = 8;
        TonHashMapE dict = new TonHashMapE(dictKeySize);
        long i = 0L;
        for (Address proposer : proposers) {
            dict.elements.put(i++, MsgAddressIntStd.of((Address)proposer).toCell());
        }
        return dict.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), dictKeySize).endCell().getBits(), v -> (Cell)v);
    }

    MultiSigWalletV2(MultiSigV2Config config, Tonlib tonlib, long wc) {
        this.config = config;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public MultiSigV2Config getConfig() {
        return this.config;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomMultiSigWalletV2Builder
    extends MultiSigWalletV2Builder {
        private CustomMultiSigWalletV2Builder() {
        }

        @Override
        public MultiSigWalletV2 build() {
            return super.build();
        }
    }

    public static class MultiSigWalletV2Builder {
        private MultiSigV2Config config;
        private Tonlib tonlib;
        private long wc;

        MultiSigWalletV2Builder() {
        }

        public MultiSigWalletV2Builder config(MultiSigV2Config config) {
            this.config = config;
            return this;
        }

        public MultiSigWalletV2Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public MultiSigWalletV2Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public MultiSigWalletV2 build() {
            return new MultiSigWalletV2(this.config, this.tonlib, this.wc);
        }

        public String toString() {
            return "MultiSigWalletV2.MultiSigWalletV2Builder(config=" + String.valueOf(this.config) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

