/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.highload;

import com.iwebpp.crypto.TweetNaclFast;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.types.Destination;
import org.ton.java.smartcontract.types.HighloadV3Config;
import org.ton.java.smartcontract.types.HighloadV3InternalMessageBody;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.ActionSendMsg;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddress;
import org.ton.java.tlb.MsgAddressExtNone;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.OutAction;
import org.ton.java.tlb.OutList;
import org.ton.java.tlb.StateInit;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

public class HighloadWalletV3
implements Contract {
    TweetNaclFast.Signature.KeyPair keyPair;
    long walletId;
    long timeout;
    private Tonlib tonlib;
    private long wc;

    public static HighloadWalletV3Builder builder() {
        return new CustomHighloadWalletV3Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "highload-v3";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeBytes(this.keyPair.getPublicKey()).storeUint(this.walletId, 32).storeBit(Boolean.valueOf(false)).storeBit(Boolean.valueOf(false)).storeUint(0, 64).storeUint(this.timeout == 0L ? 300L : this.timeout, 22).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.highloadV3.getValue()).endCell();
    }

    public String getPublicKey() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_public_key");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_public_key, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber publicKeyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return publicKeyNumber.getNumber().toString(16);
    }

    public Cell createTransferMessage(HighloadV3Config highloadConfig) {
        return CellBuilder.beginCell().storeUint(highloadConfig.getWalletId(), 32).storeRef(highloadConfig.getBody()).storeUint(highloadConfig.getMode() == 0 ? 3 : highloadConfig.getMode(), 8).storeUint(highloadConfig.getQueryId(), 23).storeUint(highloadConfig.getCreatedAt() == 0L ? Instant.now().getEpochSecond() - 60L : highloadConfig.getCreatedAt(), 64).storeUint(highloadConfig.getTimeOut() == 0L ? 300L : highloadConfig.getTimeOut(), 22).endCell();
    }

    public ExtMessageInfo send(HighloadV3Config highloadConfig) {
        Address ownAddress = this.getAddress();
        Cell body = this.createTransferMessage(highloadConfig);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeRef(body).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public RawTransaction sendWithConfirmation(HighloadV3Config highloadConfig) {
        Address ownAddress = this.getAddress();
        Cell body = this.createTransferMessage(highloadConfig);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeRef(body).endCell()).build();
        return this.tonlib.sendRawMessageWithConfirmation(externalMessage.toCell().toBase64(), this.getAddress());
    }

    public ExtMessageInfo deploy(HighloadV3Config highloadConfig) {
        Address ownAddress = this.getAddress();
        if (Objects.isNull(highloadConfig.getBody())) {
            highloadConfig.setBody(MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).createdAt(highloadConfig.getCreatedAt() == 0L ? Instant.now().getEpochSecond() - 60L : highloadConfig.getCreatedAt()).build()).build().toCell());
        }
        Cell innerMsg = this.createTransferMessage(highloadConfig);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])innerMsg.hash())).storeRef(innerMsg).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public Cell createSingleTransfer(Address destAddress, BigInteger amount, Boolean bounce, StateInit stateInit, Cell body) {
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(bounce).srcAddr((MsgAddress)MsgAddressExtNone.builder().build()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destAddress.wc).address(destAddress.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).build()).build()).init(stateInit).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeRef(body).endCell()).build().toCell();
    }

    public Cell createSingleTransfer(Address destAddress, BigInteger amount, List<ExtraCurrency> extraCurrencies, Boolean bounce, StateInit stateInit, Cell body) {
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(bounce).srcAddr((MsgAddress)MsgAddressExtNone.builder().build()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destAddress.wc).address(destAddress.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).extraCurrencies(this.convertExtraCurrenciesToHashMap(extraCurrencies)).build()).build()).init(stateInit).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeRef(body).endCell()).build().toCell();
    }

    public Cell createBulkTransfer(BigInteger totalAmount, Cell bulkMessages) {
        Address ownAddress = this.getAddress();
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).value(CurrencyCollection.builder().coins(totalAmount).build()).build()).body(bulkMessages).build().toCell();
    }

    public Cell createBulkTransfer(List<Destination> recipients, BigInteger queryId) {
        if (recipients.size() > 1000) {
            throw new IllegalArgumentException("Maximum number of recipients should be less than 1000");
        }
        BigInteger totalAmount = BigInteger.ZERO;
        for (Destination destination : recipients) {
            totalAmount = totalAmount.add(Objects.isNull(destination.getAmount()) ? BigInteger.ZERO : destination.getAmount());
        }
        ArrayList<Destination> tmpRecipients = new ArrayList<Destination>(recipients);
        Cell chunk1 = this.addChunk(tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)), queryId, null);
        tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)).clear();
        if (tmpRecipients.isEmpty()) {
            return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(totalAmount).build()).build()).body(chunk1).build().toCell();
        }
        Cell chunk2 = this.addChunk(tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)), queryId, chunk1);
        tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)).clear();
        if (tmpRecipients.isEmpty()) {
            return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(totalAmount.add(BigInteger.valueOf(Utils.toNano((double)0.01).longValue()))).build()).build()).body(chunk2).build().toCell();
        }
        Cell chunk3 = this.addChunk(tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)), queryId, chunk2);
        tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)).clear();
        if (tmpRecipients.isEmpty()) {
            return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(totalAmount.add(Utils.toNano((double)0.02))).build()).build()).body(chunk3).build().toCell();
        }
        Cell chunk4 = this.addChunk(tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)), queryId, chunk3);
        tmpRecipients.subList(0, Math.min(tmpRecipients.size(), 250)).clear();
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(totalAmount.add(Utils.toNano((double)0.03))).build()).build()).body(chunk4).build().toCell();
    }

    private Cell addChunk(List<Destination> destinations, BigInteger queryId, Cell enclosedMessages) {
        ArrayList<OutAction> outActions = new ArrayList<OutAction>();
        if (Objects.isNull(enclosedMessages)) {
            for (Destination destination : destinations) {
                outActions.add(this.convertDestinationToOutAction(destination, null));
            }
        } else {
            for (int i = 0; i <= destinations.size() - 1; ++i) {
                outActions.add(this.convertDestinationToOutAction(destinations.get(i), null));
            }
            outActions.add(this.convertDestinationToOutAction(destinations.get(destinations.size() - 1), enclosedMessages));
        }
        return HighloadV3InternalMessageBody.builder().queryId(queryId).actions(OutList.builder().actions(outActions).build()).build().toCell();
    }

    private OutAction convertDestinationToOutAction(Destination destination, Cell enclosedMessages) {
        Address dstAddress = Address.of((String)destination.getAddress());
        if (Objects.isNull(enclosedMessages)) {
            return ActionSendMsg.builder().mode(destination.getMode() == 0 ? 3 : destination.getMode()).outMsg(MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(Boolean.valueOf(destination.isBounce())).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(dstAddress.wc).address(dstAddress.toBigInteger()).build()).value(CurrencyCollection.builder().coins(destination.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(destination.getExtraCurrencies())).build()).build()).body(Objects.isNull(destination.getBody()) && StringUtils.isNotEmpty((CharSequence)destination.getComment()) ? CellBuilder.beginCell().storeUint(0, 32).storeString(destination.getComment()).endCell() : destination.getBody()).build()).build();
        }
        return ActionSendMsg.builder().mode(3).outMsg(MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(Utils.toNano((double)0.01)).build()).build()).body(enclosedMessages).build()).build();
    }

    public long getSubWalletId() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_subwallet_id");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_subwallet_id returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber walletId = (TvmStackEntryNumber)result.getStack().get(0);
        return walletId.getNumber().longValue();
    }

    public long getLastCleanTime() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_last_clean_time");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_last_clean_time returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber lastCleanTime = (TvmStackEntryNumber)result.getStack().get(0);
        return lastCleanTime.getNumber().longValue();
    }

    public long getTimeout() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_timeout");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_timeout returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber timeout = (TvmStackEntryNumber)result.getStack().get(0);
        return timeout.getNumber().longValue();
    }

    public boolean isProcessed(long queryId, boolean needClean) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        int needCleanInt = needClean ? -1 : 0;
        stack.offer((CallSite)((Object)("[num, " + queryId + "]")));
        stack.offer((CallSite)((Object)("[num, " + needCleanInt + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "processed?", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method processed? returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber timeout = (TvmStackEntryNumber)result.getStack().get(0);
        return timeout.getNumber().longValue() == -1L;
    }

    HighloadWalletV3(TweetNaclFast.Signature.KeyPair keyPair, long walletId, long timeout, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.walletId = walletId;
        this.timeout = timeout;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getWalletId() {
        return this.walletId;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomHighloadWalletV3Builder
    extends HighloadWalletV3Builder {
        private CustomHighloadWalletV3Builder() {
        }

        @Override
        public HighloadWalletV3 build() {
            if (Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class HighloadWalletV3Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long walletId;
        private long timeout;
        private Tonlib tonlib;
        private long wc;

        HighloadWalletV3Builder() {
        }

        public HighloadWalletV3Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public HighloadWalletV3Builder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public HighloadWalletV3Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public HighloadWalletV3Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public HighloadWalletV3Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public HighloadWalletV3 build() {
            return new HighloadWalletV3(this.keyPair, this.walletId, this.timeout, this.tonlib, this.wc);
        }

        public String toString() {
            return "HighloadWalletV3.HighloadWalletV3Builder(keyPair=" + String.valueOf(this.keyPair) + ", walletId=" + this.walletId + ", timeout=" + this.timeout + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

