/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.cell.Cell;
import org.ton.java.fift.FiftRunner;
import org.ton.java.func.FuncRunner;
import org.ton.java.tolk.TolkRunner;

public class SmartContractCompiler {
    private static final Logger log = LoggerFactory.getLogger(SmartContractCompiler.class);
    String contractPath;
    String contractAsResource;
    private FiftRunner fiftRunner;
    private FuncRunner funcRunner;
    private TolkRunner tolkRunner;
    private Boolean printInfo;
    private boolean printFiftAsmOutput;

    public static SmartContractCompilerBuilder builder() {
        return new CustomSmartContractCompilerBuilder();
    }

    public String compile() {
        Object outputFiftAsmFile;
        if (StringUtils.isNotEmpty((CharSequence)this.contractAsResource)) {
            try {
                URL resource = SmartContractCompiler.class.getClassLoader().getResource(this.contractAsResource);
                this.contractPath = Paths.get(resource.toURI()).toFile().getAbsolutePath();
            }
            catch (Exception e) {
                throw new Error("Can't find resource " + this.contractAsResource);
            }
        }
        if (Objects.isNull(this.printInfo)) {
            log.info("workdir " + new File(this.contractPath).getParent());
        }
        if (this.contractPath.contains(".func") || this.contractPath.contains(".fc")) {
            outputFiftAsmFile = this.funcRunner.run(new File(this.contractPath).getParent(), new String[]{this.contractPath});
            outputFiftAsmFile = "\"TonUtil.fif\" include \"Asm.fif\" include PROGRAM{ " + (String)outputFiftAsmFile + "}END>c 2 boc+>B dup Bx.";
            outputFiftAsmFile = ((String)outputFiftAsmFile).replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "").replaceAll("\n", " ").replaceAll("\r", " ");
        } else {
            outputFiftAsmFile = this.tolkRunner.run(new File(this.contractPath).getParent(), new String[]{this.contractPath});
            outputFiftAsmFile = "\"TonUtil.fif\" include " + (String)outputFiftAsmFile + " 2 boc+>B dup Bx.";
            outputFiftAsmFile = ((String)outputFiftAsmFile).replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "").replaceAll("\n", " ").replaceAll("\r", " ");
        }
        if (((String)outputFiftAsmFile).contains("cannot generate code") || ((String)outputFiftAsmFile).contains(": error:") || ((String)outputFiftAsmFile).contains("Failed to discover")) {
            throw new Error("Compile error: " + (String)outputFiftAsmFile);
        }
        if (this.printFiftAsmOutput) {
            log.info((String)outputFiftAsmFile);
        }
        try {
            File fiftFile = new File(this.contractPath + ".fif");
            FileUtils.writeStringToFile((File)fiftFile, (String)outputFiftAsmFile, (Charset)Charset.defaultCharset());
            String result = this.fiftRunner.run(new File(this.contractPath).getParent(), new String[]{"-s", fiftFile.getAbsolutePath()});
            FileUtils.deleteQuietly((File)fiftFile);
            return result;
        }
        catch (Exception e) {
            throw new Error("Cannot compile " + this.contractPath + ", error " + e.getMessage());
        }
    }

    public Cell compileToCell() {
        return Cell.fromBoc((String)this.compile());
    }

    SmartContractCompiler(String contractPath, String contractAsResource, FiftRunner fiftRunner, FuncRunner funcRunner, TolkRunner tolkRunner, Boolean printInfo, boolean printFiftAsmOutput) {
        this.contractPath = contractPath;
        this.contractAsResource = contractAsResource;
        this.fiftRunner = fiftRunner;
        this.funcRunner = funcRunner;
        this.tolkRunner = tolkRunner;
        this.printInfo = printInfo;
        this.printFiftAsmOutput = printFiftAsmOutput;
    }

    public String getContractPath() {
        return this.contractPath;
    }

    public String getContractAsResource() {
        return this.contractAsResource;
    }

    public FiftRunner getFiftRunner() {
        return this.fiftRunner;
    }

    public FuncRunner getFuncRunner() {
        return this.funcRunner;
    }

    public TolkRunner getTolkRunner() {
        return this.tolkRunner;
    }

    public Boolean getPrintInfo() {
        return this.printInfo;
    }

    public boolean isPrintFiftAsmOutput() {
        return this.printFiftAsmOutput;
    }

    public void setContractPath(String contractPath) {
        this.contractPath = contractPath;
    }

    public void setContractAsResource(String contractAsResource) {
        this.contractAsResource = contractAsResource;
    }

    public void setFiftRunner(FiftRunner fiftRunner) {
        this.fiftRunner = fiftRunner;
    }

    public void setFuncRunner(FuncRunner funcRunner) {
        this.funcRunner = funcRunner;
    }

    public void setTolkRunner(TolkRunner tolkRunner) {
        this.tolkRunner = tolkRunner;
    }

    public void setPrintInfo(Boolean printInfo) {
        this.printInfo = printInfo;
    }

    public void setPrintFiftAsmOutput(boolean printFiftAsmOutput) {
        this.printFiftAsmOutput = printFiftAsmOutput;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartContractCompiler)) {
            return false;
        }
        SmartContractCompiler other = (SmartContractCompiler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrintFiftAsmOutput() != other.isPrintFiftAsmOutput()) {
            return false;
        }
        Boolean this$printInfo = this.getPrintInfo();
        Boolean other$printInfo = other.getPrintInfo();
        if (this$printInfo == null ? other$printInfo != null : !((Object)this$printInfo).equals(other$printInfo)) {
            return false;
        }
        String this$contractPath = this.getContractPath();
        String other$contractPath = other.getContractPath();
        if (this$contractPath == null ? other$contractPath != null : !this$contractPath.equals(other$contractPath)) {
            return false;
        }
        String this$contractAsResource = this.getContractAsResource();
        String other$contractAsResource = other.getContractAsResource();
        if (this$contractAsResource == null ? other$contractAsResource != null : !this$contractAsResource.equals(other$contractAsResource)) {
            return false;
        }
        FiftRunner this$fiftRunner = this.getFiftRunner();
        FiftRunner other$fiftRunner = other.getFiftRunner();
        if (this$fiftRunner == null ? other$fiftRunner != null : !this$fiftRunner.equals(other$fiftRunner)) {
            return false;
        }
        FuncRunner this$funcRunner = this.getFuncRunner();
        FuncRunner other$funcRunner = other.getFuncRunner();
        if (this$funcRunner == null ? other$funcRunner != null : !this$funcRunner.equals(other$funcRunner)) {
            return false;
        }
        TolkRunner this$tolkRunner = this.getTolkRunner();
        TolkRunner other$tolkRunner = other.getTolkRunner();
        return !(this$tolkRunner == null ? other$tolkRunner != null : !this$tolkRunner.equals(other$tolkRunner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartContractCompiler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrintFiftAsmOutput() ? 79 : 97);
        Boolean $printInfo = this.getPrintInfo();
        result = result * 59 + ($printInfo == null ? 43 : ((Object)$printInfo).hashCode());
        String $contractPath = this.getContractPath();
        result = result * 59 + ($contractPath == null ? 43 : $contractPath.hashCode());
        String $contractAsResource = this.getContractAsResource();
        result = result * 59 + ($contractAsResource == null ? 43 : $contractAsResource.hashCode());
        FiftRunner $fiftRunner = this.getFiftRunner();
        result = result * 59 + ($fiftRunner == null ? 43 : $fiftRunner.hashCode());
        FuncRunner $funcRunner = this.getFuncRunner();
        result = result * 59 + ($funcRunner == null ? 43 : $funcRunner.hashCode());
        TolkRunner $tolkRunner = this.getTolkRunner();
        result = result * 59 + ($tolkRunner == null ? 43 : $tolkRunner.hashCode());
        return result;
    }

    public String toString() {
        return "SmartContractCompiler(contractPath=" + this.getContractPath() + ", contractAsResource=" + this.getContractAsResource() + ", fiftRunner=" + String.valueOf(this.getFiftRunner()) + ", funcRunner=" + String.valueOf(this.getFuncRunner()) + ", tolkRunner=" + String.valueOf(this.getTolkRunner()) + ", printInfo=" + this.getPrintInfo() + ", printFiftAsmOutput=" + this.isPrintFiftAsmOutput() + ")";
    }

    private static class CustomSmartContractCompilerBuilder
    extends SmartContractCompilerBuilder {
        private CustomSmartContractCompilerBuilder() {
        }

        @Override
        public SmartContractCompiler build() {
            if (Objects.isNull(this.printInfo)) {
                this.printInfo = true;
            }
            if (Objects.isNull(this.funcRunner)) {
                this.funcRunner = FuncRunner.builder().build();
            }
            if (Objects.isNull(this.fiftRunner)) {
                this.fiftRunner = FiftRunner.builder().build();
            }
            if (Objects.isNull(this.tolkRunner)) {
                this.tolkRunner = TolkRunner.builder().build();
            }
            return super.build();
        }
    }

    public static class SmartContractCompilerBuilder {
        private String contractPath;
        private String contractAsResource;
        private FiftRunner fiftRunner;
        private FuncRunner funcRunner;
        private TolkRunner tolkRunner;
        private Boolean printInfo;
        private boolean printFiftAsmOutput;

        SmartContractCompilerBuilder() {
        }

        public SmartContractCompilerBuilder contractPath(String contractPath) {
            this.contractPath = contractPath;
            return this;
        }

        public SmartContractCompilerBuilder contractAsResource(String contractAsResource) {
            this.contractAsResource = contractAsResource;
            return this;
        }

        public SmartContractCompilerBuilder fiftRunner(FiftRunner fiftRunner) {
            this.fiftRunner = fiftRunner;
            return this;
        }

        public SmartContractCompilerBuilder funcRunner(FuncRunner funcRunner) {
            this.funcRunner = funcRunner;
            return this;
        }

        public SmartContractCompilerBuilder tolkRunner(TolkRunner tolkRunner) {
            this.tolkRunner = tolkRunner;
            return this;
        }

        public SmartContractCompilerBuilder printInfo(Boolean printInfo) {
            this.printInfo = printInfo;
            return this;
        }

        public SmartContractCompilerBuilder printFiftAsmOutput(boolean printFiftAsmOutput) {
            this.printFiftAsmOutput = printFiftAsmOutput;
            return this;
        }

        public SmartContractCompiler build() {
            return new SmartContractCompiler(this.contractPath, this.contractAsResource, this.fiftRunner, this.funcRunner, this.tolkRunner, this.printInfo, this.printFiftAsmOutput);
        }

        public String toString() {
            return "SmartContractCompiler.SmartContractCompilerBuilder(contractPath=" + this.contractPath + ", contractAsResource=" + this.contractAsResource + ", fiftRunner=" + String.valueOf(this.fiftRunner) + ", funcRunner=" + String.valueOf(this.funcRunner) + ", tolkRunner=" + String.valueOf(this.tolkRunner) + ", printInfo=" + this.printInfo + ", printFiftAsmOutput=" + this.printFiftAsmOutput + ")";
        }
    }
}

