/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract;

import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;

public class LibraryDeployer
implements Contract {
    private Tonlib tonlib;
    private long wc;
    Cell libraryDeployerCode;
    Cell libraryCode;

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return -1L;
    }

    @Override
    public String getName() {
        return "LibraryDeployer";
    }

    @Override
    public Cell createCodeCell() {
        if (Objects.isNull(this.libraryDeployerCode)) {
            return CellBuilder.beginCell().fromBoc(WalletCodes.libraryDeployer.getValue()).endCell();
        }
        return this.libraryDeployerCode;
    }

    @Override
    public Cell createDataCell() {
        return this.libraryCode;
    }

    public static LibraryDeployerBuilder builder() {
        return new CustomLibraryDeployerBuilder();
    }

    @Override
    public Message prepareDeployMsg() {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).build();
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg().toCell().toBase64());
    }

    LibraryDeployer(Tonlib tonlib, long wc, Cell libraryDeployerCode, Cell libraryCode) {
        this.tonlib = tonlib;
        this.wc = wc;
        this.libraryDeployerCode = libraryDeployerCode;
        this.libraryCode = libraryCode;
    }

    public long getWc() {
        return this.wc;
    }

    public Cell getLibraryDeployerCode() {
        return this.libraryDeployerCode;
    }

    public Cell getLibraryCode() {
        return this.libraryCode;
    }

    public void setWc(long wc) {
        this.wc = wc;
    }

    public void setLibraryDeployerCode(Cell libraryDeployerCode) {
        this.libraryDeployerCode = libraryDeployerCode;
    }

    public void setLibraryCode(Cell libraryCode) {
        this.libraryCode = libraryCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LibraryDeployer)) {
            return false;
        }
        LibraryDeployer other = (LibraryDeployer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWc() != other.getWc()) {
            return false;
        }
        Tonlib this$tonlib = this.getTonlib();
        Tonlib other$tonlib = other.getTonlib();
        if (this$tonlib == null ? other$tonlib != null : !this$tonlib.equals(other$tonlib)) {
            return false;
        }
        Cell this$libraryDeployerCode = this.getLibraryDeployerCode();
        Cell other$libraryDeployerCode = other.getLibraryDeployerCode();
        if (this$libraryDeployerCode == null ? other$libraryDeployerCode != null : !this$libraryDeployerCode.equals(other$libraryDeployerCode)) {
            return false;
        }
        Cell this$libraryCode = this.getLibraryCode();
        Cell other$libraryCode = other.getLibraryCode();
        return !(this$libraryCode == null ? other$libraryCode != null : !this$libraryCode.equals(other$libraryCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LibraryDeployer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $wc = this.getWc();
        result = result * 59 + (int)($wc >>> 32 ^ $wc);
        Tonlib $tonlib = this.getTonlib();
        result = result * 59 + ($tonlib == null ? 43 : $tonlib.hashCode());
        Cell $libraryDeployerCode = this.getLibraryDeployerCode();
        result = result * 59 + ($libraryDeployerCode == null ? 43 : $libraryDeployerCode.hashCode());
        Cell $libraryCode = this.getLibraryCode();
        result = result * 59 + ($libraryCode == null ? 43 : $libraryCode.hashCode());
        return result;
    }

    public String toString() {
        return "LibraryDeployer(tonlib=" + String.valueOf(this.getTonlib()) + ", wc=" + this.getWc() + ", libraryDeployerCode=" + String.valueOf(this.getLibraryDeployerCode()) + ", libraryCode=" + String.valueOf(this.getLibraryCode()) + ")";
    }

    private static class CustomLibraryDeployerBuilder
    extends LibraryDeployerBuilder {
        private CustomLibraryDeployerBuilder() {
        }

        @Override
        public LibraryDeployer build() {
            return super.build();
        }
    }

    public static class LibraryDeployerBuilder {
        private Tonlib tonlib;
        private long wc;
        private Cell libraryDeployerCode;
        private Cell libraryCode;

        LibraryDeployerBuilder() {
        }

        public LibraryDeployerBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public LibraryDeployerBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public LibraryDeployerBuilder libraryDeployerCode(Cell libraryDeployerCode) {
            this.libraryDeployerCode = libraryDeployerCode;
            return this;
        }

        public LibraryDeployerBuilder libraryCode(Cell libraryCode) {
            this.libraryCode = libraryCode;
            return this;
        }

        public LibraryDeployer build() {
            return new LibraryDeployer(this.tonlib, this.wc, this.libraryDeployerCode, this.libraryCode);
        }

        public String toString() {
            return "LibraryDeployer.LibraryDeployerBuilder(tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ", libraryDeployerCode=" + String.valueOf(this.libraryDeployerCode) + ", libraryCode=" + String.valueOf(this.libraryCode) + ")";
        }
    }
}

