/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.bitstring;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.bitstring.Bits;
import org.ton.java.utils.Utils;

public class BitString1
implements Bits<Boolean>,
Serializable {
    Deque<Boolean> array;
    private static final int MAX_LENGTH = 1023;
    private final int initialLength;

    public BitString1(BitString1 bs) {
        this.array = new ArrayDeque<Boolean>(bs.array.size());
        for (Boolean b : bs.array) {
            this.writeBit(b);
        }
        this.initialLength = bs.array.isEmpty() ? 1023 : bs.array.size();
    }

    public BitString1(byte[] bytes) {
        this(Utils.signedBytesToUnsigned((byte[])bytes));
    }

    public BitString1(int[] bytes) {
        if (bytes.length == 0) {
            this.array = new ArrayDeque<Boolean>(0);
            this.initialLength = 0;
        } else {
            byte[] bits = Utils.leftPadBytes((byte[])Utils.bytesToBitString((int[])bytes).getBytes(StandardCharsets.UTF_8), (int)(bytes.length * 8), (char)'0');
            this.array = new ArrayDeque<Boolean>(bits.length);
            for (byte bit : bits) {
                if (bit == 49) {
                    this.array.addLast(true);
                    continue;
                }
                if (bit != 48) continue;
                this.array.addLast(false);
            }
            this.initialLength = bits.length;
        }
    }

    public BitString1(byte[] bytes, int size) {
        if (bytes.length == 0) {
            this.array = new ArrayDeque<Boolean>(0);
            this.initialLength = 0;
        } else {
            byte[] bits = Utils.leftPadBytes((byte[])Utils.bytesToBitString((byte[])bytes).getBytes(StandardCharsets.UTF_8), (int)(bytes.length * 8), (char)'0');
            this.array = new ArrayDeque<Boolean>(bits.length);
            for (int i = 0; i < size; ++i) {
                if (bits[i] == 49) {
                    this.array.addLast(true);
                    continue;
                }
                if (bits[i] != 48) continue;
                this.array.addLast(false);
            }
            this.initialLength = bits.length;
        }
    }

    public BitString1(int length) {
        this.array = new ArrayDeque<Boolean>(length);
        this.initialLength = length;
    }

    public BitString1() {
        this.array = new ArrayDeque<Boolean>(1023);
        this.initialLength = 1023;
    }

    @Override
    public int getFreeBits() {
        return this.initialLength - this.array.size();
    }

    @Override
    public int getUsedBits() {
        return this.array.size();
    }

    public int getUsedBytes() {
        return (this.array.size() + 7) / 8;
    }

    public Boolean get() {
        return this.array.peekFirst();
    }

    private void checkRange(int n) {
        if (n > this.getLength()) {
            throw new Error("BitString1 overflow");
        }
    }

    @Override
    public void writeBit(Boolean b) {
        this.array.addLast(b);
    }

    public void writeBits(String b) {
        char[] cArray = b.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            this.array.addLast(c.charValue() == '1');
        }
    }

    @Override
    void writeBit(byte b) {
        this.array.addLast(b > 0);
    }

    public void writeBitArray(Boolean[] ba) {
        for (Boolean b : ba) {
            this.writeBit(b);
        }
    }

    public void writeBitArray(byte[] ba) {
        for (byte b : ba) {
            this.writeBit(b);
        }
    }

    @Override
    public void writeUint(BigInteger number, int bitLength) {
        if (number.compareTo(BigInteger.ZERO) < 0) {
            throw new Error("Unsigned number cannot be less than 0");
        }
        if (bitLength == 0 || number.bitLength() > bitLength) {
            if (number.compareTo(BigInteger.ZERO) == 0) {
                return;
            }
            throw new Error("bitLength is too small for number, got number=" + String.valueOf(number) + ", bitLength=" + bitLength);
        }
        boolean[] bits = new boolean[bitLength];
        for (int i = 0; i < bitLength; ++i) {
            bits[bitLength - 1 - i] = number.testBit(i);
        }
        for (boolean bit : bits) {
            this.writeBit(bit);
        }
    }

    public void writeUint(long number, int bitLength) {
        this.writeUint(BigInteger.valueOf(number), bitLength);
    }

    public void writeInt(BigInteger number, int bitLength) {
        if (bitLength == 1) {
            if (number.compareTo(BigInteger.valueOf(-1L)) == 0) {
                this.writeBit(true);
                return;
            }
            if (number.compareTo(BigInteger.ZERO) == 0) {
                this.writeBit(false);
                return;
            }
            throw new Error("bitLength is too small for number");
        }
        if (number.signum() == -1) {
            this.writeBit(true);
            BigInteger nb = BigInteger.ONE.shiftLeft(bitLength - 1);
            this.writeUint(nb.add(number), bitLength - 1);
        } else {
            this.writeBit(false);
            this.writeUint(number, bitLength - 1);
        }
    }

    public void writeUint8(int ui8) {
        this.writeUint(BigInteger.valueOf(ui8), 8);
    }

    public void writeBytes(byte[] ui8) {
        for (byte b : ui8) {
            this.writeUint8(b & 0xFF);
        }
    }

    public void writeBytes(int[] ui8) {
        for (int b : ui8) {
            this.writeUint8(b);
        }
    }

    public void writeString(String value) {
        this.writeBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public void writeCoins(BigInteger amount) {
        if (amount.signum() == -1) {
            throw new Error("Coins value must be positive.");
        }
        if (amount.compareTo(BigInteger.ZERO) == 0) {
            this.writeUint(BigInteger.ZERO, 4);
        } else {
            int bytesSize = (amount.bitLength() + 7) / 8;
            if (bytesSize > 16) {
                throw new Error("Amount is too big. Maximum amount 2^120-1");
            }
            this.writeUint(BigInteger.valueOf(bytesSize), 4);
            this.writeUint(amount, bytesSize * 8);
        }
    }

    public void writeVarUint(BigInteger value, int bitLength) {
        if (value.compareTo(BigInteger.ZERO) == 0) {
            this.writeUint(BigInteger.ZERO, bitLength);
        } else {
            int bytesSize = (value.bitLength() + 7) / 8;
            if (bytesSize > bitLength) {
                throw new Error("Amount is too big. Should fit in " + bitLength + " bits");
            }
            this.writeUint(BigInteger.valueOf(bytesSize), bitLength);
            this.writeUint(value, bytesSize * 8);
        }
    }

    public void writeAddress(Address address) {
        if (Objects.isNull(address)) {
            this.writeUint(0L, 2);
        } else {
            this.writeUint(2L, 2);
            this.writeUint(0L, 1);
            this.writeInt(BigInteger.valueOf(address.wc), 8);
            this.writeBytes(address.hashPart);
        }
    }

    public void writeBitString1(BitString1 anotherBitString1) {
        Deque<Boolean> bits = anotherBitString1.array;
        for (boolean bit : bits) {
            this.writeBit(bit);
        }
    }

    public Boolean preReadBit() {
        return this.get();
    }

    @Override
    public Boolean readBit() {
        return this.array.pollFirst();
    }

    public BitString1 readBits(int n) {
        BitString1 result = new BitString1(n);
        for (int i = 0; i < n; ++i) {
            result.writeBit(this.readBit());
        }
        return result;
    }

    public BitString1 readBits() {
        int sz = this.array.size();
        BitString1 result = new BitString1(sz);
        for (int i = 0; i < sz; ++i) {
            result.writeBit(this.readBit());
        }
        return result;
    }

    public BigInteger preReadUint(int bitLength) {
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        BitString1 cloned = this.clone();
        int bytesNeeded = (bitLength + 7) / 8;
        byte[] bytes = new byte[bytesNeeded];
        int bitIndex = 0;
        int byteIndex = 0;
        for (int i = 0; i < bitLength; ++i) {
            Boolean bit = cloned.readBit();
            if (bit.booleanValue()) {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | (byte)(1 << 7 - bitIndex));
            }
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
        BigInteger bigInteger = new BigInteger(1, bytes);
        int excessBits = bytesNeeded * 8 - bitLength;
        if (excessBits > 0) {
            bigInteger = bigInteger.shiftRight(excessBits);
        }
        return bigInteger;
    }

    @Override
    public BigInteger readUint(int bitLength) {
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        int bytesNeeded = (bitLength + 7) / 8;
        byte[] bytes = new byte[bytesNeeded];
        int bitIndex = 0;
        int byteIndex = 0;
        for (int i = 0; i < bitLength; ++i) {
            Boolean bit = this.readBit();
            if (bit.booleanValue()) {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | (byte)(1 << 7 - bitIndex));
            }
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
        BigInteger bigInteger = new BigInteger(1, bytes);
        int excessBits = bytesNeeded * 8 - bitLength;
        if (excessBits > 0) {
            bigInteger = bigInteger.shiftRight(excessBits);
        }
        return bigInteger;
    }

    public BigInteger readInt(int bitLength) {
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        Boolean sign = this.readBit();
        if (bitLength == 1) {
            return sign != null && sign != false ? BigInteger.valueOf(-1L) : BigInteger.ZERO;
        }
        BigInteger number = this.readUint(bitLength - 1);
        if (sign.booleanValue()) {
            BigInteger maxValue = BigInteger.ONE.shiftLeft(bitLength - 1);
            number = number.subtract(maxValue);
        }
        return number;
    }

    public BigInteger readUint8() {
        return this.readUint(8);
    }

    public BigInteger readUint16() {
        return this.readUint(16);
    }

    public BigInteger readUint32() {
        return this.readUint(32);
    }

    public BigInteger readUint64() {
        return this.readUint(64);
    }

    public BigInteger readInt8() {
        return this.readInt(8);
    }

    public BigInteger readInt16() {
        return this.readInt(16);
    }

    public BigInteger readInt32() {
        return this.readInt(32);
    }

    public BigInteger readInt64() {
        return this.readInt(64);
    }

    public Address readAddress() {
        BigInteger i = this.preReadUint(2);
        if (i.intValue() == 0) {
            this.readBits(2);
            return null;
        }
        this.readBits(3);
        int workchain = this.readInt(8).intValue();
        BigInteger hashPart = this.readUint(256);
        String address = String.format("%d:%064x", workchain, hashPart);
        return Address.of((String)address);
    }

    public String readString(int length) {
        BitString1 BitString12 = this.readBits(length);
        return new String(BitString12.toByteArray());
    }

    public byte[] readBytes(int length) {
        BitString1 BitString12 = this.readBits(length);
        return BitString12.toByteArray();
    }

    public String toString() {
        return this.toBitString1();
    }

    public String toBitString1() {
        BitString1 cloned = this.clone();
        Deque<Boolean> deque = cloned.array;
        char[] chars = new char[deque.size()];
        int i = 0;
        for (Boolean b : deque) {
            chars[i++] = b != false ? 49 : 48;
        }
        return new String(chars);
    }

    public int getLength() {
        return this.array.size();
    }

    public String getBitString1() {
        char[] chars = new char[this.array.size()];
        int i = 0;
        for (Boolean b : this.array) {
            chars[i++] = b != false ? 49 : 48;
        }
        return new String(chars);
    }

    public int[] toUnsignedByteArray() {
        if (this.array.isEmpty()) {
            return new int[0];
        }
        String bin = this.getBitString1();
        int sz = bin.length();
        int[] result = new int[(sz + 7) / 8];
        for (int i = 0; i < sz; i += 8) {
            String str = bin.substring(i, Math.min(sz, i + 8));
            result[i / 8] = Integer.parseInt(str, 2);
        }
        return result;
    }

    public byte[] toSignedByteArray() {
        if (this.array.isEmpty()) {
            return new byte[0];
        }
        String bin = this.getBitString1();
        int sz = bin.length();
        byte[] result = new byte[(sz + 7) / 8];
        for (int i = 0; i < sz; i += 8) {
            String str = bin.substring(i, Math.min(sz, i + 8));
            result[i / 8] = (byte)(Integer.parseInt(str, 2) & 0xFF);
        }
        return result;
    }

    public List<BigInteger> toByteList() {
        if (this.array.isEmpty()) {
            return new ArrayList<BigInteger>();
        }
        String bin = this.getBitString1();
        int sz = bin.length();
        ArrayList<BigInteger> result = new ArrayList<BigInteger>((sz + 7) / 8);
        for (int i = 0; i < sz; i += 8) {
            String str = bin.substring(i, Math.min(sz, i + 8));
            result.add(new BigInteger(str, 2));
        }
        return result;
    }

    public byte[] toByteArray() {
        if (this.array.isEmpty()) {
            return new byte[0];
        }
        byte[] bin = this.getBitString1().getBytes(StandardCharsets.UTF_8);
        int sz = bin.length;
        byte[] result = new byte[(sz + 7) / 8];
        for (int i = 0; i < sz; ++i) {
            if (bin[i] == 49) {
                int n = i / 8;
                result[n] = (byte)(result[n] | (byte)(1 << 7 - i % 8));
                continue;
            }
            int n = i / 8;
            result[n] = (byte)(result[n] & (byte)(~(1 << 7 - i % 8)));
        }
        return result;
    }

    public int[] toUintArray() {
        if (this.array.isEmpty()) {
            return new int[0];
        }
        byte[] bin = this.getBitString1().getBytes(StandardCharsets.UTF_8);
        int sz = bin.length;
        int[] result = new int[(sz + 7) / 8];
        for (int i = 0; i < sz; ++i) {
            if (bin[i] == 49) {
                int n = i / 8;
                result[n] = result[n] | 1 << 7 - i % 8;
                continue;
            }
            int n = i / 8;
            result[n] = result[n] & ~(1 << 7 - i % 8);
        }
        return result;
    }

    public Boolean[] toBooleanArray() {
        Boolean[] result = new Boolean[this.getLength()];
        int i = 0;
        for (Boolean b : this.array) {
            result[i++] = b;
        }
        return result;
    }

    public BitString1 clone() {
        return new BitString1(this);
    }

    public BitString1 cloneFrom(int from) {
        BitString1 cloned = this.clone();
        for (int i = 0; i < from; ++i) {
            cloned.readBit();
        }
        return cloned;
    }

    @Override
    public String toHex() {
        if (this.array.size() % 4 == 0) {
            byte[] arr = this.toByteArray();
            String s = Utils.bytesToHex((byte[])arr).toUpperCase();
            if (this.array.size() % 8 == 0) {
                return s;
            }
            return s.substring(0, s.length() - 1);
        }
        BitString1 temp = this.clone();
        temp.writeBit(true);
        while (temp.array.size() % 4 != 0) {
            temp.writeBit(false);
        }
        return temp.toHex().toUpperCase() + "_";
    }
}

