/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.bitstring;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.ton.java.address.Address;
import org.ton.java.utils.Utils;

public class BitString
implements Serializable {
    private static final Logger log = Logger.getLogger(BitString.class.getName());
    byte[] array;
    public int writeCursor;
    public int readCursor;
    public int length;

    public BitString() {
        this.array = new byte[1023];
        this.writeCursor = 0;
        this.readCursor = 0;
        this.length = 8184;
    }

    public BitString(BitString bs) {
        for (int i = bs.readCursor; i < bs.writeCursor; ++i) {
            this.writeBit(bs.get(i));
        }
    }

    public BitString(int length) {
        this.array = new byte[(int)Math.ceil((double)length / 8.0)];
        this.writeCursor = 0;
        this.readCursor = 0;
        this.length = length;
    }

    public BitString(byte[] bytes) {
        this(Utils.signedBytesToUnsigned((byte[])bytes));
    }

    public BitString(byte[] bytes, int size) {
        if (bytes.length == 0) {
            this.array = new byte[0];
            this.writeCursor = 0;
            this.readCursor = 0;
            this.length = 0;
        } else {
            byte[] bits = Utils.leftPadBytes((byte[])Utils.bytesToBitString((byte[])bytes).getBytes(StandardCharsets.UTF_8), (int)(bytes.length * 8), (char)'0');
            this.length = size;
            this.array = new byte[(int)Math.ceil((double)this.length / 8.0)];
            this.writeCursor = 0;
            this.readCursor = 0;
            for (int i = 0; i < size && i < bits.length; ++i) {
                if (bits[i] == 49) {
                    this.writeBit(true);
                    continue;
                }
                if (bits[i] != 48) continue;
                this.writeBit(false);
            }
        }
    }

    public BitString(int[] bytes) {
        if (bytes.length == 0) {
            this.array = new byte[0];
            this.writeCursor = 0;
            this.readCursor = 0;
            this.length = 0;
        } else {
            byte[] bits = Utils.leftPadBytes((byte[])Utils.bytesToBitString((int[])bytes).getBytes(StandardCharsets.UTF_8), (int)(bytes.length * 8), (char)'0');
            this.length = bits.length;
            this.array = new byte[(int)Math.ceil((double)this.length / 8.0)];
            this.writeCursor = 0;
            this.readCursor = 0;
            for (byte bit : bits) {
                if (bit == 49) {
                    this.writeBit(true);
                    continue;
                }
                if (bit != 48) continue;
                this.writeBit(false);
            }
        }
    }

    public int getFreeBits() {
        return this.length - this.writeCursor;
    }

    public int getUsedBits() {
        return this.writeCursor - this.readCursor;
    }

    public int getUsedBytes() {
        return (int)Math.ceil((double)this.writeCursor / 8.0);
    }

    public Boolean get(int n) {
        this.checkRange(n);
        return (this.array[n / 8] & 1 << 7 - n % 8) > 0;
    }

    private void checkRange(int n) {
        if (n > this.length) {
            throw new Error("RealBitString overflow. n[" + n + "] >= length[" + this.length + "]");
        }
    }

    void on(int n) {
        try {
            int n2 = n / 8;
            this.array[n2] = (byte)(this.array[n2] | (byte)(1 << 7 - n % 8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void off(int n) {
        try {
            int n2 = n / 8;
            this.array[n2] = (byte)(this.array[n2] & (byte)(~(1 << 7 - n % 8)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void toggle(int n) {
        try {
            int n2 = n / 8;
            this.array[n2] = (byte)(this.array[n2] ^ (byte)(1 << 7 - n % 8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBit(Boolean b) {
        if (b.booleanValue()) {
            this.on(this.writeCursor);
        } else {
            this.off(this.writeCursor);
        }
        ++this.writeCursor;
    }

    void writeBit(byte b) {
        if (b > 0) {
            this.on(this.writeCursor);
        } else {
            this.off(this.writeCursor);
        }
        ++this.writeCursor;
    }

    public void writeBitArray(Boolean[] ba) {
        for (Boolean b : ba) {
            this.writeBit(b);
        }
    }

    public void writeBitArray(boolean[] ba) {
        for (boolean b : ba) {
            this.writeBit(b);
        }
    }

    public void writeBitArray(byte[] ba) {
        for (byte b : ba) {
            this.writeBit(b);
        }
    }

    public void writeBits(String b) {
        char[] cArray = b.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            this.writeBit(c.charValue() == '1');
        }
    }

    public void writeUint(BigInteger number, int bitLength) {
        if (number.compareTo(BigInteger.ZERO) < 0) {
            throw new Error("Unsigned number cannot be less than 0");
        }
        if (bitLength == 0 || number.bitLength() > bitLength) {
            if (number.compareTo(BigInteger.ZERO) == 0) {
                return;
            }
            throw new Error("bitLength is too small for number, got number=" + String.valueOf(number) + ", bitLength=" + bitLength);
        }
        Object s = number.toString(2);
        if (((String)s).length() != bitLength) {
            s = this.repeatZeros(bitLength - ((String)s).length()) + (String)s;
        }
        for (int i = 0; i < bitLength; ++i) {
            this.writeBit(((String)s).charAt(i) == '1');
        }
    }

    public String repeatZeros(int count) {
        char[] zeros = new char[count];
        Arrays.fill(zeros, '0');
        return new String(zeros);
    }

    public void writeUint(long number, int bitLength) {
        this.writeUint(BigInteger.valueOf(number), bitLength);
    }

    public void writeInt(BigInteger number, int bitLength) {
        if (bitLength == 1) {
            if (number.compareTo(BigInteger.valueOf(-1L)) == 0) {
                this.writeBit(true);
                return;
            }
            if (number.compareTo(BigInteger.ZERO) == 0) {
                this.writeBit(false);
                return;
            }
            throw new Error("bitLength is too small for number");
        }
        if (number.signum() == -1) {
            this.writeBit(true);
            BigInteger b = BigInteger.valueOf(2L);
            BigInteger nb = b.pow(bitLength - 1);
            this.writeUint(nb.add(number), bitLength - 1);
        } else {
            this.writeBit(false);
            this.writeUint(number, bitLength - 1);
        }
    }

    public void writeUint8(int ui8) {
        this.writeUint(BigInteger.valueOf(ui8), 8);
    }

    public void writeBytes(byte[] ui8) {
        for (byte b : ui8) {
            this.writeUint8(b & 0xFF);
        }
    }

    public void writeBytes(int[] ui8) {
        for (int b : ui8) {
            this.writeUint8(b);
        }
    }

    public void writeString(String value) {
        this.writeBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public void writeCoins(BigInteger amount) {
        if (amount.signum() == -1) {
            throw new Error("Coins value must be positive.");
        }
        if (amount.compareTo(BigInteger.ZERO) == 0) {
            this.writeUint(BigInteger.ZERO, 4);
        } else {
            int bytesSize = (int)Math.ceil((double)amount.bitLength() / 8.0);
            if (bytesSize >= 16) {
                throw new Error("Amount is too big. Maximum amount 2^120-1");
            }
            this.writeUint(BigInteger.valueOf(bytesSize), 4);
            this.writeUint(amount, bytesSize * 8);
        }
    }

    public void writeVarUint(BigInteger value, int bitLength) {
        if (value.compareTo(BigInteger.ZERO) == 0) {
            this.writeUint(BigInteger.ZERO, bitLength);
        } else {
            int bytesSize = (value.bitLength() + 7) / 8;
            if (bytesSize > bitLength) {
                throw new Error("Amount is too big. Should fit in " + bitLength + " bits");
            }
            this.writeUint(BigInteger.valueOf(bytesSize), bitLength);
            this.writeUint(value, bytesSize * 8);
        }
    }

    public void writeAddress(Address address) {
        if (Objects.isNull(address)) {
            this.writeUint(0L, 2);
        } else {
            this.writeUint(2L, 2);
            this.writeUint(0L, 1);
            this.writeInt(BigInteger.valueOf(address.wc), 8);
            this.writeBytes(address.hashPart);
        }
    }

    public void writeBitString(BitString anotherBitString) {
        for (int i = anotherBitString.readCursor; i < anotherBitString.writeCursor; ++i) {
            this.writeBit(anotherBitString.get(i));
        }
    }

    public boolean prereadBit() {
        return this.get(this.readCursor);
    }

    public Boolean readBit() {
        Boolean result = this.get(this.readCursor);
        ++this.readCursor;
        return result;
    }

    public BitString preReadBits(int n) {
        int oldReadCursor = this.readCursor;
        BitString result = new BitString(n);
        for (int i = 0; i < n; ++i) {
            result.writeBit(this.readBit());
        }
        this.readCursor = oldReadCursor;
        return result;
    }

    public BitString readBits(int n) {
        BitString result = new BitString(n);
        for (int i = 0; i < n; ++i) {
            result.writeBit(this.readBit());
        }
        return result;
    }

    public BitString readBits() {
        BitString result = new BitString();
        for (int i = 0; i < this.writeCursor; ++i) {
            result.writeBit(this.readBit());
        }
        return result;
    }

    public BigInteger preReadUint(int bitLength) {
        int oldReadCursor = this.readCursor;
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitLength; ++i) {
            boolean b = this.readBit();
            if (b) {
                s.append("1");
                continue;
            }
            s.append("0");
        }
        this.readCursor = oldReadCursor;
        return new BigInteger(s.toString(), 2);
    }

    public BigInteger readUint(int bitLength) {
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitLength; ++i) {
            boolean b = this.readBit();
            if (b) {
                s.append("1");
                continue;
            }
            s.append("0");
        }
        return new BigInteger(s.toString(), 2);
    }

    public BigInteger readInt(int bitLength) {
        if (bitLength < 1) {
            throw new Error("Incorrect bitLength");
        }
        boolean sign = this.readBit();
        if (bitLength == 1) {
            return sign ? new BigInteger("-1") : BigInteger.ZERO;
        }
        BigInteger number = this.readUint(bitLength - 1);
        if (sign) {
            BigInteger b = BigInteger.valueOf(2L);
            BigInteger nb = b.pow(bitLength - 1);
            number = number.subtract(nb);
        }
        return number;
    }

    public BigInteger readUint8() {
        return this.readUint(8);
    }

    public BigInteger readUint16() {
        return this.readUint(16);
    }

    public BigInteger readUint32() {
        return this.readUint(32);
    }

    public BigInteger readUint64() {
        return this.readUint(64);
    }

    public BigInteger readInt8() {
        return this.readInt(8);
    }

    public BigInteger readInt16() {
        return this.readInt(16);
    }

    public BigInteger readInt32() {
        return this.readInt(32);
    }

    public BigInteger readInt64() {
        return this.readInt(64);
    }

    public Address readAddress() {
        BigInteger i = this.preReadUint(2);
        if (i.intValue() == 0) {
            this.readBits(2);
            return null;
        }
        this.readBits(2);
        this.readBits(1);
        int workchain = this.readInt(8).intValue();
        BigInteger hashPart = this.readUint(256);
        String address = workchain + ":" + String.format("%64s", hashPart.toString(16)).replace(' ', '0');
        return Address.of((String)address);
    }

    public String readString(int length) {
        BitString BitString2 = this.readBits(length);
        return new String(BitString2.toByteArray());
    }

    public byte[] readBytes(int length) {
        BitString BitString2 = this.readBits(length);
        return BitString2.toByteArray();
    }

    public String toString() {
        return this.toBitString();
    }

    public String toBitString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.writeCursor; ++i) {
            char bit = this.get(i) != false ? (char)'1' : '0';
            s.append(bit);
        }
        return s.toString();
    }

    public Boolean[] toBooleanArray() {
        Boolean[] result = new Boolean[this.getLength()];
        int j = 0;
        for (int i = 0; i < this.writeCursor; ++i) {
            result[j++] = this.get(i);
        }
        return result;
    }

    public int getLength() {
        return this.array.length * 8;
    }

    public String getBitString() {
        StringBuilder s = new StringBuilder();
        for (int i = this.readCursor; i < this.writeCursor; ++i) {
            char bit = this.get(i) != false ? (char)'1' : '0';
            s.append(bit);
        }
        return s.toString();
    }

    public byte[] toByteArray() {
        if (this.writeCursor == 0) {
            return new byte[0];
        }
        int sz = this.writeCursor;
        byte[] result = new byte[(sz + 7) / 8];
        for (int i = 0; i < sz; i += 8) {
            int value = 0;
            for (int j = 0; j < 8 && i + j < sz; ++j) {
                if (!this.get(i + j).booleanValue()) continue;
                value |= 1 << 7 - j;
            }
            result[i / 8] = (byte)(value & 0xFF);
        }
        return result;
    }

    public int[] toUnsignedByteArray() {
        if (this.writeCursor == 0) {
            return new int[0];
        }
        int sz = this.writeCursor;
        int[] result = new int[(sz + 7) / 8];
        for (int i = 0; i < sz; i += 8) {
            int value = 0;
            for (int j = 0; j < 8 && i + j < sz; ++j) {
                if (!this.get(i + j).booleanValue()) continue;
                value |= 1 << 7 - j;
            }
            result[i / 8] = value;
        }
        return result;
    }

    public byte[] toSignedByteArray() {
        if (this.writeCursor == 0) {
            return new byte[0];
        }
        int sz = this.writeCursor;
        byte[] result = new byte[(sz + 7) / 8];
        for (int i = 0; i < sz; i += 8) {
            int value = 0;
            for (int j = 0; j < 8 && i + j < sz; ++j) {
                if (!this.get(i + j).booleanValue()) continue;
                value |= 1 << 7 - j;
            }
            result[i / 8] = (byte)(value & 0xFF);
        }
        return result;
    }

    public List<BigInteger> toByteList() {
        if (this.writeCursor == 0) {
            return new ArrayList<BigInteger>();
        }
        int sz = this.writeCursor;
        ArrayList<BigInteger> result = new ArrayList<BigInteger>((sz + 7) / 8);
        for (int i = 0; i < sz; i += 8) {
            StringBuilder binStr = new StringBuilder();
            for (int j = 0; j < 8 && i + j < sz; ++j) {
                binStr.append(this.get(i + j) != false ? (char)'1' : '0');
            }
            result.add(new BigInteger(binStr.toString(), 2));
        }
        return result;
    }

    public boolean[] toBitArray() {
        boolean[] result = new boolean[this.writeCursor];
        for (int i = this.readCursor; i < this.writeCursor; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public int[] toZeroOneArray() {
        int[] result = new int[this.writeCursor];
        for (int i = this.readCursor; i < this.writeCursor; ++i) {
            result[i] = this.get(i) != false ? 1 : 0;
        }
        return result;
    }

    public BitString clone() {
        BitString result = new BitString(0);
        result.array = Arrays.copyOfRange(this.array, 0, this.array.length);
        result.length = this.length;
        result.writeCursor = this.writeCursor;
        result.readCursor = this.readCursor;
        return result;
    }

    public BitString cloneFrom(int from) {
        BitString result = new BitString(0);
        result.array = Arrays.copyOfRange(this.array, from, this.array.length);
        result.length = this.length;
        result.writeCursor = this.writeCursor - from * 8;
        result.readCursor = this.readCursor;
        return result;
    }

    public BitString cloneClear() {
        BitString result = new BitString(0);
        result.array = Arrays.copyOfRange(this.array, 0, this.array.length);
        result.length = this.length;
        result.writeCursor = 0;
        result.readCursor = 0;
        return result;
    }

    public String toHex() {
        if (this.writeCursor % 4 == 0) {
            byte[] arr = Arrays.copyOfRange(this.array, 0, (int)Math.ceil((double)this.writeCursor / 8.0));
            String s = Utils.bytesToHex((byte[])arr).toUpperCase();
            if (this.writeCursor % 8 == 0) {
                return s;
            }
            return s.substring(0, s.length() - 1);
        }
        BitString temp = this.clone();
        temp.writeBit(true);
        while (temp.writeCursor % 4 != 0) {
            temp.writeBit(false);
        }
        return temp.toHex().toUpperCase() + "_";
    }
}

