/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FieldError {
    private final String fieldName;
    private final List<String> messages = new ArrayList<String>();

    FieldError(String fieldName) {
        this.fieldName = fieldName;
    }

    public void append(String message) {
        this.messages.add(message);
    }

    public void append(List<String> messages) {
        this.messages.addAll(messages);
    }

    private String getPrefix(boolean newLine) {
        if (this.fieldName == null) {
            return "";
        }
        return String.format("'%s':", this.fieldName) + (newLine ? "\n" : " ");
    }

    public String toInlineMessage() {
        return this.getPrefix(false) + String.join((CharSequence)", ", this.messages);
    }

    public String toMessage() {
        String suffix = this.messages.stream().map(s -> String.format("- %s", s)).collect(Collectors.joining("\n"));
        return this.getPrefix(true) + suffix;
    }

    public String toString() {
        return this.toMessage();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

