/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Predicate;

public class Constraint {
    private final String name;
    private final String message;
    private Predicate<?> condition;

    public Constraint(String name, Predicate<?> condition, String message) {
        this.name = name;
        this.condition = condition;
        this.message = message;
    }

    public Constraint nullable() {
        this.condition = this.condition.or(Objects::isNull);
        return this;
    }

    public Constraint withMessage(String message) {
        Objects.requireNonNull(message, "Validation message must not be null.");
        return new Constraint(this.name, this.condition, message);
    }

    public boolean ok(Object value) {
        return this.condition.test(value);
    }

    public boolean notOk(Object value) {
        return !this.condition.test(value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constraint) {
            return this.name.equals(((Constraint)obj).name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public Predicate<?> getCondition() {
        return this.condition;
    }

    public static class Set
    extends LinkedHashSet<Constraint> {
        @Override
        public boolean add(Constraint item) {
            boolean wasThere = this.removeIf(i -> i.equals(item));
            super.add(item);
            return !wasThere;
        }
    }
}

