/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectUtil {
    private static final Logger log = LogManager.getLogger(ReflectUtil.class);
    private static final Map<String, Map<String, PropertyDescriptor>> CACHED_SCHEME = new HashMap<String, Map<String, PropertyDescriptor>>();

    private ReflectUtil() {
    }

    public static <T> PropertyDescriptor getField(String fieldName, Class<T> tClass) {
        String className = tClass.getCanonicalName();
        if (CACHED_SCHEME.containsKey(className)) {
            return CACHED_SCHEME.get(className).get(fieldName);
        }
        Map<String, PropertyDescriptor> map = ReflectUtil.prepareScheme(tClass);
        return map.get(fieldName);
    }

    private static synchronized <T> Map<String, PropertyDescriptor> prepareScheme(Class<T> tClass) {
        String className = tClass.getCanonicalName();
        if (CACHED_SCHEME.get(className) != null) {
            return CACHED_SCHEME.get(className);
        }
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] pds;
            for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(tClass).getPropertyDescriptors()) {
                if (Objects.equals(pd.getName(), "class")) continue;
                map.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException e) {
            log.error("Could not initialize property descriptor map.", (Throwable)e);
        }
        CACHED_SCHEME.put(className, map);
        return map;
    }

    public static <T> void mergeObject(T source, T extra) {
        Class<?> tClass = source.getClass();
        Map<String, PropertyDescriptor> map = ReflectUtil.prepareScheme(tClass);
        map.forEach((fieldName, pd) -> {
            try {
                Object value = pd.getReadMethod().invoke(extra, new Object[0]);
                if (value == null) {
                    return;
                }
                pd.getWriteMethod().invoke(source, value);
            }
            catch (Exception e) {
                log.error("Merge object error.", (Throwable)e);
            }
        });
    }

    public static <T> T mergeClone(T source, T extra) {
        Class<?> tClass = source.getClass();
        Object clone = tClass.newInstance();
        ReflectUtil.mergeObject(clone, source);
        ReflectUtil.mergeObject(clone, extra);
        return (T)clone;
    }

    public static <O, I> O safeApply(Function<I, O> func, I input) {
        if (func == null) {
            return null;
        }
        try {
            return func.apply(input);
        }
        catch (Exception e) {
            log.error("Error when applying function.", (Throwable)e);
            return null;
        }
    }

    public static <T, R> Function<T, R> safeWrap(Function<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                log.error("Error while applying function.", (Throwable)e);
                return null;
            }
        };
    }

    public static <T, U> BiConsumer<T, U> safeWrap(BiConsumer<T, U> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception e) {
                log.error("Error while applying BiConsumer.", (Throwable)e);
            }
        };
    }
}

