/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.DataTemplate;
import io.github.nambach.excelutil.core.Editor;
import io.github.nambach.excelutil.core.Template;
import io.github.nambach.excelutil.core.WriterCell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.function.UnaryOperator;

public class SequentialWriter
implements AutoCloseable {
    private final Editor editor;

    public SequentialWriter() {
        this.editor = new Editor();
    }

    public SequentialWriter(InputStream stream) {
        this.editor = new Editor(stream);
    }

    public void createNewSheet(String sheetName) {
        this.editor.goToSheet(sheetName);
    }

    public <T> void writeData(DataTemplate<T> template, Collection<T> data) {
        this.editor.writeData(template, data).enter();
    }

    public void writeTemplate(Template template) {
        this.editor.writeTemplate(template).enter();
    }

    public void writeLine(int indent, UnaryOperator<WriterCell> detail) {
        ((Editor)this.editor.next(indent).writeCell((UnaryOperator)detail)).enter();
    }

    public void skipLines(int lines) {
        this.editor.enter(lines);
    }

    public void freeze(int rows, int cols) {
        this.editor.configSheet(cf -> cf.freeze(rows, cols));
    }

    public ByteArrayInputStream exportToFile() {
        return this.editor.exportToFile();
    }

    @Override
    public void close() {
        this.editor.close();
    }
}

