/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.validator.ObjectError;
import java.util.List;

public class RowError {
    private final int index;
    private String customError;
    private ObjectError objectError;

    public RowError(int index, Class<?> clazz) {
        this.index = index;
        if (clazz != null) {
            this.objectError = new ObjectError(clazz);
        }
    }

    void appendError(String field, List<String> messages) {
        this.objectError.appendError(field, messages);
    }

    public int getExcelIndex() {
        return this.index + 1;
    }

    public String getRowString() {
        return "Row " + (this.index + 1);
    }

    public String getMessage() {
        if (this.customError != null) {
            return this.customError;
        }
        if (this.objectError != null) {
            return this.objectError.getMessage();
        }
        return "";
    }

    public String getInlineMessage() {
        if (this.customError != null) {
            return this.customError;
        }
        if (this.objectError != null) {
            return this.objectError.getInlineMessage();
        }
        return "";
    }

    public String toString() {
        return this.getRowString() + ": " + this.getInlineMessage();
    }

    public int getIndex() {
        return this.index;
    }

    public String getCustomError() {
        return this.customError;
    }

    public ObjectError getObjectError() {
        return this.objectError;
    }

    public void setCustomError(String customError) {
        this.customError = customError;
    }

    public void setObjectError(ObjectError objectError) {
        this.objectError = objectError;
    }
}

