/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.ReaderConfig;
import io.github.nambach.excelutil.core.ReaderController;
import io.github.nambach.excelutil.core.Result;
import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.util.TextUtil;
import io.github.nambach.excelutil.validator.builtin.DecimalValidator;
import io.github.nambach.excelutil.validator.builtin.IntegerValidator;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class ReaderCell
extends ReaderController {
    private static final Logger log = LogManager.getLogger(ReaderCell.class);
    private final Cell cell;
    private final String columnTitle;
    private FormulaEvaluator evaluator;

    ReaderCell(Cell cell, String columnTitle, ReaderConfig<?> config, Result<?> result) {
        super(config, result);
        this.cell = cell;
        this.columnTitle = columnTitle;
    }

    public static ReaderCell wrap(Cell cell) {
        return new ReaderCell(cell, null, null, null);
    }

    private FormulaEvaluator getFormulaEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            return this.evaluator;
        }
        return this.evaluator;
    }

    public Cell getPoiCell() {
        return this.cell;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public int getColumnIndex() {
        return this.cell.getColumnIndex();
    }

    public int getRowIndex() {
        return this.cell.getRowIndex();
    }

    public String getAddress() {
        return this.cell.getAddress().formatAsString();
    }

    private Double tryParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            log.error("Cannot parse string to double.", (Throwable)e);
            return null;
        }
    }

    private Boolean tryParseBoolean(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            log.error("Cannot parse string to boolean.", (Throwable)e);
            return null;
        }
    }

    public String readString() {
        CellType cellType = this.cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getFormulaEvaluator().evaluateFormulaCell(this.cell);
        }
        switch (cellType) {
            case STRING: {
                return this.cell.getStringCellValue();
            }
            case NUMERIC: 
            case BOOLEAN: {
                DataFormatter formatter = new DataFormatter();
                return formatter.formatCellValue(this.cell);
            }
        }
        return null;
    }

    public Date readDate() {
        if (this.cell.getCellType() == CellType.NUMERIC) {
            return this.cell.getDateCellValue();
        }
        return null;
    }

    public LocalDateTime readLocalDateTime() {
        if (this.cell.getCellType() == CellType.NUMERIC) {
            return this.cell.getLocalDateTimeCellValue();
        }
        return null;
    }

    public Double readDouble() {
        CellType cellType = this.cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getFormulaEvaluator().evaluateFormulaCell(this.cell);
        }
        switch (cellType) {
            case STRING: {
                return this.tryParseDouble(this.cell.getStringCellValue());
            }
            case NUMERIC: {
                return this.cell.getNumericCellValue();
            }
            case BOOLEAN: {
                return this.cell.getBooleanCellValue() ? 1 : 0;
            }
        }
        return null;
    }

    public Float readFloat() {
        Double d = this.readDouble();
        return d == null ? null : Float.valueOf(d.floatValue());
    }

    public Long readLong() {
        Double d = this.readDouble();
        return d == null ? null : Long.valueOf(d.longValue());
    }

    public Integer readInt() {
        Double d = this.readDouble();
        return d == null ? null : Integer.valueOf(d.intValue());
    }

    public Boolean readBoolean() {
        CellType cellType = this.cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getFormulaEvaluator().evaluateFormulaCell(this.cell);
        }
        switch (cellType) {
            case STRING: {
                return this.tryParseBoolean(this.cell.getStringCellValue());
            }
            case NUMERIC: {
                return this.cell.getNumericCellValue() != 0.0;
            }
            case BOOLEAN: {
                return this.cell.getBooleanCellValue();
            }
        }
        return null;
    }

    @Override
    public void setError(String message) {
        this.result.newRowError(this.getRowIndex()).setCustomError(message);
    }

    @Override
    public void throwError(String message) {
        this.setError(message);
        super.terminateNow();
    }

    void validate(TypeValidator typeValidator, String fieldName) {
        if (typeValidator == null) {
            return;
        }
        Object val = this.readString();
        if (typeValidator instanceof DecimalValidator) {
            val = this.tryReadDouble();
        } else if (typeValidator instanceof IntegerValidator) {
            val = this.tryReadLong();
        }
        List<String> errors = typeValidator.test(val);
        if (ListUtil.hasMember(errors)) {
            String field = TextUtil.getNotNull(fieldName, this.columnTitle, "Column " + (this.getColumnIndex() + 1));
            this.result.newRowError(this.getRowIndex()).appendError(field, errors);
            if (this.isEarlyExit()) {
                super.terminateNow();
            }
        }
    }

    private Object tryReadDouble() {
        CellType cellType = this.cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getFormulaEvaluator().evaluateFormulaCell(this.cell);
        }
        switch (cellType) {
            case STRING: {
                String strVal = this.cell.getStringCellValue();
                try {
                    return Double.parseDouble(strVal);
                }
                catch (Exception e) {
                    return strVal;
                }
            }
            case NUMERIC: {
                return this.cell.getNumericCellValue();
            }
        }
        return null;
    }

    private Object tryReadLong() {
        CellType cellType = this.cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getFormulaEvaluator().evaluateFormulaCell(this.cell);
        }
        switch (cellType) {
            case STRING: {
                String strVal = this.cell.getStringCellValue();
                try {
                    return Long.parseLong(strVal);
                }
                catch (Exception e) {
                    return strVal;
                }
            }
            case NUMERIC: {
                double val = this.cell.getNumericCellValue();
                if (val % 1.0 == 0.0) {
                    return (long)val;
                }
                return val;
            }
        }
        return null;
    }
}

