/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.Handler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

class HandlerMap<T> {
    private final Handlers<T> empty = new Handlers();
    private final Map<Integer, Handlers<T>> indexAtMap = new HashMap<Integer, Handlers<T>>();
    private final Map<Integer, Handlers<T>> indexFromMap = new HashMap<Integer, Handlers<T>>();
    private final Map<String, Handlers<T>> titleMap = new HashMap<String, Handlers<T>>();

    HandlerMap() {
    }

    private static <T> void shiftIndexMap(int indexOffset, Map<Integer, Handlers<T>> target) {
        HashMap temp = new HashMap();
        target.forEach((i, handler) -> temp.put(i + indexOffset, handler));
        target.clear();
        target.putAll(temp);
    }

    private Handlers<T> getIndexFrom(int colIndex) {
        Handlers<T> rs = new Handlers<T>();
        for (int i = 0; i <= colIndex; ++i) {
            rs.concat(this.indexFromMap.getOrDefault(i, this.empty));
        }
        return rs;
    }

    public Handlers<T> get(int colIndex, String colTitle) {
        Handlers<T> indexHandlers = this.indexAtMap.getOrDefault(colIndex, this.empty);
        Handlers<T> indexFromHandlers = this.getIndexFrom(colIndex);
        Handlers<T> titleHandlers = this.titleMap.getOrDefault(colTitle, this.empty);
        return new Handlers<T>().concat(indexHandlers).concat(indexFromHandlers).concat(titleHandlers);
    }

    public void putAt(int index, Handler<T> handler) {
        this.indexAtMap.putIfAbsent(index, new Handlers());
        this.indexAtMap.get(index).add(handler);
    }

    public void putFrom(int index, Handler<T> handler) {
        this.indexFromMap.putIfAbsent(index, new Handlers());
        this.indexFromMap.get(index).add(handler);
    }

    public void put(String title, Handler<T> handler) {
        this.titleMap.putIfAbsent(title, new Handlers());
        this.titleMap.get(title).add(handler);
    }

    public HandlerMap<T> makeCopy() {
        HandlerMap<T> clone = new HandlerMap<T>();
        clone.indexAtMap.putAll(this.indexAtMap);
        clone.indexFromMap.putAll(this.indexFromMap);
        clone.titleMap.putAll(this.titleMap);
        return clone;
    }

    public void shiftIndexMap(int indexOffset) {
        HandlerMap.shiftIndexMap(indexOffset, this.indexAtMap);
        HandlerMap.shiftIndexMap(indexOffset, this.indexFromMap);
    }

    public int getMinIndex() {
        Integer min1 = this.indexAtMap.keySet().stream().reduce(Math::min).orElse(null);
        Integer min2 = this.indexFromMap.keySet().stream().reduce(Math::min).orElse(null);
        return Stream.of(min1, min2).filter(Objects::nonNull).reduce(Math::min).orElse(0);
    }

    static class Handlers<T>
    extends ArrayList<Handler<T>> {
        Handlers() {
        }

        public Handlers<T> concat(Handlers<T> c) {
            super.addAll(c);
            return this;
        }
    }
}

