/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.sttp;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpClientInstrumentation$;
import kamon.instrumentation.http.HttpMessage;
import kamon.instrumentation.sttp.RequestReader;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.util.CallingThreadExecutionContext$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client3.RequestBody;
import sttp.client3.RequestOptions;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.ResponseAs;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.Uri;

public final class SttpClientInstrumentation$ {
    public static SttpClientInstrumentation$ MODULE$;
    private volatile HttpClientInstrumentation httpClientInstrumentation;

    static {
        new SttpClientInstrumentation$();
    }

    public HttpClientInstrumentation httpClientInstrumentation() {
        return this.httpClientInstrumentation;
    }

    public void httpClientInstrumentation_$eq(HttpClientInstrumentation x$1) {
        this.httpClientInstrumentation = x$1;
    }

    public HttpClientInstrumentation rebuildHttpClientInstrumentation() {
        Config httpClientConfig = Kamon$.MODULE$.config().getConfig("kamon.instrumentation.sttp.client3");
        this.httpClientInstrumentation_$eq(HttpClientInstrumentation$.MODULE$.from(httpClientConfig, "sttp.client3"));
        return this.httpClientInstrumentation();
    }

    public <T, R> HttpClientInstrumentation.RequestHandler<RequestT<Object, T, R>> getHandler(RequestT<Object, T, R> request) {
        return this.httpClientInstrumentation().createHandler(this.toRequestBuilder(request), Kamon$.MODULE$.currentContext());
    }

    public <T, R> HttpClientInstrumentation.RequestHandler<RequestT<Object, T, R>> getHandler(RequestT<Object, T, R> request, Span span) {
        return this.httpClientInstrumentation().createHandler(this.toRequestBuilder(request), Kamon$.MODULE$.currentContext().withEntry(Span$.MODULE$.Key(), (Object)span));
    }

    public <T> HttpMessage.Response toResponseBuilder(Response<T> response) {
        return new HttpMessage.Response(response){
            private final Response response$1;

            public int statusCode() {
                return this.response$1.code();
            }
            {
                this.response$1 = response$1;
            }
        };
    }

    public <T, R> HttpMessage.RequestBuilder<RequestT<Object, T, R>> toRequestBuilder(RequestT<Object, T, R> httpRequest) {
        return new RequestReader<T, R>(httpRequest){
            private List<Header> _extraHeaders;
            private final RequestT<Object, T, R> request;

            public String url() {
                return RequestReader.url$(this);
            }

            public String path() {
                return RequestReader.path$(this);
            }

            public String method() {
                return RequestReader.method$(this);
            }

            public String host() {
                return RequestReader.host$(this);
            }

            public int port() {
                return RequestReader.port$(this);
            }

            public Option<String> read(String header) {
                return RequestReader.read$(this, header);
            }

            public Map<String, String> readAll() {
                return RequestReader.readAll$(this);
            }

            private List<Header> _extraHeaders() {
                return this._extraHeaders;
            }

            private void _extraHeaders_$eq(List<Header> x$1) {
                this._extraHeaders = x$1;
            }

            public RequestT<Object, T, R> request() {
                return this.request;
            }

            public void write(String header, String value) {
                Header header2 = Header$.MODULE$.apply(header, value);
                this._extraHeaders_$eq((List<Header>)this._extraHeaders().$colon$colon((Object)header2));
            }

            public RequestT<Object, T, R> build() {
                Seq x$1 = (Seq)this.request().headers().$plus$plus(this._extraHeaders(), Seq$.MODULE$.canBuildFrom());
                String x$2 = ((Method)this.request().copy$default$1()).method();
                Uri x$3 = (Uri)this.request().copy$default$2();
                RequestBody x$4 = this.request().copy$default$3();
                ResponseAs x$5 = this.request().copy$default$5();
                RequestOptions x$6 = this.request().copy$default$6();
                Map x$7 = this.request().copy$default$7();
                return this.request().copy((Object)new Method(x$2), (Object)x$3, x$4, x$1, x$5, x$6, x$7);
            }
            {
                RequestReader.$init$(this);
                this._extraHeaders = List$.MODULE$.empty();
                this.request = httpRequest$1;
            }
        };
    }

    public <T, R> Future<Response<T>> handleResponse(Future<Response<T>> response, HttpClientInstrumentation.RequestHandler<RequestT<Object, T, R>> handler) {
        response.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SttpClientInstrumentation$.$anonfun$handleResponse$1(handler, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
        return response;
    }

    public static final /* synthetic */ void $anonfun$handleResponse$1(HttpClientInstrumentation.RequestHandler handler$1, Try x0$1) {
        if (x0$1 instanceof Success) {
            Response res = (Response)((Success)x0$1).value();
            handler$1.processResponse(MODULE$.toResponseBuilder(res));
            return;
        }
        if (x0$1 instanceof Failure) {
            Throwable t = ((Failure)x0$1).exception();
            handler$1.span().fail(t).finish();
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    private SttpClientInstrumentation$() {
        MODULE$ = this;
        this.httpClientInstrumentation = this.rebuildHttpClientInstrumentation();
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable & scala.Serializable)x$1 -> {
            SttpClientInstrumentation$.MODULE$.httpClientInstrumentation_$eq(SttpClientInstrumentation$.MODULE$.rebuildHttpClientInstrumentation());
            return BoxedUnit.UNIT;
        });
    }
}

