/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.sttp;

import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.sttp.SttpClientInstrumentation;
import kamon.trace.Span;
import kamon.trace.SpanBuilder;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import sttp.client3.RequestT;
import sttp.client3.Response;

public class RequestSendAdvice {
    @Advice.OnMethodEnter
    public static HttpClientInstrumentation.RequestHandler<RequestT> enter(@Advice.Argument(value=0, readOnly=false) RequestT requestT, @Advice.Local(value="scope") Storage.Scope scope) {
        HttpClientInstrumentation.RequestHandler requestHandler = SttpClientInstrumentation.getHandler(requestT);
        String string = requestT.uri().toString();
        SpanBuilder spanBuilder = Kamon.spanBuilder((String)string).tag("protocol", "http2->1").tag("component", "sttp.client3").tag("http.method", requestT.method().toString()).tag("path", string);
        if (!Kamon.currentSpan().isEmpty()) {
            spanBuilder.asChildOf(Kamon.currentSpan());
        }
        Span span = spanBuilder.start().takeSamplingDecision();
        scope = Kamon.storeContext((Context)Kamon.currentContext().withEntry(Span.Key(), (Object)span));
        requestT = (RequestT)requestHandler.request();
        return requestHandler;
    }

    @Advice.OnMethodExit
    public static <T> void exit(@Advice.Enter HttpClientInstrumentation.RequestHandler<RequestT> requestHandler, @Advice.Return(readOnly=false) Response<T> response, @Advice.Local(value="scope") Storage.Scope scope) {
        try {
            requestHandler.processResponse(SttpClientInstrumentation.toResponseBuilder(response));
        }
        catch (Exception exception) {
            requestHandler.span().fail((Throwable)exception);
            throw exception;
        }
        finally {
            requestHandler.span().finish();
            scope.close();
        }
    }
}

