/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.Rendering.IJavaRenderer;
import ArmyC2.C2SD.Rendering.JavaRenderer;
import ArmyC2.C2SD.Rendering.TacticalGraphicIconRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.SinglePointFont;
import ArmyC2.C2SD.Utilities.SinglePointLookup;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.UnitDefTable;
import ArmyC2.C2SD.Utilities.UnitFontLookup;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import sec.web.renderer.SECRenderer;
import sec.web.renderer.SinglePointRendererService;
import sec.web.renderer.utilities.JavaRendererUtilities;
import sec.web.renderer.utilities.PNGInfo;

public class SinglePointServer {
    private static IJavaRenderer jr = null;
    private static TacticalGraphicIconRenderer tgir = null;
    private SinglePointRendererService plugins = null;
    private static boolean _preloadedRenderer = false;
    private SinglePointHandler _singlePointHandler = null;
    private HttpServer httpServer;
    private int portNumber = 6789;
    private int _backLog = 0;
    private int RENDER_TYPE_IMAGE = 0;
    private int RENDER_TYPE_KML = 1;
    private int RENDER_TYPE_SVG = 2;

    public SinglePointServer(int port) {
        this.portNumber = port;
        this.createHttpServer();
    }

    public SinglePointServer(int port, int backlog) {
        this.portNumber = port;
        this.createHttpServer();
    }

    private void createHttpServer() {
        try {
            this._singlePointHandler = new SinglePointHandler(0);
            int backlog = this._backLog;
            this.httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", this.portNumber), backlog);
            this.httpServer.createContext("/", this._singlePointHandler);
            this.httpServer.createContext("/mil-sym-service/renderer/image/", new SinglePointHandler(this.RENDER_TYPE_IMAGE));
            this.httpServer.createContext("/mil-sym-service/renderer/kml/", new SinglePointHandler(this.RENDER_TYPE_KML));
            this.httpServer.createContext("/mil-sym-service/renderer/svg/", new SinglePointHandler(this.RENDER_TYPE_SVG));
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
        }
        catch (BindException bexc) {
            String strTypicalPortInUseMessage = "Address already in use: bind";
            if (bexc.getMessage().startsWith(strTypicalPortInUseMessage)) {
                System.out.println("Port " + String.valueOf(this.portNumber) + " already in use. Incrementing...");
            } else {
                System.err.println(bexc.getMessage());
                bexc.printStackTrace();
            }
            ++this.portNumber;
            this.createHttpServer();
        }
        catch (IOException exc) {
            System.err.println(exc.getMessage());
            System.err.println(ErrorLogger.getStackTrace((Throwable)exc));
        }
        catch (Exception exc2) {
            System.err.println(exc2.getMessage());
            System.err.println(ErrorLogger.getStackTrace((Throwable)exc2));
        }
    }

    public void start() {
        try {
            this.httpServer.start();
            System.out.println("Single point server started on port #" + String.valueOf(this.portNumber));
        }
        catch (Exception e) {
            ++this.portNumber;
            this.createHttpServer();
        }
    }

    public void stop() {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop(0);
            }
            catch (Exception e) {
                this.httpServer = null;
            }
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void getSinglePointDimensions(String SymbolInfo2, Point2D center) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        this.getSinglePointDimensions(SymbolInfo2, center, bounds);
    }

    public void getSinglePointDimensions(String SymbolInfo2, Point2D center, Rectangle2D bounds) {
        this._singlePointHandler.getSinglePointDimensions(SymbolInfo2, center, bounds, null);
    }

    public void getSinglePointDimensions(String SymbolInfo2, Point2D center, Rectangle2D bounds, Dimension2D iconExtent) {
        this._singlePointHandler.getSinglePointDimensions(SymbolInfo2, center, bounds, iconExtent);
    }

    public byte[] getSinglePointByteArray(String SymbolInfo2) {
        return this._singlePointHandler.getSinglePointByteArray(SymbolInfo2);
    }

    public void setTacticalGraphicPointSize(int size) {
        jr.setSinglePointTGSymbolSize(size);
    }

    public void setUnitPointSize(int size) {
        jr.setUnitSymbolSize(size);
    }

    class SinglePointHandler
    implements HttpHandler {
        private int _renderType = 0;
        private SECRenderer sr = SECRenderer.getInstance();

        public SinglePointHandler(int renderType) {
            this.initRenderer();
            this._renderType = renderType;
        }

        public byte[] getSinglePointByteArray(String symbolID) {
            byte[] pngResponse = null;
            try {
                Map<String, String> params = JavaRendererUtilities.createParameterMapFromURL(symbolID);
                pngResponse = this.getSinglePointBytes(symbolID, params);
                return pngResponse;
            }
            catch (Exception exc) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getSinglePointByteArray", (Exception)exc, (Level)Level.WARNING);
                return null;
            }
        }

        @Override
        public void handle(HttpExchange exchange) {
            String allowOrigin = exchange.getRemoteAddress().toString();
            if (exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                Date date;
                OutputStream responseBody;
                Headers headers;
                String url = null;
                byte[] pngResponse = null;
                byte[] kmlResponse = null;
                byte[] svgResponse = null;
                int svgDrawMode = 0;
                Boolean isIcon = false;
                try {
                    url = exchange.getRequestURI().toString();
                    url = exchange.getLocalAddress().toString() + url;
                    if (url.startsWith("/")) {
                        url = url.substring(1);
                    }
                    String symbolID = url.substring(url.lastIndexOf("/") + 1);
                    Map<String, String> params = JavaRendererUtilities.createParameterMapFromURL(url);
                    if (this._renderType == SinglePointServer.this.RENDER_TYPE_IMAGE) {
                        if (params.containsKey("ICON") && (isIcon = Boolean.valueOf(Boolean.parseBoolean(params.get("ICON")))).booleanValue()) {
                            params = JavaRendererUtilities.parseIconParameters(symbolID, params);
                        }
                        pngResponse = this.getSinglePointBytes(symbolID, params);
                    } else if (this._renderType == SinglePointServer.this.RENDER_TYPE_KML) {
                        if (url.indexOf("?") > -1) {
                            url = url.substring(0, url.indexOf("?"));
                        }
                        String kml = this.sr.getSymbolImageKML(url, symbolID, params);
                        kmlResponse = kml.getBytes();
                    } else if (this._renderType == SinglePointServer.this.RENDER_TYPE_SVG) {
                        if (symbolID.indexOf("?") > -1) {
                            symbolID = symbolID.substring(0, symbolID.indexOf("?"));
                        }
                        if (params.containsKey("ICON") && Boolean.parseBoolean(params.get("ICON"))) {
                            params = JavaRendererUtilities.parseIconParameters(symbolID, params);
                            symbolID = JavaRendererUtilities.sanitizeSymbolID(symbolID);
                            isIcon = true;
                        }
                        PNGInfo pi = this.sr.getMilStdSymbolImage(symbolID, params);
                        if (isIcon.booleanValue()) {
                            pi = pi.squareImage();
                        } else if (params.containsKey("CENTER") && Boolean.parseBoolean(params.get("CENTER"))) {
                            svgDrawMode = 1;
                        } else if (params.containsKey("SQUARE") && Boolean.parseBoolean(params.get("SQUARE"))) {
                            svgDrawMode = 2;
                        }
                        svgResponse = pi.toSVG(svgDrawMode).getBytes();
                    } else {
                        pngResponse = this.getSinglePointBytes(symbolID, params);
                    }
                }
                catch (Exception exc) {
                    ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)exc, (Level)Level.WARNING);
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", "text/plain");
                        exchange.sendResponseHeaders(503, 0L);
                        exchange.getResponseBody().close();
                    }
                    catch (IOException ex) {
                        ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)ex, (Level)Level.WARNING);
                    }
                    catch (Exception exc2) {
                        ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)exc2, (Level)Level.WARNING);
                    }
                }
                if (pngResponse != null) {
                    responseBody = null;
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", "image/png");
                        exchange.sendResponseHeaders(200, 0L);
                        responseBody = exchange.getResponseBody();
                        responseBody.write(pngResponse);
                        responseBody.close();
                    }
                    catch (IOException exc) {
                        date = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
                        System.err.println("SinglePointServer.handle() tried sending response");
                        System.err.println(sdf.format(date));
                        System.err.println(exchange.getRequestURI().toString());
                        System.err.println(exc.getMessage());
                    }
                    catch (Exception exc3) {
                        ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)exc3, (Level)Level.WARNING);
                    }
                } else if (kmlResponse != null) {
                    responseBody = null;
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", "text/xml");
                        exchange.sendResponseHeaders(200, 0L);
                        responseBody = exchange.getResponseBody();
                        responseBody.write(kmlResponse);
                        responseBody.close();
                    }
                    catch (IOException exc) {
                        date = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
                        System.err.println("SinglePointServer.handle() tried sending response");
                        System.err.println(sdf.format(date));
                        System.err.println(exchange.getRequestURI().toString());
                        System.err.println(exc.getMessage());
                    }
                    catch (Exception exc3) {
                        ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)exc3, (Level)Level.WARNING);
                    }
                } else if (svgResponse != null) {
                    responseBody = null;
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", "image/svg+xml");
                        exchange.sendResponseHeaders(200, 0L);
                        responseBody = exchange.getResponseBody();
                        responseBody.write(svgResponse);
                        responseBody.close();
                    }
                    catch (IOException exc) {
                        date = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
                        System.err.println("SinglePointServer.handle() tried sending response");
                        System.err.println(sdf.format(date));
                        System.err.println(exchange.getRequestURI().toString());
                        System.err.println(exc.getMessage());
                    }
                    catch (Exception exc4) {
                        ErrorLogger.LogException((String)"SinglePointServer", (String)"handle", (Exception)exc4, (Level)Level.WARNING);
                    }
                }
            }
        }

        private synchronized void initRenderer() {
            try {
                if (jr == null) {
                    jr = (IJavaRenderer)JavaRenderer.getInstance();
                    jr.setUnitSymbolSize(50);
                    jr.setSinglePointTGSymbolSize(80);
                    this.preloadRenderer();
                }
                if (tgir == null) {
                    tgir = TacticalGraphicIconRenderer.getInstance();
                }
                if (SinglePointServer.this.plugins == null) {
                    SinglePointServer.this.plugins = SinglePointRendererService.getInstance();
                }
            }
            catch (Exception exc) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"initRenderer", (Exception)exc, (Level)Level.WARNING);
            }
        }

        private void preloadRenderer() {
            try {
                if (!_preloadedRenderer) {
                    MilStdSymbol foo = null;
                    foo = new MilStdSymbol("SFGPUCDM-------", "", null, null);
                    UnitFontLookup.getInstance();
                    SinglePointLookup.getInstance();
                    SymbolDefTable.getInstance();
                    UnitDefTable.getInstance();
                    foo = null;
                    SinglePointFont.getInstance().getSPFont(50.0f);
                    SinglePointFont.getInstance().getUnitFont(50.0f);
                    _preloadedRenderer = true;
                }
            }
            catch (Exception exc) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"preloadRenderer", (Exception)exc, (Level)Level.WARNING);
            }
        }

        public void getSinglePointDimensions(String SymbolInfo2, Point2D center, Rectangle2D bounds, Dimension2D iconExtent) {
            this.initRenderer();
            try {
                Map<String, String> params = JavaRendererUtilities.createParameterMapFromURL(SymbolInfo2);
                String renderer = params.get("RENDERER");
                if (renderer == null || renderer.equals("")) {
                    renderer = "2525";
                }
                if (!SinglePointServer.this.plugins.hasRenderer(renderer).booleanValue()) {
                    renderer = "2525";
                }
                String pluginSymbolID = null;
                ISinglePointInfo spi = null;
                if (renderer != null && SinglePointServer.this.plugins != null && SinglePointServer.this.plugins.hasRenderer(renderer).booleanValue()) {
                    int questionIndex = SymbolInfo2.indexOf(63);
                    pluginSymbolID = questionIndex == -1 ? SymbolInfo2 : SymbolInfo2.substring(0, questionIndex);
                    spi = SinglePointServer.this.plugins.render(renderer, pluginSymbolID, params);
                }
                if (spi != null && spi.getImage() != null) {
                    ImageInfo iInfo = new ImageInfo(spi.getImage(), 0, 0, (int)spi.getSymbolCenterPoint().getX(), (int)spi.getSymbolCenterPoint().getY(), spi.getSymbolBounds());
                    center.setLocation(iInfo.getSymbolCenterPoint());
                    bounds.setFrame(iInfo.getSymbolBounds());
                    if (iconExtent != null) {
                        iconExtent.setSize(iInfo.getImage().getWidth(), iInfo.getImage().getHeight());
                    }
                }
            }
            catch (Exception exc) {
                System.out.println(exc.getMessage());
            }
        }

        private byte[] getSinglePointBytes(String symbolCode, Map<String, String> params) throws RendererException, IOException {
            byte[] byteArray = null;
            this.initRenderer();
            try {
                String renderer = params.get("RENDERER");
                if (renderer == null || renderer.equals("")) {
                    renderer = "2525";
                }
                if (!SinglePointServer.this.plugins.hasRenderer(renderer).booleanValue()) {
                    renderer = "2525";
                }
                String pluginSymbolID = null;
                ISinglePointInfo spi = null;
                if (SinglePointServer.this.plugins != null && SinglePointServer.this.plugins.hasRenderer(renderer).booleanValue()) {
                    int questionIndex = symbolCode.lastIndexOf(63);
                    pluginSymbolID = questionIndex == -1 ? URLDecoder.decode(symbolCode, "UTF-8") : URLDecoder.decode(symbolCode.substring(0, questionIndex), "UTF-8");
                    spi = SinglePointServer.this.plugins.render(renderer, pluginSymbolID, params);
                }
                if (spi == null || spi != null && spi.getImage() == null) {
                    spi = SinglePointServer.this.plugins.render("2525", pluginSymbolID, params);
                }
                ImageInfo iInfo = null;
                if (spi != null && spi.getImage() != null) {
                    iInfo = new ImageInfo(spi.getImage(), 0, 0, (int)spi.getSymbolCenterPoint().getX(), (int)spi.getSymbolCenterPoint().getY(), spi.getSymbolBounds());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PNGInfo pi = null;
                if (params.containsKey("ICON") && Boolean.parseBoolean(params.get("ICON"))) {
                    BufferedImage bit = null;
                    pi = new PNGInfo(iInfo);
                    bit = pi.squareImage().getImage();
                    ImageIO.write((RenderedImage)bit, "png", baos);
                } else if (params.containsKey("BUFFER")) {
                    int eWidth = 0;
                    int eHeight = 0;
                    int ecX = 0;
                    int ecY = 0;
                    int buffer = 0;
                    if (params.containsKey("EWIDTH")) {
                        eWidth = Math.round(Float.parseFloat(params.get("EWIDTH")));
                    }
                    if (params.containsKey("EHEIGHT")) {
                        eHeight = Math.round(Float.parseFloat(params.get("EHEIGHT")));
                    }
                    if (params.containsKey("ECENTERX")) {
                        ecX = Math.round(Float.parseFloat(params.get("ECENTERX")));
                    }
                    if (params.containsKey("ECENTERY")) {
                        ecY = Math.round(Float.parseFloat(params.get("ECENTERY")));
                    }
                    if (params.containsKey("BUFFER")) {
                        buffer = Integer.parseInt(params.get("BUFFER"));
                    }
                    pi = new PNGInfo(iInfo);
                    if (eWidth > 0 && eHeight > 0 && ecX > 0 && ecY > 0 && buffer > 0) {
                        pi = pi.fitImage(eWidth, eHeight, ecX, ecY, buffer);
                        ImageIO.write((RenderedImage)pi.getImage(), "png", baos);
                    } else {
                        BufferedImage image = iInfo.getImage();
                        ImageIO.write((RenderedImage)image, "png", baos);
                    }
                } else {
                    pi = new PNGInfo(iInfo);
                    boolean center = false;
                    boolean meta = false;
                    if (params.containsKey("CENTER")) {
                        center = Boolean.parseBoolean(params.get("CENTER"));
                    }
                    if (params.containsKey("META")) {
                        meta = Boolean.parseBoolean(params.get("META"));
                    }
                    if (center) {
                        pi = pi.centerImage();
                    }
                    byteArray = meta ? pi.getImageAsByteArrayWithMetaInfo() : pi.getImageAsByteArray();
                }
                if (byteArray == null) {
                    baos.flush();
                    byteArray = baos.toByteArray();
                    baos.close();
                }
            }
            catch (Exception exc) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getSinglePointBytes", (Exception)exc, (Level)Level.WARNING);
            }
            return byteArray;
        }
    }
}

