/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import sec.geo.kml.KmlOptions;
import sec.web.json.utilities.JSONArray;
import sec.web.json.utilities.JSONException;
import sec.web.json.utilities.JSONObject;
import sec.web.renderer.MultiPointHandler;
import sec.web.renderer.SECRenderer;
import sec.web.renderer.Shape3DHandler;
import sec.web.renderer.SinglePointRendererService;
import sec.web.renderer.SinglePointServer;
import sec.web.renderer.SymbolModifiers;
import sec.web.renderer.utilities.JavaRendererUtilities;
import sec.web.renderer.utilities.SinglePointServerTester;

public class SECWebRenderer
extends Applet {
    private static final long serialVersionUID = -2691218568602318366L;
    public static final String CYLINDER = "CYLINDER-------";
    public static final String ORBIT = "ORBIT----------";
    public static final String ROUTE = "ROUTE----------";
    public static final String POLYGON = "POLYGON--------";
    public static final String RADARC = "RADARC---------";
    public static final String POLYARC = "POLYARC--------";
    public static final String CAKE = "CAKE-----------";
    public static final String TRACK = "TRACK----------";
    public static final String ATTRIBUTES = "attributes";
    public static final String MIN_ALT = "minalt";
    public static final String MAX_ALT = "maxalt";
    public static final String RADIUS1 = "radius1";
    public static final String RADIUS2 = "radius2";
    public static final String LEFT_AZIMUTH = "leftAzimuth";
    public static final String RIGHT_AZIMUTH = "rightAzimuth";
    public static final double MIN_ALT_DEFAULT = 0.0;
    public static final double MAX_ALT_DEFAULT = 100.0;
    public static final double RADIUS1_DEFAULT = 50.0;
    public static final double RADIUS2_DEFAULT = 100.0;
    public static final double LEFT_AZIMUTH_DEFAULT = 0.0;
    public static final double RIGHT_AZIMUTH_DEFAULT = 90.0;
    public static String ERR_ATTRIBUTES_NOT_FORMATTED = "{\"type\":\"error\",\"error\":\"The attribute paramaters are not formatted correctly";
    public static final String DEFAULT_ATTRIBUTES = "[{radius1:50.0,radius2:100.0,minalt:0.0,maxalt:100.0,rightAzimuth:90.0,leftAzimuth:0.0}]";
    private SinglePointServer sps = null;
    private static int spsPortNumber = -1;

    @Override
    public void init() {
        try {
            System.out.println(this.getManifestInfoString());
            RendererSettings.getInstance().setSinglePointSymbolOutlineWidth(1);
            RendererSettings.getInstance().setTextRenderMethod(1);
            RendererSettings.getInstance().setTextBackgroundMethod(3);
            RendererSettings.getInstance().setTextOutlineWidth(2);
            RendererSettings.getInstance().setLabelForegroundColor(Color.BLACK);
            RendererSettings.getInstance().setLabelBackgroundColor(new Color(255, 255, 255, 200));
            RendererSettings.getInstance().setLabelFont("arial", 1, 12);
            ErrorLogger.setLevel((Level)Level.FINE);
            this.loadDefaultPlugins();
            this.sps = new SinglePointServer(6789);
            this.sps.start();
            SinglePointServerTester urlTesterThread = new SinglePointServerTester(this.sps);
            Thread thr1 = new Thread(urlTesterThread);
            thr1.start();
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"init", (Exception)exc, (Level)Level.WARNING);
        }
    }

    private Manifest getManifest() {
        Manifest mf = null;
        try {
            String className = SECRenderer.class.getSimpleName() + ".class";
            String classPath = SECRenderer.class.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return null;
            }
            String mfPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            mf = new Manifest(new URL(mfPath).openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mf;
    }

    public String getManifestInfoString() {
        String info;
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            info = null;
            Manifest mf = null;
            Attributes attribs = null;
            try {
                mf = this.getManifest();
                if (mf != null) {
                    try {
                        sb.append("Manifest Info:\n");
                        attribs = mf.getMainAttributes();
                        if (attribs != null) {
                            sb.append("Implementation-Title: ");
                            sb.append(attribs.getValue("Implementation-Title"));
                            sb.append("\n");
                            sb.append("Implementation-Version: ");
                            sb.append(attribs.getValue("Implementation-Version"));
                            sb.append("\n");
                            sb.append("Implementation-Vendor: ");
                            sb.append(attribs.getValue("Implementation-Vendor"));
                            sb.append("\n");
                            sb.append("Build-Number: ");
                            sb.append(attribs.getValue("Build-Number"));
                            sb.append("\n");
                            sb.append("Build-Date: ");
                            sb.append(attribs.getValue("Build-Date"));
                            sb.append("\n");
                            sb.append("Trusted-Library: ");
                            sb.append(attribs.getValue("Trusted-Library"));
                            sb.append("\n");
                        }
                        break block6;
                    }
                    catch (Exception exception) {}
                    break block6;
                }
                sb.append("manifest null");
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
            }
        }
        info = sb.toString();
        return info;
    }

    private void loadDefaultPlugins() {
        try {
            SinglePointRendererService.getInstance().LoadSPRendererServices();
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"loadDefaultPlugins", (Exception)exc);
        }
    }

    private List<String> checkPluginServiceForPlugins() {
        int timeoutInMiliseconds = 3000;
        ArrayList<String> plugins = new ArrayList<String>();
        try {
            String path = this.getDocumentBase().toString();
            path = path.replace("https://", "");
            String[] split = path.split("/");
            path = "https://" + split[0] + "/mil-symbology-renderer/renderer/pluginList";
            URL url = new URL(path);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setConnectTimeout(timeoutInMiliseconds);
            urlConn.setReadTimeout(timeoutInMiliseconds);
            urlConn.connect();
            int response = urlConn.getResponseCode();
            String strResponse = null;
            if (response == 200) {
                StringBuilder sbResponse = new StringBuilder();
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                String inputLine = null;
                while ((inputLine = in.readLine()) != null) {
                    sbResponse.append(inputLine);
                }
                in.close();
                strResponse = sbResponse.toString();
                if (strResponse != null && !strResponse.equals("")) {
                    path = path.replace("directoryReader", "");
                    split = strResponse.split(",");
                    String temp = null;
                    for (String plugin : split) {
                        temp = plugin;
                        if (!temp.endsWith(".jar")) continue;
                        plugins.add(temp);
                    }
                    return plugins;
                }
                return null;
            }
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"checkPluginServiceForPlugins", (Exception)exc);
            return null;
        }
    }

    private boolean isPluginServiceAvailable() {
        try {
            int timeoutInSeconds = 1;
            int timeoutInMiliseconds = timeoutInSeconds * 1000;
            String strUrl = "";
            URL url = new URL(strUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setConnectTimeout(timeoutInMiliseconds);
            urlConn.setReadTimeout(timeoutInMiliseconds);
            urlConn.connect();
            int response = urlConn.getResponseCode();
            return response == 200;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"isPluginServiceAvailable", (Exception)exc);
            return false;
        }
    }

    public void setLoggingLevel(Level level) {
        try {
            ErrorLogger.setLevel((Level)level, (Boolean)true);
            ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"setLoggingLevel(Level)", (String)("Logging level set to: " + ErrorLogger.getLevel().getName()), (Level)Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"setLoggingLevel(Level)", (Exception)exc, (Level)Level.INFO);
        }
    }

    public void setLoggingLevel(int level) {
        try {
            if (level > 1000) {
                ErrorLogger.setLevel((Level)Level.OFF, (Boolean)true);
            } else if (level > 900) {
                ErrorLogger.setLevel((Level)Level.SEVERE, (Boolean)true);
            } else if (level > 800) {
                ErrorLogger.setLevel((Level)Level.WARNING, (Boolean)true);
            } else if (level > 700) {
                ErrorLogger.setLevel((Level)Level.INFO, (Boolean)true);
            } else if (level > 500) {
                ErrorLogger.setLevel((Level)Level.CONFIG, (Boolean)true);
            } else if (level > 400) {
                ErrorLogger.setLevel((Level)Level.FINE, (Boolean)true);
            } else if (level > 300) {
                ErrorLogger.setLevel((Level)Level.FINER, (Boolean)true);
            } else if (level > Integer.MIN_VALUE) {
                ErrorLogger.setLevel((Level)Level.FINEST, (Boolean)true);
            } else {
                ErrorLogger.setLevel((Level)Level.ALL, (Boolean)true);
            }
            ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"setLoggingLevel(int)", (String)("Logging level set to: " + ErrorLogger.getLevel().getName()), (Level)Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"setLoggingLevel(int)", (Exception)exc, (Level)Level.INFO);
        }
    }

    public void setDefaultSymbologyStandard(int symStd) {
        RendererSettings.getInstance().setSymbologyStandard(symStd);
    }

    public void setTacticalGraphicPointSize(int size) {
        this.sps.setTacticalGraphicPointSize(size);
    }

    public void setUnitPointSize(int size) {
        this.sps.setUnitPointSize(size);
    }

    public void setModifierTextColor(String hexColor) {
        Color textColor = SymbolUtilities.getColorFromHexString((String)hexColor);
        if (textColor == null) {
            textColor = Color.black;
        }
        RendererSettings.getInstance().setLabelForegroundColor(textColor);
    }

    private boolean hasHttpServer() {
        try {
            String version = System.getProperty("java.version");
            boolean hasHttp = false;
            String[] versionArray = version.split(".");
            int subVersion = Integer.parseInt(versionArray[1].trim());
            if (subVersion >= 6) {
                hasHttp = true;
            }
            return hasHttp;
        }
        catch (Exception ea) {
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"hasHttpServer", (Exception)ea, (Level)Level.WARNING);
            return false;
        }
    }

    public String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, String modifiers, int format) {
        return this.RenderSymbol(id, name, description, symbolCode, controlPoints, altitudeMode, scale, bbox, modifiers, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    public String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, String modifiers, int format, int symStd) {
        String output = "";
        try {
            modifiers = JavaRendererUtilities.addAltModeToModifiersString(modifiers, altitudeMode);
            if (this.sps != null && spsPortNumber == -1) {
                spsPortNumber = this.sps.getPortNumber();
            }
            if (!altitudeMode.equals("clampToGround") && format == 0 && JavaRendererUtilities.is3dSymbol(symbolCode, modifiers)) {
                if (altitudeMode.isEmpty()) {
                    altitudeMode = "absolute";
                }
                output = SECWebRenderer.RenderMilStd3dSymbol(name, id, symbolCode, description, altitudeMode, controlPoints, modifiers);
                String modifierKML = MultiPointHandler.getModififerKML(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                if ((output = output.replaceFirst("</Folder>", modifierKML = modifierKML + "</Folder>")).equals("") || output.startsWith("{")) {
                    output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                }
            } else {
                output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                if (ErrorLogger.getLevel().intValue() <= Level.FINER.intValue()) {
                    System.out.println("");
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nID: " + id + "\n");
                    sb.append("Name: " + name + "\n");
                    sb.append("Description: " + description + "\n");
                    sb.append("SymbolID: " + symbolCode + "\n");
                    sb.append("SymStd: " + String.valueOf(symStd) + "\n");
                    sb.append("Scale: " + String.valueOf(scale) + "\n");
                    sb.append("BBox: " + bbox + "\n");
                    sb.append("Coords: " + controlPoints + "\n");
                    sb.append("Modifiers: " + modifiers + "\n");
                    ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"RenderSymbol", (String)sb.toString(), (Level)Level.FINER);
                }
                if (ErrorLogger.getLevel().intValue() <= Level.FINEST.intValue()) {
                    String briefOutput = output.replaceAll("</Placemark>", "</Placemark>\n");
                    briefOutput = output.replaceAll("(?s)<description[^>]*>.*?</description>", "<description></description>");
                    ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"RenderSymbol", (String)("Output:\n" + briefOutput), (Level)Level.FINEST);
                }
            }
        }
        catch (Exception ea) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol - " + ea.toString() + "'}";
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"RenderSymbol", (Exception)ea, (Level)Level.WARNING);
        }
        return output;
    }

    public String RenderSymbol2D(String symbolCode, String name, String description, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String modifiers) {
        String output = "";
        try {
            output = MultiPointHandler.RenderSymbol2D("", name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, 1);
        }
        catch (Exception exc) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol: " + symbolCode + " - " + exc.toString() + "'}";
        }
        return output;
    }

    public String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String modifiers, int format) {
        return this.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    public String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String modifiers, int format, int symStd) {
        String output = "";
        try {
            if (this.sps != null && spsPortNumber == -1) {
                spsPortNumber = this.sps.getPortNumber();
            }
            output = MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, format, symStd);
        }
        catch (Exception exc) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol: " + symbolCode + " - " + exc.toString() + "'}";
        }
        return output;
    }

    public String Render3dSymbol(String name, String id, String shapeType, String description, String lineColor, String fillColor, String altitudeMode, String controlPoints, String attributes) {
        String returnValue = "";
        try {
            JSONArray attributesArray;
            int attributesArrayLength;
            StringBuilder output = new StringBuilder();
            SymbolModifiers modifiers = new SymbolModifiers();
            JSONObject attributesJSON = new JSONObject(attributes);
            if (attributesJSON == null || attributes.equals("")) {
                attributesJSON = new JSONObject(DEFAULT_ATTRIBUTES);
            }
            if ((attributesArrayLength = (attributesArray = attributesJSON.getJSONArray(ATTRIBUTES)).length()) > 0) {
                for (int i = 0; i < attributesArrayLength; ++i) {
                    JSONObject currentAttributeSet = attributesArray.getJSONObject(i);
                    if (currentAttributeSet.has(RADIUS1)) {
                        modifiers.AM_DISTANCE.add(currentAttributeSet.getDouble(RADIUS1));
                    }
                    if (currentAttributeSet.has(RADIUS2)) {
                        modifiers.AM_DISTANCE.add(currentAttributeSet.getDouble(RADIUS2));
                    }
                    if (currentAttributeSet.has(MIN_ALT)) {
                        modifiers.X_ALTITUDE_DEPTH.add(currentAttributeSet.getDouble(MIN_ALT));
                    }
                    if (currentAttributeSet.has(MAX_ALT)) {
                        modifiers.X_ALTITUDE_DEPTH.add(currentAttributeSet.getDouble(MAX_ALT));
                    }
                    if (currentAttributeSet.has(LEFT_AZIMUTH)) {
                        modifiers.AN_AZIMUTH.add(currentAttributeSet.getDouble(LEFT_AZIMUTH));
                    }
                    if (!currentAttributeSet.has(RIGHT_AZIMUTH)) continue;
                    modifiers.AN_AZIMUTH.add(currentAttributeSet.getDouble(RIGHT_AZIMUTH));
                }
            }
            returnValue = Shape3DHandler.render3dSymbol(name, id, shapeType, description, lineColor, fillColor, altitudeMode, controlPoints, modifiers);
        }
        catch (JSONException je) {
            ErrorLogger.LogException((String)this.getName(), (String)"Render3dSymbol()", (Exception)je);
            return ERR_ATTRIBUTES_NOT_FORMATTED;
        }
        catch (Exception ea) {
            ErrorLogger.LogException((String)this.getName(), (String)"Render3dSymbol()", (Exception)ea);
            return "";
        }
        return returnValue;
    }

    public static String RenderMilStd3dSymbol(String name, String id, String symbolCode, String description, String altitudeMode, String controlPoints, String modifiers) {
        String symbolId = symbolCode.substring(4, 10);
        SymbolModifiers attributes = new SymbolModifiers();
        String output = "";
        KmlOptions.AltitudeMode convertedAltitudeMode = KmlOptions.AltitudeMode.RELATIVE_TO_GROUND;
        if (!altitudeMode.equals("")) {
            convertedAltitudeMode = KmlOptions.AltitudeMode.fromString(altitudeMode);
        }
        try {
            JSONArray altitudeDepthJSON = null;
            JSONArray distanceJSON = null;
            JSONArray azimuthJSON = null;
            int altitudeDepthLength = 0;
            int distanceLength = 0;
            int azimuthLength = 0;
            String lineColor = null;
            String fillColor = null;
            JSONObject lumpCrabJSON = new JSONObject(modifiers);
            JSONObject modifiersJSON = lumpCrabJSON.has("modifiers") ? lumpCrabJSON.getJSONObject("modifiers") : lumpCrabJSON;
            if (modifiersJSON != null) {
                int i;
                Color c;
                if (modifiersJSON.has("altitudeDepth") && !modifiersJSON.isNull("altitudeDepth")) {
                    altitudeDepthJSON = modifiersJSON.getJSONArray("altitudeDepth");
                    altitudeDepthLength = altitudeDepthJSON.length();
                } else if (modifiersJSON.has("X") && !modifiersJSON.isNull("X")) {
                    altitudeDepthJSON = modifiersJSON.getJSONArray("X");
                    altitudeDepthLength = altitudeDepthJSON.length();
                }
                if (modifiersJSON.has("azimuth") && !modifiersJSON.isNull("azimuth")) {
                    azimuthJSON = modifiersJSON.getJSONArray("azimuth");
                    azimuthLength = azimuthJSON.length();
                } else if (modifiersJSON.has("AN") && !modifiersJSON.isNull("AN")) {
                    azimuthJSON = modifiersJSON.getJSONArray("AN");
                    azimuthLength = azimuthJSON.length();
                }
                if (modifiersJSON.has("distance") && !modifiersJSON.isNull("distance")) {
                    distanceJSON = modifiersJSON.getJSONArray("distance");
                    distanceLength = distanceJSON.length();
                } else if (modifiersJSON.has("AM") && !modifiersJSON.isNull("AM")) {
                    distanceJSON = modifiersJSON.getJSONArray("AM");
                    distanceLength = distanceJSON.length();
                }
                if (modifiersJSON.has("lineColor") && !modifiersJSON.isNull("lineColor")) {
                    lineColor = modifiersJSON.getString("lineColor");
                } else {
                    c = SymbolUtilities.getLineColorOfAffiliation((String)symbolCode);
                    if (c != null) {
                        lineColor = Integer.toHexString(c.getRGB());
                    }
                    if (lineColor == null) {
                        lineColor = "FF000000";
                    }
                }
                if (modifiersJSON.has("fillColor") && !modifiersJSON.isNull("fillColor")) {
                    fillColor = modifiersJSON.getString("fillColor");
                } else {
                    c = SymbolUtilities.getFillColorOfAffiliation((String)symbolCode);
                    if (c != null) {
                        fillColor = Integer.toHexString(c.getRGB());
                    }
                    if (fillColor == null) {
                        fillColor = "AA000000";
                    }
                }
                fillColor = JavaRendererUtilities.ARGBtoABGR(fillColor);
                lineColor = JavaRendererUtilities.ARGBtoABGR(lineColor);
                if (symbolId.startsWith("AKP") && altitudeDepthLength == 1) {
                    attributes.X_ALTITUDE_DEPTH.add(0.0);
                }
                for (i = 0; i < altitudeDepthLength; ++i) {
                    attributes.X_ALTITUDE_DEPTH.add(altitudeDepthJSON.getDouble(i));
                }
                for (i = 0; i < distanceLength; ++i) {
                    if (symbolId.equals("ACAR--") || symbolId.equals("AKPR--") || symbolId.equals("ALC---") || symbolId.equals("ALM---") || symbolId.equals("ALS---") || symbolId.equals("ALU---") || symbolId.equals("ALL---")) {
                        double width = distanceJSON.getDouble(i) / 2.0;
                        attributes.AM_DISTANCE.add(width);
                        attributes.AM_DISTANCE.add(width);
                        continue;
                    }
                    attributes.AM_DISTANCE.add(distanceJSON.getDouble(i));
                }
                if (symbolId.equals("ACAI--") || symbolId.equals("AKPI--") || symbolId.equals("AAR---") || symbolId.equals("AAF---") || symbolId.equals("AAH---") || symbolId.equals("AAM---") || symbolId.equals("AAML--") || symbolId.equals("AAMH--")) {
                    output = Shape3DHandler.buildPolygon(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
                } else if (symbolId.equals("ACAR--") || symbolId.equals("AKPR--") || symbolId.equals("ALC---") || symbolId.equals("ALM---") || symbolId.equals("ALS---") || symbolId.equals("ALU---") || symbolId.equals("ALL---")) {
                    output = Shape3DHandler.buildTrack(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
                } else if (symbolId.equals("ACAC--") || symbolId.equals("AKPC--")) {
                    output = Shape3DHandler.buildCylinder(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
                }
            }
        }
        catch (JSONException je) {
            output = "";
        }
        return output;
    }

    public int GetPortNumber() {
        if (this.sps != null) {
            return this.sps.getPortNumber();
        }
        System.out.println("SEC Web Renderer Single Point Server is NULL");
        return 0;
    }

    public String getSinglePointAnchor(String symbolID) {
        String anchorPoint = "";
        if (this.sps != null) {
            Point2D.Double anchor = new Point2D.Double();
            this.sps.getSinglePointDimensions(symbolID, anchor);
            anchorPoint = ((Point2D)anchor).getX() + "," + ((Point2D)anchor).getY();
        }
        return anchorPoint;
    }

    public String getSinglePointInfo(String symbolID) {
        String info = "";
        Point2D.Double anchor = new Point2D.Double();
        Rectangle2D.Double symbolBounds = new Rectangle2D.Double();
        Dimension iconSize = new Dimension();
        this.sps.getSinglePointDimensions(symbolID, anchor, symbolBounds, iconSize);
        info = ((Point2D)anchor).getX() + "," + ((Point2D)anchor).getY() + "," + ((RectangularShape)symbolBounds).getX() + "," + ((RectangularShape)symbolBounds).getY() + "," + ((RectangularShape)symbolBounds).getWidth() + "," + ((RectangularShape)symbolBounds).getHeight() + "," + ((Dimension2D)iconSize).getWidth() + "," + ((Dimension2D)iconSize).getHeight();
        return info;
    }

    public String getSinglePointInfoBatch(String batch) {
        String info = "";
        Point2D.Double anchor = new Point2D.Double();
        Rectangle2D.Double symbolBounds = new Rectangle2D.Double();
        Dimension iconSize = new Dimension();
        Object symbolInfo = null;
        StringBuilder sb = new StringBuilder();
        try {
            batch = batch.replaceAll("=", "%3D");
            Object data = null;
            JSONObject jsonSPString = new JSONObject(batch);
            JSONArray jsa = jsonSPString.getJSONArray("iconURLs");
            int len = jsa.length();
            sb.append("{\"singlepoints\":[");
            String item = null;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                info = jsa.get(i).toString();
                info = info.replaceAll("%3D", "=");
                anchor = new Point2D.Double();
                symbolBounds = new Rectangle2D.Double();
                iconSize = new Dimension();
                this.sps.getSinglePointDimensions(info, anchor, symbolBounds, iconSize);
                item = SECWebRenderer.SymbolDimensionsToJSON(anchor, symbolBounds, iconSize);
                sb.append(item);
            }
            sb.append("]}");
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return sb.toString();
    }

    public static String SymbolDimensionsToJSON(Point2D anchor, Rectangle2D bounds, Dimension2D iconSize) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("{\"x\":");
            sb.append(anchor.getX());
            sb.append(",\"y\":");
            sb.append(anchor.getY());
            sb.append(",\"boundsx\":");
            sb.append(bounds.getX());
            sb.append(",\"boundsy\":");
            sb.append(bounds.getY());
            sb.append(",\"boundswidth\":");
            sb.append(bounds.getWidth());
            sb.append(",\"boundsheight\":");
            sb.append(bounds.getHeight());
            sb.append(",\"iconwidth\":");
            sb.append(iconSize.getWidth());
            sb.append(",\"iconheight\":");
            sb.append(iconSize.getHeight());
            sb.append("}");
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return sb.toString();
    }

    public String ShouldClipMultipointSymbol(String symbolID) {
        if (MultiPointHandler.ShouldClipSymbol(symbolID).booleanValue()) {
            return "true";
        }
        return "false";
    }

    public static String GenerateSymbolAreaFillUrl(Map<String, String> modifiers, ArrayList<ShapeInfo> clip) {
        int shapeType = 0;
        String url = "";
        String symbolFillIDs = null;
        String symbolLineIDs = null;
        int symbolSize = 25;
        boolean imageoffset = false;
        ArrayList lines = null;
        ArrayList points = null;
        Point2D point = null;
        Shape shape = null;
        double height = 0.0;
        double width = 0.0;
        int offsetX = 0;
        int offsetY = 0;
        int x = 0;
        int y = 0;
        Rectangle bounds = null;
        try {
            for (ShapeInfo si : clip) {
                shapeType = si.getShapeType();
                if (shapeType != ShapeInfo.SHAPE_TYPE_POLYLINE) continue;
                if (bounds == null) {
                    bounds = si.getBounds();
                } else {
                    Rectangle2D.union(bounds, si.getBounds(), bounds);
                }
                height = ((RectangularShape)bounds).getHeight();
                width = ((RectangularShape)bounds).getWidth();
                shape = si.getShape();
                lines = si.getPolylines();
                System.out.println("bounds: " + ((Object)bounds).toString());
                System.out.println("width: " + String.valueOf(width));
                if (((RectangularShape)bounds).getX() < 0.0) {
                    offsetX = (int)(((RectangularShape)bounds).getX() * -1.0);
                }
                if (!(((RectangularShape)bounds).getY() < 0.0)) continue;
                offsetY = (int)(((RectangularShape)bounds).getY() * -1.0);
            }
            StringBuilder sbCoords = new StringBuilder();
            StringBuilder sbUrl = new StringBuilder();
            if (modifiers.containsKey("symbolFillIds")) {
                symbolFillIDs = modifiers.get("symbolFillIds");
            }
            if (modifiers.containsKey("symbolLineIds")) {
                symbolLineIDs = modifiers.get("symbolLineIds");
            }
            if (modifiers.containsKey("symbolFillIconSize")) {
                symbolSize = Integer.getInteger(modifiers.get("symbolFillIconSize").toString());
            }
            if (symbolLineIDs == null || symbolSize > 0) {
                // empty if block
            }
            sbCoords.append("clipCoords=");
            for (int j = 0; j < lines.size(); ++j) {
                points = (ArrayList)lines.get(j);
                for (int i = 0; i < points.size(); ++i) {
                    if (i > 0 || j > 0) {
                        sbCoords.append(",");
                    }
                    point = (Point2D)points.get(i);
                    x = (int)(point.getX() + (double)offsetX);
                    y = (int)(point.getY() + (double)offsetY);
                    sbCoords.append(x);
                    sbCoords.append(",");
                    sbCoords.append(y);
                }
            }
            sbUrl.append("http://127.0.0.1:");
            sbUrl.append(String.valueOf(spsPortNumber));
            sbUrl.append("/AREASYMBOLFILL?");
            sbUrl.append("renderer=AreaSymbolFillRenderer&");
            sbUrl.append(sbCoords.toString());
            if (symbolFillIDs != null) {
                sbUrl.append("&symbolFillIds=");
                sbUrl.append(symbolFillIDs);
            }
            if (symbolLineIDs != null) {
                sbUrl.append("&symbolLineIds=");
                sbUrl.append(symbolLineIDs);
            }
            if (symbolSize > 0) {
                sbUrl.append("&symbolFillIconSize=");
                sbUrl.append(symbolSize);
            }
            sbUrl.append("&height=");
            sbUrl.append((Object)((int)height));
            sbUrl.append("&width=");
            sbUrl.append((Object)((int)width));
            url = sbUrl.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return url;
    }

    public static String GenerateSymbolLineFillUrl(Map<String, String> modifiers, ArrayList<Point2D> pixels, Rectangle2D clip) {
        boolean shapeType = false;
        String url = "";
        String symbolFillIDs = null;
        String symbolLineIDs = null;
        String strClip = null;
        int symbolSize = 25;
        boolean imageoffset = false;
        Object lines = null;
        Object points = null;
        Point2D point = null;
        Object shape = null;
        double height = 0.0;
        double width = 0.0;
        int offsetX = 0;
        int offsetY = 0;
        int x = 0;
        int y = 0;
        Rectangle bounds = null;
        try {
            GeneralPath path = new GeneralPath();
            Point2D temp = null;
            for (int i = 0; i < pixels.size(); ++i) {
                temp = pixels.get(i);
                if (i > 0) {
                    ((Path2D)path).lineTo(temp.getX(), temp.getY());
                    continue;
                }
                if (i != 0) continue;
                ((Path2D)path).moveTo(temp.getX(), temp.getY());
            }
            bounds = path.getBounds();
            height = ((RectangularShape)bounds).getHeight();
            width = ((RectangularShape)bounds).getWidth();
            if (((RectangularShape)bounds).getX() < 0.0) {
                offsetX = (int)(((RectangularShape)bounds).getX() * -1.0);
            } else if (((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth() > width) {
                offsetX = (int)(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth() - width) * -1;
            }
            if (((RectangularShape)bounds).getY() < 0.0) {
                offsetY = (int)(((RectangularShape)bounds).getY() * -1.0);
            } else if (((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() > height) {
                offsetY = (int)(((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() - height) * -1;
            }
            if (clip != null) {
                StringBuilder sbClip = new StringBuilder();
                sbClip.append("&clip=");
                sbClip.append(clip.getX());
                sbClip.append(",");
                sbClip.append(clip.getY());
                sbClip.append(",");
                sbClip.append(clip.getWidth());
                sbClip.append(",");
                sbClip.append(clip.getHeight());
                strClip = sbClip.toString();
            }
            StringBuilder sbCoords = new StringBuilder();
            StringBuilder sbUrl = new StringBuilder();
            sbCoords.append("coords=");
            if (modifiers.containsKey("symbolFillIds")) {
                symbolFillIDs = modifiers.get("symbolFillIds");
            }
            if (modifiers.containsKey("symbolLineIds")) {
                symbolLineIDs = modifiers.get("symbolLineIds");
            }
            if (modifiers.containsKey("symbolFillIconSize")) {
                symbolSize = Integer.getInteger(modifiers.get("symbolFillIconSize").toString());
            }
            if (modifiers.containsKey("clip")) {
                strClip = modifiers.get("clip").toString();
            }
            for (int i = 0; i < pixels.size(); ++i) {
                if (i > 0) {
                    sbCoords.append(",");
                }
                point = pixels.get(i);
                x = (int)(point.getX() + (double)offsetX);
                y = (int)(point.getY() + (double)offsetY);
                sbCoords.append(x);
                sbCoords.append(",");
                sbCoords.append(y);
            }
            sbUrl.append("http://127.0.0.1:");
            sbUrl.append(String.valueOf(spsPortNumber));
            sbUrl.append("/AREASYMBOLFILL?");
            sbUrl.append("renderer=AreaSymbolFillRenderer&");
            sbUrl.append(sbCoords.toString());
            if (symbolFillIDs != null) {
                sbUrl.append("&symbolFillIds=");
                sbUrl.append(symbolFillIDs);
            }
            if (symbolLineIDs != null) {
                sbUrl.append("&symbolLineIds=");
                sbUrl.append(symbolLineIDs);
            }
            if (symbolSize > 0) {
                sbUrl.append("&symbolFillIconSize=");
                sbUrl.append(symbolSize);
            }
            if (strClip != null) {
                sbUrl.append(strClip);
            }
            sbUrl.append("&height=");
            sbUrl.append((Object)((int)height));
            sbUrl.append("&width=");
            sbUrl.append((Object)((int)width));
            url = sbUrl.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return url;
    }

    public static String GenerateSymbolAreaFillUrl(String clipCoords, String SymbolIDs, int height, int width, int symbolSize) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("http://127.0.0.1:");
        sbUrl.append(String.valueOf(spsPortNumber));
        sbUrl.append("/AREASYMBOLFILL?");
        sbUrl.append("renderer=AreaSymbolFillRenderer&");
        sbUrl.append(clipCoords);
        sbUrl.append("&symbolFillIds=");
        sbUrl.append(SymbolIDs);
        sbUrl.append("&height=");
        sbUrl.append((Object)height);
        sbUrl.append("&width=");
        sbUrl.append((Object)width);
        if (symbolSize > 0) {
            sbUrl.append("&symbolFillIconSize=");
            sbUrl.append(symbolSize);
        }
        return sbUrl.toString();
    }

    public byte[] getSinglePointByteArray(String symbolID) {
        return this.sps.getSinglePointByteArray(symbolID);
    }

    @Override
    public void destroy() {
        this.sps.stop();
    }
}

