/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.Rendering.IJavaRenderer;
import ArmyC2.C2SD.Rendering.JavaRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.PointConversionDummy;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import sec.web.renderer.MultiPointHandler;
import sec.web.renderer.MultiPointServer;
import sec.web.renderer.SECWebRenderer;
import sec.web.renderer.SinglePointRendererService;
import sec.web.renderer.SinglePointServer;
import sec.web.renderer.utilities.JavaRendererUtilities;
import sec.web.renderer.utilities.PNGInfo;
import sec.web.renderer.utilities.SinglePointServerTester;

public class SECRenderer {
    private SinglePointServer sps = null;
    private MultiPointServer mps = null;
    private SinglePointServerTester spst = null;
    private SinglePointRendererService sprs = null;
    private IJavaRenderer jr = JavaRenderer.getInstance();
    private static SECRenderer renderer = null;

    private SECRenderer() {
        this.sprs = SinglePointRendererService.getInstance();
    }

    public static synchronized SECRenderer getInstance() {
        if (renderer == null) {
            renderer = new SECRenderer();
        }
        return renderer;
    }

    public Manifest getManifest() {
        Manifest mf = null;
        Object mfTemp = null;
        try {
            String className = SECRenderer.class.getSimpleName() + ".class";
            String classPath = SECRenderer.class.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return null;
            }
            String mfPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            mf = new Manifest(new URL(mfPath).openStream());
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return mf;
    }

    public String getManifestInfoString() {
        StringBuilder sb = new StringBuilder();
        Manifest mf = this.getManifest();
        Attributes attribs = null;
        sb.append("SECRenderer Manifest Info:\n");
        if (mf != null) {
            try {
                attribs = mf.getMainAttributes();
                if (attribs != null) {
                    sb.append("Implementation-Title: ");
                    sb.append(attribs.getValue("Implementation-Title"));
                    sb.append("\n");
                    sb.append("Implementation-Version: ");
                    sb.append(attribs.getValue("Implementation-Version"));
                    sb.append("\n");
                    sb.append("Implementation-Vendor: ");
                    sb.append(attribs.getValue("Implementation-Vendor"));
                    sb.append("\n");
                    sb.append("Build-Number: ");
                    sb.append(attribs.getValue("Build-Number"));
                    sb.append("\n");
                    sb.append("Build-Date: ");
                    sb.append(attribs.getValue("Build-Date"));
                    sb.append("\n");
                    sb.append("Trusted-Library: ");
                    sb.append(attribs.getValue("Trusted-Library"));
                    sb.append("\n");
                    sb.append("\nSymbology Standard set to: " + this.getSymbologyStandardString());
                    sb.append("\n");
                }
            }
            catch (Exception exception) {}
        } else {
            sb.append("Couldn't locate Manifest.mf");
        }
        return sb.toString();
    }

    public void printManifestInfo() {
        System.out.println(this.getManifestInfoString());
    }

    private String getSymbologyStandardString() {
        String std = "2525B";
        int symstd = RendererSettings.getInstance().getSymbologyStandard();
        switch (symstd) {
            case 0: {
                std = "2525B";
                break;
            }
            case 1: {
                std = "2525C";
                break;
            }
            case 2: {
                std = "2525D";
            }
        }
        return std;
    }

    public void matchSECWebRendererAppletDefaultRendererSettings() {
    }

    public void setDefaultSymbologyStandard(int symStd) {
        RendererSettings.getInstance().setSymbologyStandard(symStd);
    }

    public void setLoggingLevel(Level level) {
        try {
            ErrorLogger.setLevel((Level)level, (Boolean)true);
            ErrorLogger.LogMessage((String)"SECRenderer", (String)"setLoggingLevel(Level)", (String)("Logging level set to: " + ErrorLogger.getLevel().getName()), (Level)Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"setLoggingLevel(Level)", (Exception)exc, (Level)Level.INFO);
        }
    }

    public void setLoggingLevel(int level) {
        try {
            if (level > 1000) {
                ErrorLogger.setLevel((Level)Level.OFF, (Boolean)true);
            } else if (level > 900) {
                ErrorLogger.setLevel((Level)Level.SEVERE, (Boolean)true);
            } else if (level > 800) {
                ErrorLogger.setLevel((Level)Level.WARNING, (Boolean)true);
            } else if (level > 700) {
                ErrorLogger.setLevel((Level)Level.INFO, (Boolean)true);
            } else if (level > 500) {
                ErrorLogger.setLevel((Level)Level.CONFIG, (Boolean)true);
            } else if (level > 400) {
                ErrorLogger.setLevel((Level)Level.FINE, (Boolean)true);
            } else if (level > 300) {
                ErrorLogger.setLevel((Level)Level.FINER, (Boolean)true);
            } else if (level > Integer.MIN_VALUE) {
                ErrorLogger.setLevel((Level)Level.FINEST, (Boolean)true);
            } else {
                ErrorLogger.setLevel((Level)Level.ALL, (Boolean)true);
            }
            ErrorLogger.LogMessage((String)"SECRenderer", (String)"setLoggingLevel(int)", (String)("Logging level set to: " + ErrorLogger.getLevel().getName()), (Level)Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"setLoggingLevel(int)", (Exception)exc, (Level)Level.INFO);
        }
    }

    public void setSinglePointUnitsFontSize(int size) {
        this.jr.setUnitSymbolSize(size);
    }

    public void setSinglePointTacticalGraphicFontSize(int size) {
        this.jr.setSinglePointTGSymbolSize(size);
    }

    public void startSinglePointServer() {
        this.startSinglePointServer(6789);
    }

    public void startSinglePointServer(int port) {
        this.startSinglePointServer(port, 0);
    }

    public void startSinglePointServer(int port, int backlog) {
        try {
            if (this.sps == null) {
                this.sps = new SinglePointServer(port, backlog);
                this.sps.start();
                this.spst = new SinglePointServerTester(this.sps);
                Thread thr1 = new Thread(this.spst);
                thr1.start();
            } else {
                System.out.println("Single Point Server already started.");
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"startSinglePointServer", (Exception)exc);
        }
    }

    public int getSinglePointServerPort() {
        if (this.sps != null) {
            return this.sps.getPortNumber();
        }
        return -1;
    }

    public Boolean isSinglePointServerRunning() {
        if (this.spst != null) {
            return this.spst.isRunning();
        }
        return false;
    }

    public void stopSinglePointServer() {
        if (this.sps != null) {
            this.sps.stop();
        }
        this.sps = null;
        this.spst = null;
    }

    public void startMultiPointServer() {
        this.startSinglePointServer(6790);
    }

    public void startMultiPointServer(int port) {
        this.startSinglePointServer(port, 0);
    }

    public void startMultiPointServer(int port, int backlog) {
        try {
            if (this.mps == null) {
                this.mps = new MultiPointServer(port, backlog);
                this.mps.start();
            } else {
                System.out.println("Multi Point Server already started.");
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"startMultiPointServer", (Exception)exc);
        }
    }

    public int getMultiPointServerPort() {
        if (this.mps != null) {
            return this.mps.getPortNumber();
        }
        return -1;
    }

    public Boolean isMultiPointServerRunning() {
        if (this.mps != null) {
            return true;
        }
        return false;
    }

    public void stopMultiPointServer() {
        if (this.mps != null) {
            this.mps.stop();
        }
        this.mps = null;
    }

    public void loadPluginsFromUrl(String url) {
        try {
            SinglePointRendererService.getInstance().AddRenderersToPath(url);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"loadDefaultPlugins", (Exception)exc);
        }
    }

    public void loadPluginsFromFile(File file) {
        try {
            SinglePointRendererService.getInstance().AddRenderersToPathByFile(file);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"loadDefaultPlugins", (Exception)exc);
        }
    }

    public void loadPluginsFromDirectory(File directory) {
        try {
            SinglePointRendererService.getInstance().AddRenderersToPathByDirectory(directory);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"loadDefaultPlugins", (Exception)exc);
        }
    }

    public void refreshPlugins() {
        SinglePointRendererService.getInstance().LoadSPRendererServices();
    }

    public ArrayList<String> getListOfLoadedPlugins() {
        return SinglePointRendererService.getInstance().getSinglePointRendererIDs();
    }

    public PNGInfo getMilStdSymbolImageFromURL(String url) {
        MilStdSymbol ms = null;
        try {
            String symbolID = url.startsWith("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
            ms = JavaRendererUtilities.createMilstdSymbol(symbolID);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getMilStdSymbolImageFromURL", (Exception)exc);
        }
        if (ms != null) {
            return this.getMilStdSymbolImage(ms);
        }
        return null;
    }

    public PNGInfo getMilStdSymbolImage(String symbolId, Map<String, String> symbolInfoMap) {
        MilStdSymbol ms = JavaRendererUtilities.createMilstdSymbol(symbolId, symbolInfoMap);
        return this.getMilStdSymbolImage(ms);
    }

    private PNGInfo getMilStdSymbolImage(MilStdSymbol ms) {
        PointConversionDummy ipc = new PointConversionDummy();
        ImageInfo ii = null;
        PNGInfo pi = null;
        try {
            if (this.jr.CanRender(ms).booleanValue()) {
                this.jr.Render(ms, (IPointConversion)ipc, null);
                ii = ms.toImageInfo();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getMilStdSymbolImage(MilStdSymbol)", (Exception)exc);
        }
        if (ii != null) {
            pi = new PNGInfo(ii);
        }
        return pi;
    }

    public PNGInfo getSymbolImageFromURL(String url) {
        String symbolID = "";
        Map<String, String> params = null;
        try {
            symbolID = url.startsWith("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
            params = JavaRendererUtilities.createParameterMapFromURL(symbolID);
            int questionIndex = symbolID.lastIndexOf(63);
            if (questionIndex != -1) {
                symbolID = URLDecoder.decode(symbolID.substring(0, questionIndex), "UTF-8");
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getSymbolImageFromURL", (Exception)exc);
        }
        return this.getSymbolImage(symbolID, params);
    }

    public PNGInfo getSymbolImage(String symbolId, Map<String, String> symbolInfoMap) {
        PNGInfo pi = null;
        ISinglePointInfo spi = null;
        String rendererID = "";
        try {
            if (symbolInfoMap.containsKey("renderer")) {
                rendererID = symbolInfoMap.get("renderer");
            } else if (symbolInfoMap.containsKey("RENDERER")) {
                rendererID = symbolInfoMap.get("RENDERER");
            }
            if (rendererID == null || rendererID.equals("")) {
                rendererID = "2525";
            }
            if (!this.sprs.hasRenderer(rendererID).booleanValue()) {
                rendererID = "2525";
            }
            if (this.sprs.hasRenderer(rendererID).booleanValue()) {
                spi = this.sprs.render(rendererID, symbolId, symbolInfoMap);
                if (spi != null) {
                    pi = new PNGInfo(spi);
                }
            } else {
                String message = "Lookup for 2525 renderer plugin failed.";
                ErrorLogger.LogMessage((String)"SECRenderer", (String)"getSymbolImage", (String)message, (Level)Level.WARNING);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getSymbolImage", (Exception)exc);
        }
        return pi;
    }

    public PNGInfo getMilStdSymbolImage(String symbolID, Map<String, String> properties, int imageSize, Boolean keepUnitRatio) {
        PNGInfo pi = null;
        ImageInfo ii = this.jr.RenderSinglePointAsImageInfo(symbolID, properties, imageSize, keepUnitRatio.booleanValue());
        if (ii != null) {
            pi = new PNGInfo(ii);
        }
        return pi;
    }

    public BufferedImage getMilStdSymbolasIcon(String symbolID, int iconSize, Boolean showDisplayModifiers) {
        return this.jr.RenderMilStdSymbolAsIcon(symbolID, iconSize, showDisplayModifiers);
    }

    public String getMilStdSymbolImageKML(String fullURL, String symbolID, Map<String, String> params) {
        String key = null;
        String value = null;
        String id = "";
        String name = "";
        String description = "";
        String lat = "";
        String lon = "";
        String alt = "";
        String size = "";
        String altMode = "";
        PNGInfo pi = null;
        try {
            pi = this.getMilStdSymbolImage(symbolID, params);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (key.equalsIgnoreCase("id")) {
                    id = value;
                    continue;
                }
                if (key.equalsIgnoreCase("name")) {
                    name = value;
                    continue;
                }
                if (key.equalsIgnoreCase("description")) {
                    description = value;
                    continue;
                }
                if (key.equalsIgnoreCase("lat")) {
                    lat = value;
                    continue;
                }
                if (key.equalsIgnoreCase("lon")) {
                    lon = value;
                    continue;
                }
                if (key.equalsIgnoreCase("alt")) {
                    alt = value;
                    continue;
                }
                if (key.equalsIgnoreCase("size")) {
                    size = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("altitudeMode")) continue;
                altMode = value;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getMilStdSymbolKML", (Exception)exc);
        }
        return this.buildKml(fullURL, id, name, description, lat, lon, alt, size, altMode, pi);
    }

    public String getSymbolImageKML(String fullURL, String symbolID, Map<String, String> params) {
        String key = null;
        String value = null;
        String id = "";
        String name = "";
        String description = "";
        String lat = "";
        String lon = "";
        String alt = "";
        String size = "";
        String altMode = "";
        StringBuilder sbParams = null;
        Boolean addToUrl = true;
        PNGInfo pi = null;
        try {
            pi = this.getSymbolImage(symbolID, params);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                addToUrl = true;
                if (key.equalsIgnoreCase("id")) {
                    id = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("name")) {
                    name = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("description")) {
                    description = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("lat")) {
                    lat = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("lon")) {
                    lon = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("alt")) {
                    alt = value;
                    addToUrl = false;
                } else if (key.equalsIgnoreCase("size")) {
                    size = value;
                } else if (key.equalsIgnoreCase("altitudeMode")) {
                    altMode = value;
                    addToUrl = false;
                }
                if (!addToUrl.booleanValue()) continue;
                if (sbParams == null) {
                    sbParams = new StringBuilder();
                    if (fullURL.contains("?")) {
                        sbParams.append("&");
                    } else {
                        sbParams.append("?");
                    }
                    sbParams.append(key);
                    sbParams.append("=");
                    sbParams.append(value);
                    continue;
                }
                sbParams.append("&");
                sbParams.append(key);
                sbParams.append("=");
                sbParams.append(value);
            }
            if (sbParams != null) {
                fullURL = fullURL + sbParams.toString();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SECRenderer", (String)"getMilStdSymbolKML", (Exception)exc);
        }
        return this.buildKml(fullURL, id, name, description, lat, lon, alt, altMode, size, pi);
    }

    private double getIconScale(double width, double height) {
        double scale1 = 28.0;
        double scale2 = 30.0;
        double iconScale = 0.0;
        iconScale = width == height ? width / scale1 : (width > height ? (height <= scale2 ? width / 28.0 : height / 28.0) : (width <= scale2 ? height / 28.0 : width / 28.0));
        return iconScale;
    }

    private String buildKml(String fullURL, String id, String name, String description, String lat, String lon, String alt, String altMode, String size, PNGInfo pi) {
        double width = pi.getImage().getWidth();
        double height = pi.getImage().getHeight();
        double iconScale = 1.0;
        if (altMode == null || altMode.equals("")) {
            altMode = "relativeToGround";
        }
        iconScale = this.getIconScale(width, height);
        StringBuilder kml = new StringBuilder();
        kml.append("<kml>");
        kml.append("<Placemark id=\"" + id + "\">");
        kml.append("<name><![CDATA[" + name + "]]></name>");
        kml.append("<description><![CDATA[" + description + "]]></description>");
        kml.append("<Style>");
        kml.append("<IconStyle>");
        kml.append("<scale>" + iconScale + "</scale>");
        kml.append("<Icon>");
        kml.append("<href><![CDATA[" + fullURL.replaceAll("kml", "image") + "]]></href>");
        kml.append("</Icon>");
        kml.append("<hotSpot x=\"" + String.valueOf(pi.getCenterPoint().getX()) + "\" y=\"" + String.valueOf(pi.getCenterPoint().getY()) + "\" xunits=\"pixels\" yunits=\"insetPixels\"/>");
        kml.append("</IconStyle>");
        kml.append("<LabelStyle>");
        kml.append("<scale>0</scale>");
        kml.append("</LabelStyle>");
        kml.append("</Style>");
        kml.append("<Point>");
        kml.append("<extrude>1</extrude>");
        kml.append("<altitudeMode>" + altMode + "</altitudeMode>");
        kml.append("<coordinates>");
        if (lon != null && !"".equals(lon) && lat != null && !"".equals(lat)) {
            kml.append(lon + ",");
            kml.append(lat);
            if (alt != null && !"".equals(alt)) {
                kml.append("," + alt);
            }
        }
        kml.append("</coordinates>");
        kml.append("</Point>");
        kml.append("</Placemark>");
        kml.append("</kml>");
        return kml.toString();
    }

    public String RenderMultiPointSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, String modifiers, int format, int symStd) {
        String output = "";
        try {
            modifiers = JavaRendererUtilities.addAltModeToModifiersString(modifiers, altitudeMode);
            if (JavaRendererUtilities.is3dSymbol(symbolCode, modifiers)) {
                output = SECWebRenderer.RenderMilStd3dSymbol(name, id, symbolCode, description, altitudeMode, controlPoints, modifiers);
                String modifierKML = MultiPointHandler.getModififerKML(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                if ((output = output.replaceFirst("</Folder>", modifierKML = modifierKML + "</Folder>")).equals("") || output.startsWith("{")) {
                    output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                }
            } else {
                output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, format, symStd);
                if (ErrorLogger.getLevel().intValue() <= Level.FINER.intValue()) {
                    System.out.println("");
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nID: " + id + "\n");
                    sb.append("Name: " + name + "\n");
                    sb.append("Description: " + description + "\n");
                    sb.append("SymbolID: " + symbolCode + "\n");
                    sb.append("SymStd: " + String.valueOf(symStd) + "\n");
                    sb.append("Scale: " + String.valueOf(scale) + "\n");
                    sb.append("BBox: " + bbox + "\n");
                    sb.append("Coords: " + controlPoints + "\n");
                    sb.append("Modifiers: " + modifiers + "\n");
                    ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"RenderSymbol", (String)sb.toString(), (Level)Level.FINER);
                }
                if (ErrorLogger.getLevel().intValue() <= Level.FINEST.intValue()) {
                    String briefOutput = output.replaceAll("</Placemark>", "</Placemark>\n");
                    briefOutput = output.replaceAll("(?s)<description[^>]*>.*?</description>", "<description></description>");
                    ErrorLogger.LogMessage((String)"SECWebRenderer", (String)"RenderSymbol", (String)("Output:\n" + briefOutput), (Level)Level.FINEST);
                }
            }
        }
        catch (Exception ea) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol - " + ea.toString() + "'}";
            ErrorLogger.LogException((String)"SECWebRenderer", (String)"RenderSymbol", (Exception)ea, (Level)Level.WARNING);
        }
        return output;
    }

    public MilStdSymbol RenderMultiPointAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, String modifiers, int symStd) {
        MilStdSymbol mSymbol = null;
        try {
            if (!JavaRendererUtilities.is3dSymbol(symbolCode, modifiers)) {
                mSymbol = MultiPointHandler.RenderSymbolAsMilStdSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, symStd);
            }
        }
        catch (Exception ea) {
            mSymbol = null;
            ErrorLogger.LogException((String)"SECRenderer", (String)"RenderSymbol", (Exception)ea, (Level)Level.WARNING);
        }
        return mSymbol;
    }

    public String RenderMultiPointSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String modifiers, int format, int symStd) {
        String output = "";
        try {
            output = MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, format, symStd);
        }
        catch (Exception exc) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol: " + symbolCode + " - " + exc.toString() + "'}";
        }
        return output;
    }

    public String ShouldClipMultipointSymbol(String symbolID) {
        if (MultiPointHandler.ShouldClipSymbol(symbolID).booleanValue()) {
            return "true";
        }
        return "false";
    }

    public Boolean isMultiPointSymbol(String symbolID) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.isMultiPointSymbol(symbolID, symStd);
    }

    public Boolean isMultiPointSymbol(String symbolID, int symStd) {
        return SymbolDefTable.getInstance().isMultiPoint(SymbolUtilities.getBasicSymbolID((String)symbolID), symStd);
    }
}

