/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import JavaLineArray.POINT2;
import JavaLineArray.ref;
import JavaTacticalRenderer.mdlGeodesic;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import sec.geo.GeoEllipse;
import sec.geo.GeoPoint;
import sec.geo.shape.APivot;

public class Ellipse
extends APivot {
    private double _semiMajor = 0.0;
    private double _semiMinor = 0.0;
    private double _rotation = 0.0;

    public Ellipse(double semiMajor, double semiMinor, double rotation) {
        this._semiMajor = semiMajor;
        this._semiMinor = semiMinor;
        this._rotation = rotation;
        this.limit = 4;
        this.flatnessDistanceMeters = 2.0;
        this.maxDistanceMeters = 200000.0;
    }

    @Override
    public Shape createShape() {
        GeoEllipse e = new GeoEllipse(this.pivot, this._semiMajor * 2.0, this._semiMinor * 2.0, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        float[] coords = new float[2];
        int type = 0;
        POINT2 pt0 = new POINT2(this.pivot.x, this.pivot.y);
        POINT2 pt = null;
        POINT2 pt1 = null;
        double R = 0.0;
        ref a12 = new ref();
        ref a21 = new ref();
        double x = 0.0;
        double y = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double rotation = this._rotation;
        if ((rotation = 90.0 - rotation) == 0.0 || this._semiMajor == this._semiMinor) {
            return e;
        }
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        PathIterator i = e.getPathIterator(null);
        while (!i.isDone()) {
            type = i.currentSegment(coords);
            pt1 = new POINT2((double)coords[0], (double)coords[1]);
            R = mdlGeodesic.geodesic_distance((POINT2)pt0, (POINT2)pt1, (ref)a12, (ref)a21);
            pt = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)R, (double)(((double[])a12.value)[0] - rotation));
            pts.add(pt);
            i.next();
        }
        Path2D path = e.getPath();
        path.reset();
        for (int j = 0; j < pts.size(); ++j) {
            x = ((POINT2)pts.get((int)j)).x;
            y = ((POINT2)pts.get((int)j)).y;
            if (j == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        return e;
    }

    public ArrayList<GeoPoint> getEllipsePoints() {
        GeoEllipse e = new GeoEllipse(this.pivot, this._semiMajor * 2.0, this._semiMinor * 2.0, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        float[] coords = new float[2];
        int type = 0;
        POINT2 pt0 = new POINT2(this.pivot.x, this.pivot.y);
        POINT2 pt = null;
        POINT2 pt1 = null;
        double R = 0.0;
        ref a12 = new ref();
        ref a21 = new ref();
        double x = 0.0;
        double y = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double rotation = this._rotation;
        rotation = 90.0 - rotation;
        ArrayList<GeoPoint> pts = new ArrayList<GeoPoint>();
        PathIterator i = e.getPathIterator(null);
        while (!i.isDone()) {
            type = i.currentSegment(coords);
            pt1 = new POINT2((double)coords[0], (double)coords[1]);
            R = mdlGeodesic.geodesic_distance((POINT2)pt0, (POINT2)pt1, (ref)a12, (ref)a21);
            pt = this._semiMajor != this._semiMinor ? mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)R, (double)(((double[])a12.value)[0] - rotation)) : pt1;
            pts.add(new GeoPoint(pt.x, pt.y));
            i.next();
        }
        Path2D path = e.getPath();
        path.reset();
        for (int j = 0; j < pts.size(); ++j) {
            x = pts.get((int)j).x;
            y = pts.get((int)j).y;
            if (j == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        return pts;
    }
}

