/*
 * Decompiled with CFR 0.152.
 */
package org.gavaghan.geodesy;

import java.io.Serializable;

public class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = -2694307956656400089L;
    private final double mSemiMajorAxis;
    private final double mSemiMinorAxis;
    private final double mFlattening;
    private final double mInverseFlattening;
    public static final Ellipsoid WGS84 = Ellipsoid.fromAAndInverseF(6378137.0, 298.257223563);
    public static final Ellipsoid GRS80 = Ellipsoid.fromAAndInverseF(6378137.0, 298.257222101);
    public static final Ellipsoid GRS67 = Ellipsoid.fromAAndInverseF(6378160.0, 298.25);
    public static final Ellipsoid ANS = Ellipsoid.fromAAndInverseF(6378160.0, 298.25);
    public static final Ellipsoid WGS72 = Ellipsoid.fromAAndInverseF(6378135.0, 298.26);
    public static final Ellipsoid Clarke1858 = Ellipsoid.fromAAndInverseF(6378293.645, 294.26);
    public static final Ellipsoid Clarke1880 = Ellipsoid.fromAAndInverseF(6378249.145, 293.465);
    public static final Ellipsoid Sphere = Ellipsoid.fromAAndF(6371000.0, 0.0);

    private Ellipsoid(double semiMajor, double semiMinor, double flattening, double inverseFlattening) {
        this.mSemiMajorAxis = semiMajor;
        this.mSemiMinorAxis = semiMinor;
        this.mFlattening = flattening;
        this.mInverseFlattening = inverseFlattening;
    }

    public static Ellipsoid fromAAndInverseF(double semiMajor, double inverseFlattening) {
        double f = 1.0 / inverseFlattening;
        double b = (1.0 - f) * semiMajor;
        return new Ellipsoid(semiMajor, b, f, inverseFlattening);
    }

    public static Ellipsoid fromAAndF(double semiMajor, double flattening) {
        double inverseF = 1.0 / flattening;
        double b = (1.0 - flattening) * semiMajor;
        return new Ellipsoid(semiMajor, b, flattening, inverseF);
    }

    public double getSemiMajorAxis() {
        return this.mSemiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.mSemiMinorAxis;
    }

    public double getFlattening() {
        return this.mFlattening;
    }

    public double getInverseFlattening() {
        return this.mInverseFlattening;
    }
}

