/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.util;

import io.github.millij.poi.ss.model.annotations.SheetColumn;
import io.github.millij.poi.util.Beans;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spreadsheet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spreadsheet.class);

    private Spreadsheet() {
    }

    public static String getCellColumnReference(String cellRef) {
        String cellColRef = cellRef.split("[0-9]*$")[0];
        return cellColRef;
    }

    public static Map<String, String> getPropertyToColumnNameMap(Class<?> beanType) {
        Method[] methods;
        Field[] fields;
        if (beanType == null) {
            throw new IllegalArgumentException("getColumnToPropertyMap :: Invalid ExcelBean type - " + beanType);
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Field f : fields = beanType.getDeclaredFields()) {
            String fieldName = f.getName();
            mapping.put(fieldName, fieldName);
            SheetColumn ec = f.getAnnotation(SheetColumn.class);
            if (ec == null || !StringUtils.isNotEmpty((CharSequence)ec.value())) continue;
            mapping.put(fieldName, ec.value());
        }
        for (Method m : methods = beanType.getDeclaredMethods()) {
            SheetColumn ec;
            String fieldName = Beans.getFieldName(m);
            if (!mapping.containsKey(fieldName)) {
                mapping.put(fieldName, fieldName);
            }
            if ((ec = m.getAnnotation(SheetColumn.class)) == null || !StringUtils.isNotEmpty((CharSequence)ec.value())) continue;
            mapping.put(fieldName, ec.value());
        }
        LOGGER.info("Bean property to Excel Column of - {} : {}", beanType, mapping);
        return Collections.unmodifiableMap(mapping);
    }

    public static Map<String, String> getColumnToPropertyMap(Class<?> beanType) {
        HashMap<String, String> columnToPropMap = new HashMap<String, String>();
        Map<String, String> propToColumnMap = Spreadsheet.getPropertyToColumnNameMap(beanType);
        for (String prop : propToColumnMap.keySet()) {
            columnToPropMap.put(propToColumnMap.get(prop), prop);
        }
        LOGGER.info("Excel Column to property map of - {} : {}", beanType, columnToPropMap);
        return Collections.unmodifiableMap(columnToPropMap);
    }

    public static List<String> getColumnNames(Class<?> beanType) {
        Map<String, String> propToColumnMap = Spreadsheet.getPropertyToColumnNameMap(beanType);
        ArrayList<String> columnNames = new ArrayList<String>(propToColumnMap.values());
        return columnNames;
    }

    public static Map<String, String> asRowDataMap(Object beanObj, List<String> colHeaders) throws Exception {
        String header;
        SheetColumn ec;
        String fieldName;
        Class<?> beanType = beanObj.getClass();
        HashMap<String, String> rowDataMap = new HashMap<String, String>();
        for (Field field : beanType.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SheetColumn.class)) continue;
            fieldName = field.getName();
            ec = field.getAnnotation(SheetColumn.class);
            String string = header = StringUtils.isEmpty((CharSequence)ec.value()) ? fieldName : ec.value();
            if (!colHeaders.contains(header)) continue;
            rowDataMap.put(header, Beans.getFieldValueAsString(beanObj, fieldName));
        }
        for (AccessibleObject accessibleObject : beanType.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(SheetColumn.class)) continue;
            fieldName = Beans.getFieldName((Method)accessibleObject);
            ec = ((Method)accessibleObject).getAnnotation(SheetColumn.class);
            String string = header = StringUtils.isEmpty((CharSequence)ec.value()) ? fieldName : ec.value();
            if (!colHeaders.contains(header)) continue;
            rowDataMap.put(header, Beans.getFieldValueAsString(beanObj, fieldName));
        }
        return rowDataMap;
    }

    public static <T> T rowAsBean(Class<T> beanClz, Map<String, String> cellProperies, Map<String, Object> cellValues) {
        if (cellValues == null || cellProperies == null) {
            return null;
        }
        try {
            T rowBean = beanClz.newInstance();
            for (String cellName : cellProperies.keySet()) {
                String propName = cellProperies.get(cellName);
                if (StringUtils.isEmpty((CharSequence)propName)) {
                    LOGGER.debug("{} : No mathching property found for column[name] - {} ", beanClz, (Object)cellName);
                    continue;
                }
                Object propValue = cellValues.get(cellName);
                try {
                    BeanUtils.setProperty(rowBean, (String)propName, (Object)propValue);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    String errMsg = String.format("Failed to set bean property - %s, value - %s", propName, propValue);
                    LOGGER.error(errMsg, (Throwable)ex);
                }
            }
            return rowBean;
        }
        catch (Exception ex) {
            String errMsg = String.format("Error while creating bean - %s, from - %s", beanClz, cellValues);
            LOGGER.error(errMsg, (Throwable)ex);
            return null;
        }
    }
}

