/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowContentsHandler;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.reader.AbstractSpreadsheetReader;
import io.github.millij.poi.util.Beans;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XlsxReader
extends AbstractSpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsxReader.class);

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsxReader :: Invalid bean type passed !");
        }
        try {
            OPCPackage opcPkg = OPCPackage.open((InputStream)is);
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            StylesTable styles = xssfReader.getStylesTable();
            ReadOnlySharedStringsTable ssTable = new ReadOnlySharedStringsTable(opcPkg);
            RowContentsHandler<T> sheetHandler = new RowContentsHandler<T>(beanClz, listener, 0);
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, ssTable, sheetHandler, true);
            XMLReader xmlParser = SAXHelper.newXMLReader();
            xmlParser.setContentHandler((ContentHandler)handler);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int i = 0;
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                String sheetName = worksheets.getSheetName();
                xmlParser.parse(new InputSource(sheetInpStream));
                sheetInpStream.close();
                ++i;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet data, to Bean %s : %s", beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, int sheetNo, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsxReader :: Invalid bean type passed !");
        }
        try {
            OPCPackage opcPkg = OPCPackage.open((InputStream)is);
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            StylesTable styles = xssfReader.getStylesTable();
            ReadOnlySharedStringsTable ssTable = new ReadOnlySharedStringsTable(opcPkg);
            RowContentsHandler<T> sheetHandler = new RowContentsHandler<T>(beanClz, listener, 0);
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, ssTable, sheetHandler, true);
            XMLReader xmlParser = SAXHelper.newXMLReader();
            xmlParser.setContentHandler((ContentHandler)handler);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int i = 0;
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                if (i == sheetNo) {
                    String sheetName = worksheets.getSheetName();
                    xmlParser.parse(new InputSource(sheetInpStream));
                    sheetInpStream.close();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to Bean %s : %s", sheetNo, beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }
}

