/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.handler;

import io.github.millij.poi.ss.handler.AbstractSheetContentsHandler;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.util.Spreadsheet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowContentsHandler<T>
extends AbstractSheetContentsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowContentsHandler.class);
    private final Class<T> beanClz;
    private final int headerRow;
    private final Map<String, String> cellPropertyMap;
    private final RowListener<T> rowListener;

    public RowContentsHandler(Class<T> beanClz, RowListener<T> rowListener) {
        this(beanClz, rowListener, 0);
    }

    public RowContentsHandler(Class<T> beanClz, RowListener<T> rowListener, int headerRow) {
        this.beanClz = beanClz;
        this.headerRow = headerRow;
        this.cellPropertyMap = new HashMap<String, String>();
        this.rowListener = rowListener;
    }

    @Override
    void beforeRowStart(int rowNum) {
    }

    @Override
    void afterRowEnd(int rowNum, Map<String, Object> rowDataMap) {
        if (rowDataMap == null || rowDataMap.isEmpty()) {
            return;
        }
        if (rowNum < this.headerRow) {
            return;
        }
        if (rowNum == this.headerRow) {
            Map<String, String> headerMap = this.prepareHeaderMap(rowNum, rowDataMap);
            this.cellPropertyMap.putAll(headerMap);
            return;
        }
        T rowBean = Spreadsheet.rowAsBean(this.beanClz, this.cellPropertyMap, rowDataMap);
        try {
            this.rowListener.row(rowNum, rowBean);
        }
        catch (Exception ex) {
            String errMsg = String.format("Error calling listener callback  row - %d, bean - %s", rowNum, rowBean);
            LOGGER.error(errMsg, (Throwable)ex);
        }
    }

    private Map<String, String> prepareHeaderMap(int rowNo, Map<String, Object> rowDataMap) {
        if (rowDataMap == null || rowDataMap.isEmpty()) {
            String errMsg = String.format("Invalid Header data found - Row #%d", rowNo);
            throw new RuntimeException(errMsg);
        }
        Map<String, String> colToBeanPropMap = Spreadsheet.getColumnToPropertyMap(this.beanClz);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String collRef : rowDataMap.keySet()) {
            String colName = String.valueOf(rowDataMap.get(collRef));
            String propName = colToBeanPropMap.get(colName);
            if (!StringUtils.isNotEmpty((CharSequence)propName)) continue;
            headerMap.put(collRef, String.valueOf(propName));
        }
        LOGGER.debug("Header DataMap prepared : {}", headerMap);
        return headerMap;
    }
}

