/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.exception;

import io.github.mightguy.spellcheck.symspell.exception.SpellCheckExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpellCheckException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(SpellCheckException.class);
    private final SpellCheckExceptionCode spellCheckExceptionCode;
    private final String customMessage;

    public SpellCheckException(SpellCheckExceptionCode code) {
        this.spellCheckExceptionCode = code;
        this.customMessage = "";
    }

    public SpellCheckException(SpellCheckExceptionCode code, String message) {
        super(message);
        this.spellCheckExceptionCode = code;
        this.customMessage = message;
    }

    public SpellCheckException(String message, Throwable cause, SpellCheckExceptionCode code) {
        super(message, cause);
        this.spellCheckExceptionCode = code;
        this.customMessage = message;
    }

    public SpellCheckException(Throwable cause, SpellCheckExceptionCode code) {
        super(cause);
        this.spellCheckExceptionCode = code;
        this.customMessage = cause.getMessage();
    }

    protected SpellCheckException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, SpellCheckExceptionCode code) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.spellCheckExceptionCode = code;
        this.customMessage = message;
    }

    public SpellCheckExceptionCode getSpellCheckExceptionCode() {
        return this.spellCheckExceptionCode;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }
}

