/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.common;

import io.github.mightguy.spellcheck.symspell.common.Verbosity;

public class SpellCheckSettings {
    private Verbosity verbosity;
    private int topK;
    private float deletionWeight;
    private float insertionWeight;
    private float replaceWeight;
    private float transpositionWeight;
    private boolean lowerCaseTerms;
    private double maxEditDistance;
    private int prefixLength;
    private long countThreshold;
    private int maxLength;
    private double bigramCountMin;
    private boolean ignoreUnknown;
    private double editFactor;
    private boolean doKeySplit;
    private String keySplitRegex;

    private static Verbosity $default$verbosity() {
        return Verbosity.ALL;
    }

    private static int $default$topK() {
        return 10;
    }

    private static float $default$deletionWeight() {
        return 1.0f;
    }

    private static float $default$insertionWeight() {
        return 1.0f;
    }

    private static float $default$replaceWeight() {
        return 1.0f;
    }

    private static float $default$transpositionWeight() {
        return 1.0f;
    }

    private static boolean $default$lowerCaseTerms() {
        return true;
    }

    private static double $default$maxEditDistance() {
        return 2.0;
    }

    private static int $default$prefixLength() {
        return 7;
    }

    private static long $default$countThreshold() {
        return 1L;
    }

    private static int $default$maxLength() {
        return Integer.MAX_VALUE;
    }

    private static double $default$bigramCountMin() {
        return Double.MAX_VALUE;
    }

    private static boolean $default$ignoreUnknown() {
        return true;
    }

    private static double $default$editFactor() {
        return 0.3;
    }

    private static boolean $default$doKeySplit() {
        return true;
    }

    private static String $default$keySplitRegex() {
        return "\\s+";
    }

    SpellCheckSettings(Verbosity verbosity, int topK, float deletionWeight, float insertionWeight, float replaceWeight, float transpositionWeight, boolean lowerCaseTerms, double maxEditDistance, int prefixLength, long countThreshold, int maxLength, double bigramCountMin, boolean ignoreUnknown, double editFactor, boolean doKeySplit, String keySplitRegex) {
        this.verbosity = verbosity;
        this.topK = topK;
        this.deletionWeight = deletionWeight;
        this.insertionWeight = insertionWeight;
        this.replaceWeight = replaceWeight;
        this.transpositionWeight = transpositionWeight;
        this.lowerCaseTerms = lowerCaseTerms;
        this.maxEditDistance = maxEditDistance;
        this.prefixLength = prefixLength;
        this.countThreshold = countThreshold;
        this.maxLength = maxLength;
        this.bigramCountMin = bigramCountMin;
        this.ignoreUnknown = ignoreUnknown;
        this.editFactor = editFactor;
        this.doKeySplit = doKeySplit;
        this.keySplitRegex = keySplitRegex;
    }

    public static SpellCheckSettingsBuilder builder() {
        return new SpellCheckSettingsBuilder();
    }

    public String toString() {
        return "SpellCheckSettings(verbosity=" + (Object)((Object)this.getVerbosity()) + ", topK=" + this.getTopK() + ", deletionWeight=" + this.getDeletionWeight() + ", insertionWeight=" + this.getInsertionWeight() + ", replaceWeight=" + this.getReplaceWeight() + ", transpositionWeight=" + this.getTranspositionWeight() + ", lowerCaseTerms=" + this.isLowerCaseTerms() + ", maxEditDistance=" + this.getMaxEditDistance() + ", prefixLength=" + this.getPrefixLength() + ", countThreshold=" + this.getCountThreshold() + ", maxLength=" + this.getMaxLength() + ", bigramCountMin=" + this.getBigramCountMin() + ", ignoreUnknown=" + this.isIgnoreUnknown() + ", editFactor=" + this.getEditFactor() + ", doKeySplit=" + this.isDoKeySplit() + ", keySplitRegex=" + this.getKeySplitRegex() + ")";
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public int getTopK() {
        return this.topK;
    }

    public float getDeletionWeight() {
        return this.deletionWeight;
    }

    public float getInsertionWeight() {
        return this.insertionWeight;
    }

    public float getReplaceWeight() {
        return this.replaceWeight;
    }

    public float getTranspositionWeight() {
        return this.transpositionWeight;
    }

    public boolean isLowerCaseTerms() {
        return this.lowerCaseTerms;
    }

    public double getMaxEditDistance() {
        return this.maxEditDistance;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public long getCountThreshold() {
        return this.countThreshold;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public double getBigramCountMin() {
        return this.bigramCountMin;
    }

    public boolean isIgnoreUnknown() {
        return this.ignoreUnknown;
    }

    public double getEditFactor() {
        return this.editFactor;
    }

    public boolean isDoKeySplit() {
        return this.doKeySplit;
    }

    public String getKeySplitRegex() {
        return this.keySplitRegex;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setBigramCountMin(double bigramCountMin) {
        this.bigramCountMin = bigramCountMin;
    }

    public static class SpellCheckSettingsBuilder {
        private boolean verbosity$set;
        private Verbosity verbosity$value;
        private boolean topK$set;
        private int topK$value;
        private boolean deletionWeight$set;
        private float deletionWeight$value;
        private boolean insertionWeight$set;
        private float insertionWeight$value;
        private boolean replaceWeight$set;
        private float replaceWeight$value;
        private boolean transpositionWeight$set;
        private float transpositionWeight$value;
        private boolean lowerCaseTerms$set;
        private boolean lowerCaseTerms$value;
        private boolean maxEditDistance$set;
        private double maxEditDistance$value;
        private boolean prefixLength$set;
        private int prefixLength$value;
        private boolean countThreshold$set;
        private long countThreshold$value;
        private boolean maxLength$set;
        private int maxLength$value;
        private boolean bigramCountMin$set;
        private double bigramCountMin$value;
        private boolean ignoreUnknown$set;
        private boolean ignoreUnknown$value;
        private boolean editFactor$set;
        private double editFactor$value;
        private boolean doKeySplit$set;
        private boolean doKeySplit$value;
        private boolean keySplitRegex$set;
        private String keySplitRegex$value;

        SpellCheckSettingsBuilder() {
        }

        public SpellCheckSettingsBuilder verbosity(Verbosity verbosity) {
            this.verbosity$value = verbosity;
            this.verbosity$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder deletionWeight(float deletionWeight) {
            this.deletionWeight$value = deletionWeight;
            this.deletionWeight$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder insertionWeight(float insertionWeight) {
            this.insertionWeight$value = insertionWeight;
            this.insertionWeight$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder replaceWeight(float replaceWeight) {
            this.replaceWeight$value = replaceWeight;
            this.replaceWeight$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder transpositionWeight(float transpositionWeight) {
            this.transpositionWeight$value = transpositionWeight;
            this.transpositionWeight$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder lowerCaseTerms(boolean lowerCaseTerms) {
            this.lowerCaseTerms$value = lowerCaseTerms;
            this.lowerCaseTerms$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder maxEditDistance(double maxEditDistance) {
            this.maxEditDistance$value = maxEditDistance;
            this.maxEditDistance$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder prefixLength(int prefixLength) {
            this.prefixLength$value = prefixLength;
            this.prefixLength$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder countThreshold(long countThreshold) {
            this.countThreshold$value = countThreshold;
            this.countThreshold$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder maxLength(int maxLength) {
            this.maxLength$value = maxLength;
            this.maxLength$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder bigramCountMin(double bigramCountMin) {
            this.bigramCountMin$value = bigramCountMin;
            this.bigramCountMin$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder ignoreUnknown(boolean ignoreUnknown) {
            this.ignoreUnknown$value = ignoreUnknown;
            this.ignoreUnknown$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder editFactor(double editFactor) {
            this.editFactor$value = editFactor;
            this.editFactor$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder doKeySplit(boolean doKeySplit) {
            this.doKeySplit$value = doKeySplit;
            this.doKeySplit$set = true;
            return this;
        }

        public SpellCheckSettingsBuilder keySplitRegex(String keySplitRegex) {
            this.keySplitRegex$value = keySplitRegex;
            this.keySplitRegex$set = true;
            return this;
        }

        public SpellCheckSettings build() {
            Verbosity verbosity$value = this.verbosity$value;
            if (!this.verbosity$set) {
                verbosity$value = SpellCheckSettings.$default$verbosity();
            }
            int topK$value = this.topK$value;
            if (!this.topK$set) {
                topK$value = SpellCheckSettings.$default$topK();
            }
            float deletionWeight$value = this.deletionWeight$value;
            if (!this.deletionWeight$set) {
                deletionWeight$value = SpellCheckSettings.$default$deletionWeight();
            }
            float insertionWeight$value = this.insertionWeight$value;
            if (!this.insertionWeight$set) {
                insertionWeight$value = SpellCheckSettings.$default$insertionWeight();
            }
            float replaceWeight$value = this.replaceWeight$value;
            if (!this.replaceWeight$set) {
                replaceWeight$value = SpellCheckSettings.$default$replaceWeight();
            }
            float transpositionWeight$value = this.transpositionWeight$value;
            if (!this.transpositionWeight$set) {
                transpositionWeight$value = SpellCheckSettings.$default$transpositionWeight();
            }
            boolean lowerCaseTerms$value = this.lowerCaseTerms$value;
            if (!this.lowerCaseTerms$set) {
                lowerCaseTerms$value = SpellCheckSettings.$default$lowerCaseTerms();
            }
            double maxEditDistance$value = this.maxEditDistance$value;
            if (!this.maxEditDistance$set) {
                maxEditDistance$value = SpellCheckSettings.$default$maxEditDistance();
            }
            int prefixLength$value = this.prefixLength$value;
            if (!this.prefixLength$set) {
                prefixLength$value = SpellCheckSettings.$default$prefixLength();
            }
            long countThreshold$value = this.countThreshold$value;
            if (!this.countThreshold$set) {
                countThreshold$value = SpellCheckSettings.$default$countThreshold();
            }
            int maxLength$value = this.maxLength$value;
            if (!this.maxLength$set) {
                maxLength$value = SpellCheckSettings.$default$maxLength();
            }
            double bigramCountMin$value = this.bigramCountMin$value;
            if (!this.bigramCountMin$set) {
                bigramCountMin$value = SpellCheckSettings.$default$bigramCountMin();
            }
            boolean ignoreUnknown$value = this.ignoreUnknown$value;
            if (!this.ignoreUnknown$set) {
                ignoreUnknown$value = SpellCheckSettings.$default$ignoreUnknown();
            }
            double editFactor$value = this.editFactor$value;
            if (!this.editFactor$set) {
                editFactor$value = SpellCheckSettings.$default$editFactor();
            }
            boolean doKeySplit$value = this.doKeySplit$value;
            if (!this.doKeySplit$set) {
                doKeySplit$value = SpellCheckSettings.$default$doKeySplit();
            }
            String keySplitRegex$value = this.keySplitRegex$value;
            if (!this.keySplitRegex$set) {
                keySplitRegex$value = SpellCheckSettings.$default$keySplitRegex();
            }
            return new SpellCheckSettings(verbosity$value, topK$value, deletionWeight$value, insertionWeight$value, replaceWeight$value, transpositionWeight$value, lowerCaseTerms$value, maxEditDistance$value, prefixLength$value, countThreshold$value, maxLength$value, bigramCountMin$value, ignoreUnknown$value, editFactor$value, doKeySplit$value, keySplitRegex$value);
        }

        public String toString() {
            return "SpellCheckSettings.SpellCheckSettingsBuilder(verbosity$value=" + (Object)((Object)this.verbosity$value) + ", topK$value=" + this.topK$value + ", deletionWeight$value=" + this.deletionWeight$value + ", insertionWeight$value=" + this.insertionWeight$value + ", replaceWeight$value=" + this.replaceWeight$value + ", transpositionWeight$value=" + this.transpositionWeight$value + ", lowerCaseTerms$value=" + this.lowerCaseTerms$value + ", maxEditDistance$value=" + this.maxEditDistance$value + ", prefixLength$value=" + this.prefixLength$value + ", countThreshold$value=" + this.countThreshold$value + ", maxLength$value=" + this.maxLength$value + ", bigramCountMin$value=" + this.bigramCountMin$value + ", ignoreUnknown$value=" + this.ignoreUnknown$value + ", editFactor$value=" + this.editFactor$value + ", doKeySplit$value=" + this.doKeySplit$value + ", keySplitRegex$value=" + this.keySplitRegex$value + ")";
        }
    }
}

