/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.common;

import io.github.mightguy.spellcheck.symspell.api.CharDistance;
import java.util.HashMap;
import java.util.Map;

public class QwertzDistance
implements CharDistance {
    double directConnect = 0.1f;
    double diagonalConnect = 0.4f;
    double defaultValue = 1.0;
    Map<String, Double> operationCost = new HashMap<String, Double>();

    public QwertzDistance() {
        this.initializeCostMatrix();
    }

    @Override
    public double distance(char a, char b) {
        if (a == b) {
            return 0.0;
        }
        return this.operationCost.getOrDefault(a + "-" + b, this.operationCost.getOrDefault(b + "-" + a, this.defaultValue));
    }

    public void initializeCostMatrix() {
        this.addReplaceWeight('a', "s", this.directConnect);
        this.addReplaceWeight('a', "qwy", this.diagonalConnect);
        this.addReplaceWeight('s', "ad", this.directConnect);
        this.addReplaceWeight('s', "wexy", this.diagonalConnect);
        this.addReplaceWeight('d', "sf", this.directConnect);
        this.addReplaceWeight('d', "erxc", this.diagonalConnect);
        this.addReplaceWeight('f', "sf", this.directConnect);
        this.addReplaceWeight('f', "erxc", this.diagonalConnect);
        this.addReplaceWeight('g', "fh", this.directConnect);
        this.addReplaceWeight('g', "tzvb", this.diagonalConnect);
        this.addReplaceWeight('h', "gj", this.directConnect);
        this.addReplaceWeight('h', "zubn", this.diagonalConnect);
        this.addReplaceWeight('j', "hk", this.directConnect);
        this.addReplaceWeight('j', "uinm", this.diagonalConnect);
        this.addReplaceWeight('k', "jl", this.directConnect);
        this.addReplaceWeight('k', "iom", this.diagonalConnect);
        this.addReplaceWeight('l', "k\u00f6", this.directConnect);
        this.addReplaceWeight('l', "op", this.diagonalConnect);
        this.addReplaceWeight('\u00f6', "l\u00e4", this.directConnect);
        this.addReplaceWeight('\u00f6', "p\u00fc", this.diagonalConnect);
        this.addReplaceWeight('\u00e4', "\u00f6", this.directConnect);
        this.addReplaceWeight('\u00e4', "\u00fc", this.diagonalConnect);
        this.addReplaceWeight('q', "w", this.directConnect);
        this.addReplaceWeight('q', "a", this.diagonalConnect);
        this.addReplaceWeight('w', "qe", this.directConnect);
        this.addReplaceWeight('w', "as", this.diagonalConnect);
        this.addReplaceWeight('e', "wr", this.directConnect);
        this.addReplaceWeight('e', "sd", this.diagonalConnect);
        this.addReplaceWeight('r', "et", this.directConnect);
        this.addReplaceWeight('r', "df", this.diagonalConnect);
        this.addReplaceWeight('t', "rz", this.directConnect);
        this.addReplaceWeight('t', "fg", this.diagonalConnect);
        this.addReplaceWeight('z', "tu", this.directConnect);
        this.addReplaceWeight('z', "gh", this.diagonalConnect);
        this.addReplaceWeight('u', "zi", this.directConnect);
        this.addReplaceWeight('u', "hj", this.diagonalConnect);
        this.addReplaceWeight('i', "uo", this.directConnect);
        this.addReplaceWeight('i', "jk", this.diagonalConnect);
        this.addReplaceWeight('o', "ip", this.directConnect);
        this.addReplaceWeight('o', "kl", this.diagonalConnect);
        this.addReplaceWeight('p', "o\u00fc", this.directConnect);
        this.addReplaceWeight('p', "l\u00f6", this.diagonalConnect);
        this.addReplaceWeight('\u00fc', "p", this.directConnect);
        this.addReplaceWeight('\u00fc', "\u00f6\u00e4", this.diagonalConnect);
        this.addReplaceWeight('y', "x", this.directConnect);
        this.addReplaceWeight('y', "sa", this.diagonalConnect);
        this.addReplaceWeight('x', "yc", this.directConnect);
        this.addReplaceWeight('x', "sd", this.diagonalConnect);
        this.addReplaceWeight('c', "xv", this.directConnect);
        this.addReplaceWeight('c', "df", this.diagonalConnect);
        this.addReplaceWeight('v', "bc", this.directConnect);
        this.addReplaceWeight('v', "fg", this.diagonalConnect);
        this.addReplaceWeight('b', "vn", this.directConnect);
        this.addReplaceWeight('b', "gh", this.diagonalConnect);
        this.addReplaceWeight('n', "bm", this.directConnect);
        this.addReplaceWeight('n', "hj", this.diagonalConnect);
        this.addReplaceWeight('m', "n", this.directConnect);
        this.addReplaceWeight('m', "jk", this.diagonalConnect);
    }

    private void addReplaceWeight(char a, String listOfChars, double connectWeight) {
        for (char ch : listOfChars.toCharArray()) {
            this.operationCost.put(a + "-" + ch, connectWeight);
        }
    }

    public void addReplaceWeight(char a, char b, double connectWeight) {
        this.operationCost.put(a + "-" + b, connectWeight);
    }
}

