/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soap;

import io.github.microcks.util.XmlSchemaValidator;
import io.github.microcks.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SoapMessageValidator {
    private static Logger log = LoggerFactory.getLogger(SoapMessageValidator.class);
    private static final String SOAP_ENVELOPE_SCHEMA = "soap-envelope.xsd";
    private static final String SOAP_ENVELOPE_12_SCHEMA = "soap-envelope-12.xsd";
    public static final String SOAP_ENVELOPE_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_ENVELOPE_12_NS = "http://www.w3.org/2003/05/soap-envelope";
    private static final Pattern XML_NS_CAPTURE_PATTERN = Pattern.compile("xmlns:(\\w+)=\"([^\"]*)\"", 32);

    private SoapMessageValidator() {
    }

    public static List<String> validateSoapEnvelope(String message) {
        InputStream schemaStream;
        ArrayList<String> errors = new ArrayList<String>();
        if (message.contains(SOAP_ENVELOPE_12_NS)) {
            schemaStream = SoapMessageValidator.class.getClassLoader().getResourceAsStream(SOAP_ENVELOPE_12_SCHEMA);
        } else if (message.contains(SOAP_ENVELOPE_NS)) {
            schemaStream = SoapMessageValidator.class.getClassLoader().getResourceAsStream(SOAP_ENVELOPE_SCHEMA);
        } else {
            errors.add("Soap envelope does not appear to be valid: unrecognized namespace");
            return errors;
        }
        try {
            errors.addAll(XmlSchemaValidator.validateXml(schemaStream, message));
        }
        catch (Exception e) {
            log.error("Exception while validating Soap envelope for message: {}", (Object)e.getMessage());
            errors.add("Exception while validating Soap envelope for message: " + e.getMessage());
        }
        log.debug("SoapEnvelope validation errors: {}", (Object)errors.size());
        return errors;
    }

    public static List<String> validateSoapMessage(String wsdlContent, QName partQName, String message, String resourceUrl) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(SoapMessageValidator.validateSoapEnvelope(message));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Element wsdlElement = documentBuilder.parse(new InputSource(new StringReader(wsdlContent))).getDocumentElement();
            Element wsdlTypes = XmlUtil.getUniqueDirectChild(wsdlElement, "http://schemas.xmlsoap.org/wsdl/", "types");
            Element xsSchema = XmlUtil.getUniqueDirectChild(wsdlTypes, "http://www.w3.org/2001/XMLSchema", "schema");
            NamedNodeMap definitionsAttributes = wsdlElement.getAttributes();
            for (int i = 0; i < definitionsAttributes.getLength(); ++i) {
                Node attribute = definitionsAttributes.item(i);
                String name = attribute.getNodeName();
                if (!name.startsWith("xmlns:") || xsSchema.hasAttribute(name)) continue;
                xsSchema.setAttribute(name, attribute.getNodeValue());
            }
            TransformerFactory transformerFactory = TransformerFactory.newDefaultInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(xsSchema), new StreamResult(out));
            String schemaContent = ((Object)out).toString();
            Matcher nsMatcher = XML_NS_CAPTURE_PATTERN.matcher(message);
            HashMap<String, String> nsToPrefix = new HashMap<String, String>();
            StringBuilder nsBuilder = new StringBuilder();
            while (nsMatcher.find()) {
                nsBuilder.append(" ").append(nsMatcher.group(0));
                nsToPrefix.put(nsMatcher.group(2), nsMatcher.group(1));
            }
            Object body = message;
            int bodyStart = ((String)body).indexOf(":Body");
            int bodyEnd = ((String)body).lastIndexOf(":Body>");
            body = ((String)body).substring(bodyStart + 5, bodyEnd);
            int firstClosingTag = ((String)body).indexOf(">");
            int lastClosingTag = ((String)body).lastIndexOf("</");
            body = ((String)body).substring(firstClosingTag + 1, lastClosingTag).trim();
            body = ((String)body).replaceAll(" " + XML_NS_CAPTURE_PATTERN.pattern(), "");
            body = ((String)body).substring(0, ((String)body).indexOf(62)) + nsBuilder + ((String)body).substring(((String)body).indexOf(62));
            log.debug("Soap message body to validate: {}", body);
            String expectedStartTag = "<" + (String)nsToPrefix.get(partQName.getNamespaceURI()) + ":" + partQName.getLocalPart();
            String expectedEndTag = "</" + (String)nsToPrefix.get(partQName.getNamespaceURI()) + ":" + partQName.getLocalPart() + ">";
            if (!((String)body).startsWith(expectedStartTag) || !((String)body).endsWith(expectedEndTag)) {
                errors.add("Expecting a " + partQName + " element but got another one");
            }
            errors.addAll(XmlSchemaValidator.validateXml(new ByteArrayInputStream(schemaContent.getBytes(StandardCharsets.UTF_8)), (String)body, resourceUrl));
        }
        catch (Exception e) {
            log.error("Exception while validating Soap message: {}", (Object)e.getMessage());
            errors.add("Exception while validating Soap message: " + e.getMessage());
        }
        log.debug("SoapMessage validation errors: {}", (Object)errors.size());
        return errors;
    }
}

