/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.github.microcks.util.AvroUtil;
import io.github.microcks.util.SchemaMap;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPISchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(AsyncAPISchemaUtil.class);
    public static final String ASYNC_SCHEMA_PAYLOAD_ELEMENT = "payload";
    private static final String ONE_OF_STRUCT = "oneOf";

    private AsyncAPISchemaUtil() {
    }

    public static String findMessagePathPointer(JsonNode specificationNode, String operationName) {
        Object messagePathPointer = "";
        String[] operationElements = operationName.split(" ");
        String asyncApi = specificationNode.path("asyncapi").asText("2");
        if (asyncApi.startsWith("3")) {
            String operationNamePtr = "/operations/" + operationElements[1].replace("/", "~1");
            messagePathPointer = operationNamePtr + "/messages";
        } else {
            String operationNamePtr = "/channels/" + operationElements[1].replace("/", "~1");
            operationNamePtr = "SUBSCRIBE".equals(operationElements[0]) ? operationNamePtr + "/subscribe" : operationNamePtr + "/publish";
            messagePathPointer = operationNamePtr + "/message";
        }
        return messagePathPointer;
    }

    public static Schema retrieveMessageAvroSchema(JsonNode specificationNode, String messagePathPointer, SchemaMap schemaMap) throws Exception {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            throw new Exception("messagePathPointer does not represent a valid JSON Pointer in AsyncAPI specification");
        }
        if ((messageNode = AsyncAPISchemaUtil.followRefIfAny(messageNode, specificationNode)).isArray()) {
            ArrayNode messagesNode = (ArrayNode)messageNode;
            if (messagesNode.size() > 1) {
                return AsyncAPISchemaUtil.buildOneOfMessagesAvroSchemas(specificationNode, (ArrayNode)messageNode, schemaMap);
            }
            return AsyncAPISchemaUtil.buildSingleMessageAvroSchema(AsyncAPISchemaUtil.followRefIfAny(messagesNode.get(0), specificationNode), schemaMap);
        }
        if (messageNode.has(ONE_OF_STRUCT)) {
            ArrayNode oneOfMessageNode = (ArrayNode)messageNode.get(ONE_OF_STRUCT);
            return AsyncAPISchemaUtil.buildOneOfMessagesAvroSchemas(specificationNode, oneOfMessageNode, schemaMap);
        }
        return AsyncAPISchemaUtil.buildSingleMessageAvroSchema(messageNode, schemaMap);
    }

    private static Schema buildOneOfMessagesAvroSchemas(JsonNode specificationNode, ArrayNode oneOfMessageNode, SchemaMap schemaMap) throws Exception {
        Schema[] schemas = new Schema[oneOfMessageNode.size()];
        for (int i = 0; i < oneOfMessageNode.size(); ++i) {
            JsonNode altMessageNode = oneOfMessageNode.get(i);
            altMessageNode = AsyncAPISchemaUtil.followRefIfAny(altMessageNode, specificationNode);
            schemas[i] = AsyncAPISchemaUtil.buildSingleMessageAvroSchema(altMessageNode, schemaMap);
        }
        return Schema.createUnion((Schema[])schemas);
    }

    private static Schema buildSingleMessageAvroSchema(JsonNode messageNode, SchemaMap schemaMap) throws Exception {
        if (!messageNode.has(ASYNC_SCHEMA_PAYLOAD_ELEMENT)) {
            log.debug("messageNode {} has no 'payload' attribute", (Object)messageNode);
            throw new Exception("message definition has no valid payload in AsyncAPI specification");
        }
        messageNode = messageNode.path(ASYNC_SCHEMA_PAYLOAD_ELEMENT);
        String schemaContent = null;
        if (messageNode.has("$ref")) {
            String ref = messageNode.path("$ref").asText();
            log.debug("Looking for an external Avro schema in registry: {}", (Object)ref);
            if (ref.contains("#")) {
                ref = ref.substring(0, ref.indexOf("#"));
            }
            if (schemaMap != null) {
                schemaContent = schemaMap.getSchemaEntry(ref);
            }
            if (schemaContent == null) {
                log.info("No schema content found in SchemaMap. {} is not found", (Object)ref);
                throw new Exception("no schema content found for " + ref + " in used SchemaMap.");
            }
        } else {
            schemaContent = messageNode.toString();
        }
        return AvroUtil.getSchema(schemaContent);
    }

    public static JsonNode followRefIfAny(JsonNode referencableNode, JsonNode documentRoot) {
        if (referencableNode.has("$ref")) {
            String ref = referencableNode.path("$ref").asText();
            return AsyncAPISchemaUtil.followRefIfAny(documentRoot.at(ref.substring(1)), documentRoot);
        }
        return referencableNode;
    }
}

